/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.transaction;

import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.slide.transaction.SlideTransaction;
import org.apache.slide.util.Messages;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.util.logger.SimpleLogger;

public final class SlideTransactionManager
implements TransactionManager {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$transaction$SlideTransactionManager == null ? (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager")) : class$org$apache$slide$transaction$SlideTransactionManager).getName();
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30;
    private Hashtable bindings = new Hashtable();
    private Hashtable timeouts = new Hashtable();
    private Logger logger = new SimpleLogger();
    static /* synthetic */ Class class$org$apache$slide$transaction$SlideTransactionManager;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction != null) {
            throw new NotSupportedException();
        }
        currentTransaction = new SlideTransaction(this);
        this.bindings.put(Thread.currentThread(), currentTransaction);
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format((class$org$apache$slide$transaction$SlideTransactionManager == null ? (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager")) : class$org$apache$slide$transaction$SlideTransactionManager).getName() + ".begin", currentTransaction.toString());
            this.logger.log(logMessage, LOG_CHANNEL, 7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Thread currentThread = Thread.currentThread();
        Transaction currentTransaction = (Transaction)this.bindings.get(currentThread);
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        this.timeouts.remove(currentThread);
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format((class$org$apache$slide$transaction$SlideTransactionManager == null ? (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager")) : class$org$apache$slide$transaction$SlideTransactionManager).getName() + ".commit", currentTransaction.toString());
            this.logger.log(logMessage, LOG_CHANNEL, 7);
        }
        try {
            currentTransaction.commit();
        }
        finally {
            this.bindings.remove(currentThread);
        }
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        Thread currentThread = Thread.currentThread();
        Transaction currentTransaction = (Transaction)this.bindings.remove(currentThread);
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        this.timeouts.remove(currentThread);
        String logMessage = Messages.format((class$org$apache$slide$transaction$SlideTransactionManager == null ? (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager")) : class$org$apache$slide$transaction$SlideTransactionManager).getName() + ".rollback", currentTransaction.toString());
        this.logger.log(logMessage, LOG_CHANNEL, 7);
        currentTransaction.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        String logMessage = Messages.format((class$org$apache$slide$transaction$SlideTransactionManager == null ? (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager")) : class$org$apache$slide$transaction$SlideTransactionManager).getName() + ".rollbackOnly", currentTransaction.toString());
        this.logger.log(logMessage, LOG_CHANNEL, 6);
        currentTransaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction == null) {
            return 6;
        }
        return currentTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.bindings.get(Thread.currentThread());
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        if (tobj == null) {
            throw new InvalidTransactionException();
        }
        this.bindings.put(Thread.currentThread(), tobj);
    }

    public Transaction suspend() throws SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction != null) {
            Thread currentThread = Thread.currentThread();
            this.bindings.remove(currentThread);
            this.timeouts.remove(currentThread);
        }
        return currentTransaction;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeouts.put(Thread.currentThread(), new Integer(seconds));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

