/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.structure;

import java.util.Vector;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.structure.ObjectNode;
import org.jdom.Namespace;

public class ActionNode
extends ObjectNode {
    public static final String DEFAULT_URI = "default";
    public static final String ALL_URI = "all";
    public static final ActionNode DEFAULT = new ActionNode("default", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
    public static final ActionNode ALL = new ActionNode("all", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
    private Namespace namespace;

    public ActionNode() {
    }

    public ActionNode(String uri) {
        super(uri);
    }

    public ActionNode(String uri, Vector children, Vector links) {
        super(uri, children, links);
    }

    public ActionNode(String uuri, Vector bindings, Vector parentBindings, Vector links) {
        super(uuri, bindings, parentBindings, links);
    }

    public ActionNode(String uri, Namespace namespace) {
        super(uri);
        this.namespace = namespace;
    }

    public static ActionNode getActionNode(String actionUri) {
        if (ALL_URI.equals(actionUri)) {
            return ALL;
        }
        return new ActionNode(actionUri);
    }

    public static ActionNode getActionNode(String actionUri, Namespace namespace) {
        if (ALL_URI.equals(actionUri) && NodeProperty.NamespaceCache.DEFAULT_NAMESPACE.equals((Object)namespace)) {
            return ALL;
        }
        return new ActionNode(actionUri, namespace);
    }

    public Namespace getNamespace() {
        if (this.namespace == null) {
            throw new IllegalStateException("Namespace retrieved without being specified");
        }
        return this.namespace;
    }
}

