/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.util.Enumeration;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.security.SecurityImpl;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.GroupNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;

public final class SecurityImplAllGrant
extends SecurityImpl
implements Security {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$security$SecurityImplAllGrant == null ? (class$org$apache$slide$security$SecurityImplAllGrant = SecurityImplAllGrant.class$("org.apache.slide.security.SecurityImplAllGrant")) : class$org$apache$slide$security$SecurityImplAllGrant).getName();
    static /* synthetic */ Class class$org$apache$slide$security$SecurityImplAllGrant;

    public SecurityImplAllGrant() {
    }

    public SecurityImplAllGrant(Namespace namespace, NamespaceConfig namespaceConfig) {
        super(namespace, namespaceConfig);
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        if (action.equals(ActionNode.DEFAULT)) {
            return true;
        }
        boolean granted = false;
        boolean denied = false;
        boolean rootObjectReached = false;
        ObjectNode courObject = object;
        Uri subjectUri = this.namespace.getUri(subject.getUri());
        Uri actionUri = this.namespace.getUri(action.getUri());
        while (!(granted || denied || rootObjectReached)) {
            Uri courUri = this.namespace.getUri(courObject.getUri());
            Enumeration permissions = courUri.getStore().enumeratePermissions(courUri);
            while (!granted && !denied && permissions.hasMoreElements()) {
                boolean oldGranted = granted;
                boolean oldDenied = denied;
                NodePermission permission = (NodePermission)permissions.nextElement();
                String permissionSubject = permission.getSubjectUri();
                if (permissionSubject.equals("self")) {
                    boolean check = object.getUri().equals(subjectUri.toString());
                    if (permission.isInheritable()) {
                        String subjectUriString = subjectUri.toString();
                        if (!subjectUriString.endsWith("/")) {
                            subjectUriString = subjectUriString + "/";
                        }
                        check |= object.getUri().startsWith(subjectUriString);
                    }
                    granted = !permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                    denied = permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                } else if (permission.isInheritable() || permission.getObjectUri().equals(object.getUri())) {
                    if (permissionSubject.startsWith("/") || permissionSubject.equals("all")) {
                        String permSubj = permission.getSubjectUri();
                        String permActn = permission.getActionUri();
                        boolean match = false;
                        if (permSubj.equals("all")) {
                            match = true;
                        } else {
                            if (!permSubj.endsWith("/")) {
                                permSubj = permSubj + "/";
                            }
                            boolean bl = match = subjectUri.toString().equals(permission.getSubjectUri()) || subjectUri.toString().startsWith(permSubj);
                        }
                        match = permActn.equals("all") ? (match &= true) : (match &= actionUri.toString().startsWith(permActn));
                        granted = !permission.isNegative() && match;
                        denied = permission.isNegative() && match;
                    } else if (permissionSubject.startsWith("+")) {
                        ObjectNode group;
                        Uri permissionSubjectUri = this.namespace.getUri(permissionSubject.substring(1));
                        try {
                            group = permissionSubjectUri.getStore().retrieveObject(permissionSubjectUri);
                        }
                        catch (ObjectNotFoundException onfe) {
                            this.namespace.getLogger().log("Gracefully ignoring permission of dangling subject " + permissionSubjectUri, onfe, LOG_CHANNEL, 4);
                            continue;
                        }
                        if (group instanceof GroupNode && group.hasChildren()) {
                            Enumeration groupMembers = group.enumerateChildren();
                            while (groupMembers.hasMoreElements()) {
                                ObjectNode childNode;
                                oldGranted = granted;
                                oldDenied = denied;
                                Uri childUri = this.namespace.getUri((String)groupMembers.nextElement());
                                try {
                                    childNode = childUri.getStore().retrieveObject(childUri);
                                }
                                catch (ObjectNotFoundException onfe) {
                                    this.namespace.getLogger().log("Gracefully ignoring permission of dangling subject " + childUri, onfe, LOG_CHANNEL, 4);
                                    continue;
                                }
                                String childSubjectUri = childNode instanceof LinkNode ? ((LinkNode)childNode).getLinkedUri() : childNode.getUri();
                                String testUri = !childSubjectUri.endsWith("/") ? childSubjectUri + "/" : childSubjectUri;
                                boolean match = subjectUri.toString().equals(childSubjectUri) || subjectUri.toString().startsWith(testUri);
                                granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                                denied = permission.isNegative() && match;
                                granted |= oldGranted;
                                denied |= oldDenied;
                            }
                        }
                    } else {
                        granted = !permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                        denied = permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                    }
                }
                granted |= oldGranted;
                denied |= oldDenied;
            }
            Uri parentUri = courUri.getParentUri();
            if (parentUri != null) {
                courObject = parentUri.getStore().retrieveObject(parentUri);
                continue;
            }
            rootObjectReached = true;
        }
        if (denied) {
            return false;
        }
        return granted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

