/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.SecurityEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.ActionsCache;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.GroupNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.util.logger.Logger;
import org.jdom.JDOMException;

public class SecurityImpl
implements Security {
    private static final String LOG_CHANNEL = (class$org$apache$slide$security$SecurityImpl == null ? (class$org$apache$slide$security$SecurityImpl = SecurityImpl.class$("org.apache.slide.security.SecurityImpl")) : class$org$apache$slide$security$SecurityImpl).getName();
    private static final String PRIVILEGE_MEMBER_SET = "privilege-member-set";
    private static final String PRIVILEGE_NAMESPACE = "privilege-namespace";
    protected Logger logger;
    protected Namespace namespace;
    protected NamespaceConfig namespaceConfig;
    protected Hashtable rolesCache;
    protected int aclInheritanceType;
    private Set modificationActions;
    private static final Map caches = new HashMap();
    static /* synthetic */ Class class$org$apache$slide$security$SecurityImpl;
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public SecurityImpl() {
    }

    public SecurityImpl(Namespace namespace, NamespaceConfig namespaceConfig) {
        this.init(namespace, namespaceConfig);
    }

    public void init(Namespace namespace, NamespaceConfig namespaceConfig) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.rolesCache = new Hashtable();
        this.aclInheritanceType = namespaceConfig.getAclInheritanceType();
        this.logger = namespace.getLogger();
    }

    public void setPermissions(SlideToken token, String object, Enumeration permissions) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, object);
        ObjectNode objectNode = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, objectNode, this.namespaceConfig.getGrantPermissionAction());
        this.checkCredentials(token, objectNode, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermissions(objectUri);
        while (permissions.hasMoreElements()) {
            NodePermission permission = (NodePermission)permissions.nextElement();
            objectUri.getStore().grantPermission(objectUri, permission);
        }
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        this.grantPermission(token, object, subject, action, true);
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable);
        this.grantPermission(token, permission);
    }

    public void grantPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        Enumeration permissions = this.enumeratePermissions(token, object);
        boolean alreadyPresent = false;
        while (permissions.hasMoreElements() && !alreadyPresent) {
            if (!permission.equals(permissions.nextElement())) continue;
            alreadyPresent = true;
        }
        if (!alreadyPresent) {
            this.checkCredentials(token, object, this.namespaceConfig.getGrantPermissionAction());
            objectUri.getStore().grantPermission(objectUri, permission);
        }
        if (permission.isNegative()) {
            if (SecurityEvent.DENY_PERMISSION.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(SecurityEvent.DENY_PERMISSION, new SecurityEvent(this, token, this.namespace, objectUri, permission));
            }
        } else if (SecurityEvent.GRANT_PERMISSION.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(SecurityEvent.GRANT_PERMISSION, new SecurityEvent(this, token, this.namespace, objectUri, permission));
        }
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        this.denyPermission(token, object, subject, action, true);
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable, true);
        this.denyPermission(token, permission);
    }

    public void denyPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        if (!permission.isNegative()) {
            permission.setNegative(true);
        }
        this.grantPermission(token, permission);
    }

    public void revokePermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        NodePermission permission = new NodePermission(object, subject, action);
        Uri objectUri = this.namespace.getUri(token, object.getUri());
        objectUri.getStore().revokePermission(objectUri, permission);
        if (SecurityEvent.REVOKE_PERMISSION.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(SecurityEvent.REVOKE_PERMISSION, new SecurityEvent(this, token, this.namespace, objectUri, permission));
        }
    }

    public void revokePermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, VetoException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermission(objectUri, permission);
        if (SecurityEvent.REVOKE_PERMISSION.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(SecurityEvent.REVOKE_PERMISSION, new SecurityEvent(this, token, this.namespace, objectUri, permission));
        }
    }

    public void checkCredentials(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, AccessDeniedException {
        block9: {
            if (!token.isForceSecurity()) {
                return;
            }
            try {
                if (!Configuration.useIntegratedSecurity()) break block9;
                Boolean permission = token.checkPermissionCache(object, action);
                if (permission == null) {
                    try {
                        Uri objectUri = this.namespace.getUri(token, object.getUri());
                        ObjectNode realObject = objectUri.getStore().retrieveObject(objectUri);
                        this.checkPermission(token, realObject, action);
                        token.cachePermission(object, action, true);
                        break block9;
                    }
                    catch (AccessDeniedException ade) {
                        token.cachePermission(object, action, false);
                        ade.fillInStackTrace();
                        throw ade;
                    }
                }
                if (!permission.booleanValue()) {
                    throw new AccessDeniedException(object.getUri(), this.getPrincipal(token).getPath().toString(), action.getUri());
                }
            }
            catch (ObjectNotFoundException e) {
                String subjectUri = "*** Could not determine principal ***";
                try {
                    subjectUri = this.getPrincipal(token).getPath().toString();
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw new AccessDeniedException(object.getUri(), subjectUri, action.getUri());
            }
        }
    }

    public void checkPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException {
        if (!this.hasPermission(object, subject, action)) {
            throw new AccessDeniedException(object.getUri(), subject.getUri(), action.getUri());
        }
        this.determineActionsCacheInvalidation(object, action);
    }

    public void checkPermission(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException {
        if (!this.hasPermission(token, object, action)) {
            throw new AccessDeniedException(object.getUri(), this.getPrincipal(token).getUri(), action.getUri());
        }
        this.determineActionsCacheInvalidation(object, action);
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        if (action.equals(ActionNode.DEFAULT)) {
            return true;
        }
        boolean granted = false;
        boolean denied = false;
        boolean rootObjectReached = false;
        ObjectNode courObject = object;
        Uri subjectUri = this.namespace.getUri(subject.getUri());
        Uri actionUri = this.namespace.getUri(action.getUri());
        while (!(granted || denied || rootObjectReached)) {
            Uri courUri = this.namespace.getUri(courObject.getUri());
            Enumeration permissions = courUri.getStore().enumeratePermissions(courUri);
            while (permissions.hasMoreElements()) {
                boolean oldGranted = granted;
                boolean oldDenied = denied;
                NodePermission permission = (NodePermission)permissions.nextElement();
                String permissionSubject = permission.getSubjectUri();
                if (permissionSubject.equals("self")) {
                    boolean check = object.getUri().equals(subjectUri.toString());
                    if (permission.isInheritable()) {
                        String subjectUriString = subjectUri.toString();
                        if (!subjectUriString.endsWith("/")) {
                            subjectUriString = subjectUriString + "/";
                        }
                        check |= object.getUri().startsWith(subjectUriString);
                    }
                    granted = !permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                    denied = permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                } else if (permission.isInheritable() || permission.getObjectUri().equals(object.getUri())) {
                    if (permissionSubject.startsWith("/")) {
                        String permSubj = permission.getSubjectUri();
                        if (!permSubj.endsWith("/")) {
                            permSubj = permSubj + "/";
                        }
                        boolean match = subjectUri.toString().equals(permission.getSubjectUri()) || subjectUri.toString().startsWith(permSubj);
                        granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                        denied = permission.isNegative() && match;
                    } else if (permissionSubject.startsWith("+")) {
                        Uri permissionSubjectUri = this.namespace.getUri(permissionSubject.substring(1));
                        ObjectNode group = permissionSubjectUri.getStore().retrieveObject(permissionSubjectUri);
                        if (group instanceof GroupNode && group.hasChildren()) {
                            Enumeration groupMembers = group.enumerateChildren();
                            while (groupMembers.hasMoreElements()) {
                                oldGranted = granted;
                                oldDenied = denied;
                                Uri childUri = this.namespace.getUri((String)groupMembers.nextElement());
                                ObjectNode childNode = childUri.getStore().retrieveObject(childUri);
                                String childSubjectUri = childNode instanceof LinkNode ? ((LinkNode)childNode).getLinkedUri() : childNode.getUri();
                                String testUri = !childSubjectUri.endsWith("/") ? childSubjectUri + "/" : childSubjectUri;
                                boolean match = subjectUri.toString().equals(childSubjectUri) || subjectUri.toString().startsWith(testUri);
                                granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                                denied = permission.isNegative() && match;
                                granted |= oldGranted;
                                denied |= oldDenied;
                            }
                        }
                    } else {
                        granted = !permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                        denied = permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                    }
                }
                granted |= oldGranted;
                denied |= oldDenied;
            }
            Uri parentUri = courUri.getParentUri();
            if (parentUri != null) {
                courObject = parentUri.getStore().retrieveObject(parentUri);
                continue;
            }
            rootObjectReached = true;
        }
        if (denied) {
            return false;
        }
        return granted;
    }

    public boolean hasPermission(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        Boolean cachedPermission = token.checkPermissionCache(object, action);
        if (cachedPermission != null) {
            return cachedPermission;
        }
        return this.hasPermission(object, (SubjectNode)this.getPrincipal(token), action);
    }

    public Enumeration enumeratePermissions(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        return this.enumeratePermissions(token, object, false);
    }

    public Enumeration enumeratePermissions(SlideToken token, ObjectNode object, boolean includeInherited) throws ServiceAccessException, ObjectNotFoundException {
        return this.enumeratePermissions(token, object.getUri(), includeInherited);
    }

    public Enumeration enumeratePermissions(SlideToken token, String object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        return this.enumeratePermissions(token, object, false);
    }

    public Enumeration enumeratePermissions(SlideToken token, String object, boolean includeInherited) throws ServiceAccessException, ObjectNotFoundException {
        Uri objectUri = this.namespace.getUri(token, object);
        if (!includeInherited) {
            return objectUri.getStore().enumeratePermissions(objectUri);
        }
        ObjectNode objectNode = objectUri.getStore().retrieveObject(objectUri);
        Iterator i = this.retrieveAclSourceNodes(token, objectNode).iterator();
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        while (i.hasNext()) {
            ObjectNode oNode = (ObjectNode)i.next();
            Uri oUri = this.namespace.getUri(token, oNode.getUri());
            Enumeration permEnum = oUri.getStore().enumeratePermissions(oUri);
            while (permEnum.hasMoreElements()) {
                NodePermission perm = (NodePermission)permEnum.nextElement();
                if (object.equals(oNode.getUri())) {
                    perm.setInheritedFrom(null);
                    permissions.add(perm);
                    continue;
                }
                if (!perm.isInheritable()) continue;
                perm.setInheritedFrom(oNode.getUri());
                permissions.add(perm);
            }
        }
        return permissions.elements();
    }

    public List retrieveAclSourceNodes(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        switch (this.aclInheritanceType) {
            case 0: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                result.add(uri.getStore().retrieveObject(uri));
                break;
            }
            case 1: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                Uri rootUri = this.namespace.getUri(token, uri.getScope().toString());
                result.add(uri.getStore().retrieveObject(uri));
                result.add(rootUri.getStore().retrieveObject(rootUri));
                break;
            }
            case 2: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                Enumeration enumeration = uri.getScopes();
                while (enumeration.hasMoreElements()) {
                    Uri element = this.namespace.getUri(token, (String)enumeration.nextElement());
                    ObjectNode objectNode = element.getStore().retrieveObject(element);
                    result.add(objectNode);
                }
                break;
            }
            case 3: {
                break;
            }
        }
        return result;
    }

    public boolean hasRole(SlideToken token, String role) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode subject = this.getPrincipal(token);
        return this.hasRole(subject, role);
    }

    public boolean hasRole(ObjectNode object, String role) throws ServiceAccessException, ObjectNotFoundException {
        if (role.equals("nobody")) {
            return true;
        }
        String associatedRole = this.namespaceConfig.getRoleMapping(role);
        if (associatedRole != null && associatedRole.equals("nobody")) {
            return true;
        }
        Class<?> roleClass = (Class<?>)this.rolesCache.get(role);
        if (roleClass == null && associatedRole != null && (roleClass = (Class<?>)this.rolesCache.get(associatedRole)) == null) {
            try {
                roleClass = Class.forName(associatedRole);
                this.rolesCache.put(role, roleClass);
                this.rolesCache.put(associatedRole, roleClass);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (roleClass == null) {
            try {
                roleClass = Class.forName(role);
                this.rolesCache.put(role, roleClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (roleClass == null) {
            return false;
        }
        return roleClass.isInstance(object);
    }

    public Enumeration getRoles(ObjectNode object) {
        Vector<String> result = new Vector<String>();
        result.addElement("nobody");
        Class<?> currentObjectClass = object.getClass();
        while (!currentObjectClass.equals(class$org$apache$slide$structure$ObjectNode == null ? SecurityImpl.class$("org.apache.slide.structure.ObjectNode") : class$org$apache$slide$structure$ObjectNode)) {
            Class<?>[] interfaces = currentObjectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String className = interfaces[i].getName();
                String associatedName = this.namespaceConfig.getRoleMapping(className);
                if (associatedName != null) {
                    result.addElement(associatedName);
                    continue;
                }
                result.addElement(className);
            }
            if ((currentObjectClass = currentObjectClass.getSuperclass()) != null) continue;
            throw new IllegalStateException("Invalid node");
        }
        return result.elements();
    }

    public Enumeration getRoles(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(this.getPrincipal(token));
    }

    public Enumeration getRoles(SlideToken token, SubjectNode subjectNode) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(subjectNode);
    }

    public ObjectNode getPrincipal(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        String user = token.getCredentialsToken().getPublicCredentials();
        if (user == null || user.equals("") || user.equals("/")) {
            return SubjectNode.UNAUTHENTICATED;
        }
        Uri subjectUri = this.namespace.getUri(token, this.namespaceConfig.getUsersPath() + "/" + user);
        try {
            return subjectUri.getStore().retrieveObject(subjectUri);
        }
        catch (ObjectNotFoundException e) {
            if (!this.namespaceConfig.isAutoCreateUsers()) {
                throw e;
            }
            try {
                Uri parentUri = subjectUri.getParentUri();
                ObjectNode parent = subjectUri.getStore().retrieveObject(parentUri);
                Enumeration childrenEnum = parent.enumerateChildren();
                Enumeration linksEnum = parent.enumerateLinks();
                Vector children = new Vector();
                while (childrenEnum.hasMoreElements()) {
                    children.addElement(childrenEnum.nextElement());
                }
                children.addElement(subjectUri.toString());
                Vector links = new Vector();
                while (linksEnum.hasMoreElements()) {
                    links.addElement(linksEnum.nextElement());
                }
                Class<?> objectClass = Class.forName(this.namespaceConfig.getAutoCreateUsersRole());
                Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityImpl.class$("java.lang.String")) : class$java$lang$String};
                Object[] args = new Object[]{subjectUri.toString()};
                Constructor<?> constructor = objectClass.getConstructor(types);
                ObjectNode object = (ObjectNode)constructor.newInstance(args);
                subjectUri.getStore().createObject(subjectUri, object);
                Class[] types2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityImpl.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = SecurityImpl.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = SecurityImpl.class$("java.util.Vector")) : class$java$util$Vector};
                Object[] args2 = new Object[]{parentUri.toString(), children, links};
                constructor = parent.getClass().getConstructor(types2);
                object = (ObjectNode)constructor.newInstance(args2);
                parentUri.getStore().storeObject(parentUri, object);
                NodeRevisionNumber initialRevision = new NodeRevisionNumber(1, 0);
                Hashtable<String, NodeRevisionNumber> workingRevisions = new Hashtable<String, NodeRevisionNumber>();
                workingRevisions.put("main", initialRevision);
                Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
                latestRevisionNumbers.put("main", initialRevision);
                Hashtable branches = new Hashtable();
                branches.put(initialRevision, new Vector());
                boolean isVersioned = false;
                NodeRevisionDescriptors revisionDescriptors = new NodeRevisionDescriptors(subjectUri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
                NodeRevisionDescriptor revisionDescriptor = new NodeRevisionDescriptor(initialRevision, "main", new Vector(), new Hashtable());
                subjectUri.getStore().createRevisionDescriptors(subjectUri, revisionDescriptors);
                subjectUri.getStore().createRevisionDescriptor(subjectUri, revisionDescriptor);
            }
            catch (ClassNotFoundException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (NoSuchMethodException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InstantiationException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InvocationTargetException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (IllegalAccessException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (ObjectAlreadyExistsException ex) {
                ex.printStackTrace();
                throw new ObjectNotFoundException(subjectUri);
            }
            return subjectUri.getStore().retrieveObject(subjectUri);
        }
    }

    private static synchronized Set getActionAggregates(SecurityImpl security, SlideToken token, ActionNode aNode) throws SlideException, JDOMException {
        HashSet<ActionNode> result = new HashSet<ActionNode>();
        Uri aNodeUri = security.namespace.getUri(token, aNode.getUri());
        NodeRevisionDescriptor aNrd = aNodeUri.getStore().retrieveRevisionDescriptor(aNodeUri, new NodeRevisionNumber());
        NodeProperty membersProp = aNrd.getProperty(PRIVILEGE_MEMBER_SET);
        if (membersProp != null && membersProp.getValue() != null) {
            XMLValue membersVal = membersProp.getValue() instanceof XMLValue ? (XMLValue)membersProp.getValue() : new XMLValue((String)membersProp.getValue());
            security.logger.log(membersVal.getHrefStrings(), LOG_CHANNEL, 7);
            Iterator mUris = membersVal.getHrefStrings().iterator();
            while (mUris.hasNext()) {
                String uriAsString = (String)mUris.next();
                Uri uri = security.namespace.getUri(token, uriAsString);
                NodeRevisionNumber latestRevisionNumber = aNodeUri.getStore().retrieveRevisionDescriptors(uri).getLatestRevision();
                if (latestRevisionNumber == null) continue;
                NodeProperty privilegeNamespace = aNodeUri.getStore().retrieveRevisionDescriptor(uri, latestRevisionNumber).getProperty(PRIVILEGE_NAMESPACE, "DAV:");
                org.jdom.Namespace namespace = null;
                namespace = privilegeNamespace != null && privilegeNamespace.getValue() instanceof String ? org.jdom.Namespace.getNamespace((String)((String)privilegeNamespace.getValue())) : org.jdom.Namespace.getNamespace((String)"DAV:");
                result.add(ActionNode.getActionNode(uriAsString, namespace));
            }
        }
        return result;
    }

    public boolean matchAction(SlideToken token, ActionNode checkAction, ActionNode permAction) throws ServiceAccessException {
        if (permAction.equals(ActionNode.ALL)) {
            return true;
        }
        Map actionAggregationClosure = SecurityImpl.getActionAggregationClosureImpl(this, token, checkAction.getUri());
        Set permActionSet = (Set)actionAggregationClosure.get(permAction);
        if (permActionSet == null) {
            this.logger.log("Unknown action " + permAction.getUri(), LOG_CHANNEL, 4);
            return false;
        }
        return permActionSet.contains(checkAction);
    }

    public boolean matchPrincipal(SlideToken token, SubjectNode checkSubject, SubjectNode matchSubject) throws ServiceAccessException {
        Boolean b = token.checkMatchPrincipalCache(checkSubject, matchSubject);
        if (b != null) {
            return b;
        }
        boolean match = this.matchPrincipal(token, checkSubject, matchSubject, this.namespaceConfig.getNestedRolesMaxDepth());
        token.cacheMatchPrincipal(checkSubject, matchSubject, match);
        return match;
    }

    public boolean matchPrincipal(SlideToken token, SubjectNode checkSubject, SubjectNode matchSubject, int level) throws ServiceAccessException {
        if (matchSubject.equals(checkSubject)) {
            return true;
        }
        Uri groupUri = this.namespace.getUri(token, matchSubject.getUri());
        try {
            NodeRevisionDescriptor nrd = groupUri.getStore().retrieveRevisionDescriptor(groupUri, new NodeRevisionNumber());
            NodeProperty membersetProp = nrd.getProperty("group-member-set");
            if (membersetProp != null && membersetProp.getValue() != null) {
                XMLValue xmlVal = new XMLValue((String)membersetProp.getValue());
                List memberNodes = xmlVal.getHrefNodes();
                if (memberNodes.contains(checkSubject)) {
                    return true;
                }
                if (level > 0) {
                    int nextLevel = level - 1;
                    boolean match = false;
                    Iterator i = memberNodes.iterator();
                    while (!match && i.hasNext()) {
                        SubjectNode nextMatchNode = (SubjectNode)i.next();
                        if (!this.namespaceConfig.isRole(nextMatchNode.getUri()) && !this.namespaceConfig.isGroup(nextMatchNode.getUri())) continue;
                        match = this.matchPrincipal(token, checkSubject, nextMatchNode, nextLevel);
                    }
                    return match;
                }
                return false;
            }
            return false;
        }
        catch (RevisionDescriptorNotFoundException e) {
            return false;
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map getActionAggregation(SlideToken token) {
        this.logger.log("Action aggregation being retrieved", LOG_CHANNEL, 7);
        return Collections.unmodifiableMap(SecurityImpl.getActionAggregationImpl(this, token));
    }

    private synchronized Set getModificationActions() {
        if (this.modificationActions == null) {
            HashSet<ActionNode> modificationActions = new HashSet<ActionNode>();
            modificationActions.add(this.namespaceConfig.getBindMemberAction());
            modificationActions.add(this.namespaceConfig.getCreateObjectAction());
            modificationActions.add(this.namespaceConfig.getCreateRevisionContentAction());
            modificationActions.add(this.namespaceConfig.getCreateRevisionMetadataAction());
            modificationActions.add(this.namespaceConfig.getModifyRevisionContentAction());
            modificationActions.add(this.namespaceConfig.getModifyRevisionMetadataAction());
            modificationActions.add(this.namespaceConfig.getRemoveObjectAction());
            modificationActions.add(this.namespaceConfig.getRemoveRevisionContentAction());
            modificationActions.add(this.namespaceConfig.getRemoveRevisionMetadataAction());
            modificationActions.add(this.namespaceConfig.getUnbindMemberAction());
            modificationActions.remove(this.namespaceConfig.getDefaultAction());
            this.modificationActions = Collections.unmodifiableSet(modificationActions);
        }
        return this.modificationActions;
    }

    private boolean isModificationAction(ActionNode action) {
        return this.getModificationActions().contains(action);
    }

    private void determineActionsCacheInvalidation(ObjectNode object, ActionNode action) {
        if (object.getUri().startsWith(this.namespaceConfig.getActionsPath()) && this.isModificationAction(action)) {
            if (this.logger.isEnabled(7)) {
                this.logger.log("Actions cache invalidated for operation " + action.getUri() + " on action " + object.getUri(), LOG_CHANNEL, 7);
            }
            SecurityImpl.invalidateActionsCache(this);
        }
    }

    private static synchronized void invalidateActionsCache(SecurityImpl security) {
        ActionsCache cache = SecurityImpl.getActionsCache(security);
        cache.invalidate();
    }

    private static synchronized ActionsCache getActionsCache(SecurityImpl security) {
        String namespaceName = security.namespace.getName();
        ActionsCache result = (ActionsCache)caches.get(namespaceName);
        if (result == null) {
            result = new ActionsCache();
            caches.put(namespaceName, result);
        }
        return result;
    }

    private static synchronized void loadActionsCache(SecurityImpl security, SlideToken token) {
        ActionsCache cache = SecurityImpl.getActionsCache(security);
        try {
            cache.aggregation = new HashMap();
            cache.aggregationClosure = new HashMap();
            String actionsPath = security.namespaceConfig.getActionsPath();
            Uri actionsPathUri = security.namespace.getUri(token, actionsPath);
            ObjectNode actionsPathNode = actionsPathUri.getStore().retrieveObject(actionsPathUri);
            Enumeration actions = actionsPathNode.enumerateChildren();
            SecurityImpl.addActionLeafsToActionAggregation(security, token, cache, actions);
            Iterator keys = cache.aggregationClosure.keySet().iterator();
            while (keys.hasNext()) {
                ActionNode aNode = (ActionNode)keys.next();
                Set aClosure = (Set)cache.aggregationClosure.get(aNode);
                cache.aggregationClosure.put(aNode, SecurityImpl.buildClosure(cache, aClosure));
            }
            if (security.logger.isEnabled(LOG_CHANNEL, 7)) {
                security.logger.log("Action aggregations loaded successfully", LOG_CHANNEL, 7);
            }
            if (security.logger.isEnabled(LOG_CHANNEL, 7)) {
                security.logger.log("\n@@@ Actions aggregations", LOG_CHANNEL, 7);
                Iterator i = cache.aggregation.entrySet().iterator();
                while (i.hasNext()) {
                    security.logger.log("  " + i.next(), LOG_CHANNEL, 7);
                }
                security.logger.log("\n@@@ Action aggregations (transitive closure)", LOG_CHANNEL, 7);
                i = cache.aggregationClosure.entrySet().iterator();
                while (i.hasNext()) {
                    security.logger.log("  " + i.next(), LOG_CHANNEL, 7);
                }
            }
        }
        catch (Throwable e) {
            security.logger.log(e, LOG_CHANNEL, 2);
            cache.fail();
        }
    }

    private static synchronized void addActionLeafsToActionAggregation(SecurityImpl security, SlideToken token, ActionsCache cache, Enumeration actions) throws SlideException, JDOMException {
        while (actions.hasMoreElements()) {
            Uri aNodeUri = security.namespace.getUri(token, (String)actions.nextElement());
            ObjectNode oNode = security.namespace.getStore(aNodeUri.getScope()).retrieveObject(aNodeUri);
            if (oNode.hasChildren()) {
                if (security.logger.isEnabled(7)) {
                    security.logger.log("Adding children of action " + oNode.getUri() + " to action aggregation", LOG_CHANNEL, 7);
                }
                SecurityImpl.addActionLeafsToActionAggregation(security, token, cache, oNode.enumerateChildren());
                continue;
            }
            if (security.logger.isEnabled(7)) {
                security.logger.log("Adding action " + oNode.getUri() + " to action aggregation", LOG_CHANNEL, 7);
            }
            NodeRevisionNumber latestRevisionNumber = security.namespace.getStore(aNodeUri.getScope()).retrieveRevisionDescriptors(aNodeUri).getLatestRevision();
            NodeProperty privilegeNamespace = security.namespace.getStore(aNodeUri.getScope()).retrieveRevisionDescriptor(aNodeUri, latestRevisionNumber).getProperty(PRIVILEGE_NAMESPACE, "DAV:");
            org.jdom.Namespace actionNamespace = privilegeNamespace != null && privilegeNamespace.getValue() instanceof String ? org.jdom.Namespace.getNamespace((String)((String)privilegeNamespace.getValue())) : org.jdom.Namespace.getNamespace((String)"DAV:");
            ActionNode aNode = ActionNode.getActionNode(oNode.getUri(), actionNamespace);
            Set directAggregates = SecurityImpl.getActionAggregates(security, token, aNode);
            cache.aggregation.put(aNode, directAggregates);
            HashSet<ActionNode> aClosure = new HashSet<ActionNode>();
            aClosure.add(aNode);
            aClosure.addAll(directAggregates);
            cache.aggregationClosure.put(aNode, aClosure);
        }
    }

    private static synchronized Set buildClosure(ActionsCache cache, Set aClosure) {
        HashSet result = new HashSet(aClosure);
        int size = 0;
        while (result.size() > size) {
            size = result.size();
            HashSet newResult = new HashSet();
            Iterator i = result.iterator();
            while (i.hasNext()) {
                Object member = i.next();
                Set membersOfMember = (Set)cache.aggregationClosure.get(member);
                if (membersOfMember == null) continue;
                newResult.addAll(membersOfMember);
            }
            result = newResult;
        }
        return result;
    }

    private static synchronized Map getActionAggregationImpl(SecurityImpl security, SlideToken token) {
        ActionsCache cache = SecurityImpl.getActionsCache(security);
        if (!cache.hasBeenLoaded()) {
            SecurityImpl.loadActionsCache(security, token);
        }
        if (cache.hasLoadingFailed) {
            security.logger.log("actionAggregation retrieved but cache didn't load successfully", LOG_CHANNEL, 4);
            return new HashMap();
        }
        return cache.aggregation;
    }

    private static synchronized Map getActionAggregationClosureImpl(SecurityImpl security, SlideToken token, String uri) throws ServiceAccessException {
        ActionsCache cache = SecurityImpl.getActionsCache(security);
        if (!cache.hasBeenLoaded()) {
            SecurityImpl.loadActionsCache(security, token);
        }
        if (cache.hasLoadingFailed()) {
            Uri u = security.namespace.getUri(token, uri);
            Store s = u.getStore();
            throw new ServiceAccessException((Service)s, "Actions cache not loaded");
        }
        return cache.aggregationClosure;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

