/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.SlideUri;
import org.apache.slide.search.basic.BasicExpressionCompiler;
import org.apache.slide.search.basic.BasicQueryScope;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionCompiler;
import org.apache.slide.search.basic.IBasicExpressionCompilerProvider;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.OrderBy;
import org.apache.slide.store.AbstractStore;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class BasicQuery
extends SearchQuery
implements IBasicQuery {
    public static final String NO_QUERY_ELEMENT = "No query element";
    protected IBasicExpressionCompilerProvider expressionCompilerProvider = null;
    public static final String SELECT_ELEMENT_MISSING = "Required element <select> not supplied";
    public static final String FROM_ELEMENT_MISSING = "Required element <from> not supplied";
    public static final String PROP_OR_ALLPROP_ELEMENT_MISSING = "Required element <prop> or <allprop> not supplied";
    private IBasicExpressionFactory contentExpressionFactory;
    private IBasicExpressionFactory propertiesExpressionFactory;
    protected Element queryElement;
    protected Namespace namespace;
    protected QueryScope queryScope;
    protected Element whereElement;
    protected RequestedProperties requestedProperties;
    protected int limit;
    protected OrderBy orderBy;
    protected boolean limitDefined = false;
    protected AbstractStore store;
    protected IBasicExpression rootExpression;
    protected SlideUri slideUri;
    protected PropertyProvider propertyProvider;

    protected BasicQuery() {
    }

    protected BasicQuery(SearchToken searchToken) {
        this.init(searchToken);
    }

    public void init(SearchToken token) {
        this.searchToken = token;
        this.slideUri = this.searchToken.getSlideContext();
        this.expressionCompilerProvider = new ExpressionCompilerProvider();
    }

    public IBasicExpressionFactory getContentExpressionFactory() {
        if (this.contentExpressionFactory == null) {
            this.contentExpressionFactory = this.store.getContentIndexer().getBasicExpressionFactory();
        }
        return this.contentExpressionFactory;
    }

    public IBasicExpressionFactory getPropertiesExpressionFactory() {
        this.propertiesExpressionFactory = this.store.getPropertiesIndexer().getBasicExpressionFactory();
        return this.propertiesExpressionFactory;
    }

    public AbstractStore getStore() {
        return this.store;
    }

    public String getSlidePath() throws InvalidScopeException {
        return this.slideUri.getSlidePath(this.queryScope.getHref());
    }

    public SearchToken getSearchToken() {
        return this.searchToken;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public void parseQueryElement(Element basicSearchElement, PropertyProvider propertyProvider) throws BadQueryException {
        this.queryScope = BasicQuery.getScope(basicSearchElement);
        this.propertyProvider = propertyProvider;
        if (this.searchToken.getNamespace() != null) {
            Uri uri = this.searchToken.getNamespace().getUri(this.getSearchToken().getSlideToken(), this.slideUri.getSlidePath(this.queryScope.getHref()));
            this.store = (AbstractStore)uri.getStore();
        }
        this.parseQuery(basicSearchElement, propertyProvider);
    }

    public abstract void parseQuery(Element var1, PropertyProvider var2) throws BadQueryException;

    public abstract SearchQueryResult execute() throws ServiceAccessException;

    protected void parseQueryWithoutExpression(Element basicSearchElement) throws BadQueryException {
        if (basicSearchElement == null) {
            throw new BadQueryException(NO_QUERY_ELEMENT);
        }
        this.namespace = basicSearchElement.getNamespace();
        Element selectElement = basicSearchElement.getChild("select", this.namespace);
        if (selectElement == null) {
            throw new BadQueryException(SELECT_ELEMENT_MISSING);
        }
        Element fromElement = basicSearchElement.getChild("from", this.namespace);
        if (fromElement == null) {
            throw new BadQueryException(FROM_ELEMENT_MISSING);
        }
        this.whereElement = basicSearchElement.getChild("where", this.namespace);
        Element orderByElement = basicSearchElement.getChild("orderby", this.namespace);
        Element limitElement = basicSearchElement.getChild("limit", this.namespace);
        Element propElement = selectElement.getChild("prop", this.namespace);
        if (propElement == null) {
            propElement = selectElement.getChild("allprop", this.namespace);
        }
        if (propElement == null) {
            throw new BadQueryException(PROP_OR_ALLPROP_ELEMENT_MISSING);
        }
        try {
            this.requestedProperties = new RequestedPropertiesImpl(propElement);
        }
        catch (PropertyParseException e) {
            throw new BadQueryException(e.getMessage(), e);
        }
        this.queryScope = new BasicQueryScope(fromElement);
        if (orderByElement != null) {
            this.orderBy = new OrderBy();
            this.orderBy.init(orderByElement);
        }
        if (limitElement != null) {
            this.limit = new Integer(limitElement.getTextTrim());
            this.limitDefined = true;
        }
    }

    public QueryScope getScope() {
        return this.queryScope;
    }

    public RequestedProperties requestedProperties() {
        return this.requestedProperties;
    }

    public IBasicExpression getExpression() {
        return this.rootExpression;
    }

    public boolean isLimitDefined() {
        return this.limitDefined;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setScope(QueryScope queryScope) {
        this.queryScope = queryScope;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public String toString() {
        String result = "SELECT [" + this.requestedProperties + "] FROM [" + this.queryScope + "] " + "WHERE [" + this.rootExpression + "]";
        return result;
    }

    public static QueryScope getScope(Element basicSearchElementJDOM) throws BadQueryException {
        if (basicSearchElementJDOM == null) {
            throw new BadQueryException(NO_QUERY_ELEMENT);
        }
        Namespace namespace = basicSearchElementJDOM.getNamespace();
        Element fromElement = basicSearchElementJDOM.getChild("from", namespace);
        if (fromElement == null) {
            throw new BadQueryException(FROM_ELEMENT_MISSING);
        }
        return new BasicQueryScope(fromElement);
    }

    public static class ExpressionCompilerProvider
    implements IBasicExpressionCompilerProvider {
        public IBasicExpressionCompiler getCompiler(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
            return new BasicExpressionCompiler(query, propertyProvider);
        }
    }
}

