/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.macro;

import org.apache.slide.common.Domain;
import org.apache.slide.common.Uri;
import org.apache.slide.content.Content;
import org.apache.slide.content.ContentImpl;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.MacroEvent;
import org.apache.slide.event.MacroListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.LockImpl;
import org.apache.slide.security.ACLSecurityImpl;
import org.apache.slide.structure.StructureImpl;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class MacroPropertyUpdater
implements MacroListener,
Configurable {
    private boolean updateDisplayName = true;
    private boolean updateOwnerOnMove = false;
    private boolean updateOwnerOnCopy = true;

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.updateDisplayName = configuration.getConfiguration("update-displayname").getValueAsBoolean(this.updateDisplayName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.updateOwnerOnMove = configuration.getConfiguration("update-owner-on-move").getValueAsBoolean(this.updateOwnerOnMove);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.updateOwnerOnCopy = configuration.getConfiguration("update-owner-on-copy").getValueAsBoolean(this.updateOwnerOnCopy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copy(MacroEvent event) throws VetoException {
        try {
            String displayName;
            Content helper = this.getContentHelper(event);
            NodeRevisionDescriptors destNrds = helper.retrieve(event.getToken(), event.getTargetURI());
            NodeRevisionDescriptor destNrd = helper.retrieve(event.getToken(), destNrds);
            boolean anyThingUpdated = false;
            if (this.updateDisplayName && !(displayName = MacroPropertyUpdater.getFilename(event.getTargetURI())).equals(destNrd.getName())) {
                destNrd.setName(displayName);
                anyThingUpdated = true;
            }
            if (this.updateOwnerOnCopy) {
                String newOwner = event.getToken().getCredentialsToken().getPublicCredentials();
                if (newOwner == null || newOwner.equals("") || newOwner.equals("/")) {
                    newOwner = "unauthenticated";
                }
                if (!destNrd.getOwner().equals(newOwner)) {
                    destNrd.setOwner(newOwner);
                    anyThingUpdated = true;
                }
            }
            if (anyThingUpdated) {
                Uri target = event.getNamespace().getUri(event.getToken(), event.getTargetURI());
                target.getStore().storeRevisionDescriptor(target, destNrd);
            }
        }
        catch (Exception e) {
            Domain.error("Exception while copy", e);
        }
    }

    public void move(MacroEvent event) throws VetoException {
        try {
            Content helper = this.getContentHelper(event);
            NodeRevisionDescriptors destNrds = helper.retrieve(event.getToken(), event.getTargetURI());
            NodeRevisionDescriptor destNrd = helper.retrieve(event.getToken(), destNrds);
            boolean anyThingUpdated = false;
            if (this.updateOwnerOnMove) {
                String newOwner = event.getToken().getCredentialsToken().getPublicCredentials();
                if (newOwner == null || newOwner.equals("") || newOwner.equals("/")) {
                    newOwner = "unauthenticated";
                }
                if (!destNrd.getOwner().equals(newOwner)) {
                    anyThingUpdated = true;
                    destNrd.setOwner(newOwner);
                }
            }
            if (anyThingUpdated) {
                Uri target = event.getNamespace().getUri(event.getToken(), event.getTargetURI());
                target.getStore().storeRevisionDescriptor(target, destNrd);
            }
        }
        catch (Exception e) {
            Domain.error("Exception while move", e);
        }
    }

    public void delete(MacroEvent event) throws VetoException {
    }

    private static String getFilename(String uri) {
        if (uri.indexOf(47) == -1) {
            return uri;
        }
        if (uri.equals("/")) {
            return "";
        }
        if (uri.endsWith("/")) {
            return uri.substring(1 + uri.lastIndexOf(47, uri.length() - 2), uri.length() - 1);
        }
        return uri.substring(1 + uri.lastIndexOf(47));
    }

    private Content getContentHelper(MacroEvent event) {
        ACLSecurityImpl security = new ACLSecurityImpl(event.getNamespace(), event.getNamespace().getConfig());
        LockImpl lock = new LockImpl(event.getNamespace(), event.getNamespace().getConfig(), security);
        StructureImpl structure = new StructureImpl(event.getNamespace(), event.getNamespace().getConfig(), security, lock);
        ContentImpl helper = new ContentImpl(event.getNamespace(), event.getNamespace().getConfig(), security, structure, lock);
        return helper;
    }
}

