/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.macro;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.MacroEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.CopyListener;
import org.apache.slide.macro.CopyMacroException;
import org.apache.slide.macro.CopyRouteRedirector;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.DeleteMacroException;
import org.apache.slide.macro.DeleteTargetRedirector;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.macro.Macro;
import org.apache.slide.macro.MacroException;
import org.apache.slide.macro.MacroParameters;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectHasChildrenException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Configuration;

public final class MacroImpl
implements Macro {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Content contentHelper;
    private Structure structureHelper;
    private Security securityHelper;
    private Lock lockHelper;

    public MacroImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Content contentHelper, Structure structureHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.contentHelper = contentHelper;
        this.structureHelper = structureHelper;
        this.lockHelper = lockHelper;
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, null, null, null, null);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, RECURSIVE_OVERWRITE_PARAMETERS, copyRedirector, copyListener, deleteRedirector, deleteListener);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, parameters, null, null, null, null);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        Domain.debug("Copy " + sourceUri + " to " + destinationUri);
        CopyMacroException e = new CopyMacroException("Copy failed");
        if (sourceUri.equals(destinationUri)) {
            e.addException(new ForbiddenException(sourceUri));
            throw e;
        }
        HashMap alreadyCopied = new HashMap();
        parameters.setParameter("alreadyCopied", alreadyCopied);
        this.copyObject(token, sourceUri, destinationUri, parameters, true, e, copyRedirector, copyListener, deleteRedirector, deleteListener);
        if (!e.isEmpty()) {
            throw e;
        }
        try {
            if (MacroEvent.COPY.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(MacroEvent.COPY, new MacroEvent(this, token, this.namespace, sourceUri, destinationUri));
            }
        }
        catch (VetoException ve) {
            throw new CopyMacroException(ve.getMessage());
        }
    }

    protected void recursiveAccessCheck(Uri uri, ActionNode action) throws SlideException, AccessDeniedException {
        try {
            ObjectNode node = uri.getStore().retrieveObject(uri);
            this.securityHelper.checkCredentials(uri.getToken(), node, action);
            Iterator i = node.getChildren().iterator();
            while (i.hasNext()) {
                String child = (String)i.next();
                Uri childUri = this.namespace.getUri(uri.getToken(), child);
                this.recursiveAccessCheck(childUri, action);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    protected void recursiveLockCheck(Uri uri) throws SlideException, ObjectLockedException {
        try {
            ObjectNode node = uri.getStore().retrieveObject(uri);
            ActionNode action = this.namespaceConfig.getCreateObjectAction();
            this.lockHelper.checkLock(uri.getToken(), node, action);
            Iterator i = node.getChildren().iterator();
            while (i.hasNext()) {
                String child = (String)i.next();
                Uri childUri = this.namespace.getUri(uri.getToken(), child);
                this.recursiveLockCheck(childUri);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void rebind(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        CopyMacroException e = new CopyMacroException("Rebind failed");
        if (sourceUri.equals(destinationUri)) {
            e.addException(new ForbiddenException(sourceUri));
            throw e;
        }
        Uri source = this.namespace.getUri(token, sourceUri);
        Uri destination = this.namespace.getUri(token, destinationUri);
        try {
            this.recursiveLockCheck(source);
            this.recursiveLockCheck(destination);
        }
        catch (SlideException ex) {
            e.addException(ex);
            throw e;
        }
        if (parameters.isDeleteCreate()) {
            try {
                this.structureHelper.retrieve(token, destinationUri);
                this.delete(token, destinationUri, deleteRedirector, deleteListener);
            }
            catch (ObjectNotFoundException onf) {
            }
            catch (DeleteMacroException s) {
                throw s;
            }
            catch (SlideException s) {
                e.addException(s);
                throw e;
            }
        }
        UriHandler destinationUh = new UriHandler(destinationUri);
        UriHandler destinationParentUh = destinationUh.getParent();
        ObjectNode destinationParentNode = null;
        String destinationSegment = destinationUh.getLastSegment();
        UriHandler sourceUh = new UriHandler(sourceUri);
        UriHandler sourceParentUh = sourceUh.getParent();
        ObjectNode sourceParentNode = null;
        String sourceSegment = sourceUh.getLastSegment();
        ObjectNode sourceNode = null;
        try {
            try {
                destinationParentNode = this.structureHelper.retrieve(token, destinationParentUh.toString(), false);
            }
            catch (ObjectNotFoundException ex) {
                throw new ConflictException(destinationParentUh.toString());
            }
            sourceParentNode = this.structureHelper.retrieve(token, sourceParentUh.toString(), false);
            sourceNode = this.structureHelper.retrieve(token, sourceUri, false);
        }
        catch (SlideException x) {
            e.addException(x);
            throw e;
        }
        try {
            if (copyListener != null) {
                copyListener.beforeCopy(sourceUri, destinationUri, true);
            }
            this.structureHelper.addBinding(token, destinationParentNode, destinationSegment, sourceNode);
            this.structureHelper.removeBinding(token, sourceParentNode, sourceSegment);
        }
        catch (SlideException x) {
            e.addException(x);
            throw e;
        }
    }

    public void move(SlideToken token, String sourceUri, String destinationUri) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, null, null, null, null);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, RECURSIVE_OVERWRITE_PARAMETERS, copyRedirector, copyListener, deleteRedirector, deleteListener);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, parameters, null, null, null, null);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        if (Configuration.useBinding(this.namespace.getUri(token, sourceUri).getStore()) && Configuration.useBinding(this.namespace.getUri(token, destinationUri).getStore()) && this.sameStore(token, sourceUri, destinationUri)) {
            this.rebind(token, sourceUri, destinationUri, parameters, copyRedirector, copyListener, deleteRedirector, deleteListener);
        } else {
            this.copy(token, sourceUri, destinationUri, parameters, copyRedirector, copyListener, deleteRedirector, deleteListener);
            this.delete(token, sourceUri, parameters, deleteRedirector, deleteListener);
        }
        try {
            if (MacroEvent.MOVE.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(MacroEvent.MOVE, new MacroEvent(this, token, this.namespace, sourceUri, destinationUri));
            }
        }
        catch (VetoException ve) {
            throw new CopyMacroException(ve.getMessage());
        }
    }

    public void delete(SlideToken token, String targetUri) throws DeleteMacroException {
        this.delete(token, targetUri, null, null);
    }

    public void delete(SlideToken token, String targetUri, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws DeleteMacroException {
        this.delete(token, targetUri, RECURSIVE_OVERWRITE_PARAMETERS, deleteRedirector, deleteListener);
    }

    public void delete(SlideToken token, String targetUri, MacroParameters parameters) throws DeleteMacroException {
        this.delete(token, targetUri, parameters, null, null);
    }

    public void delete(SlideToken token, String targetUri, MacroParameters parameters, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws DeleteMacroException {
        Domain.debug("Delete " + targetUri);
        DeleteMacroException e = new DeleteMacroException("Delete failed");
        this.deleteObject(token, targetUri, e, deleteRedirector, deleteListener);
        if (!e.isEmpty()) {
            throw e;
        }
        try {
            if (MacroEvent.DELETE.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(MacroEvent.DELETE, new MacroEvent(this, token, this.namespace, targetUri));
            }
        }
        catch (VetoException ve) {
            throw new DeleteMacroException(ve.getMessage());
        }
    }

    private void copyObject(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, boolean isRootOfCopy, CopyMacroException e, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) {
        Domain.debug("Copy object : from " + sourceUri + " to " + destinationUri);
        try {
            NodeRevisionDescriptors sourceNrds;
            ObjectNode destinationNode;
            Enumeration sourceNodeChildren;
            ObjectNode sourceNode;
            block28: {
                if (this.isLockNull(token, sourceUri)) {
                    return;
                }
                sourceNode = this.structureHelper.retrieve(token, sourceUri, false);
                sourceNodeChildren = sourceNode.enumerateChildren();
                destinationNode = null;
                if (copyRedirector != null) {
                    CopyRouteRedirector.CopyRoute copyRoute = new CopyRouteRedirector.CopyRoute(sourceUri, destinationUri);
                    copyRoute = copyRedirector.getRedirectedCopyRoute(copyRoute);
                    sourceUri = copyRoute.getSourceUri();
                    destinationUri = copyRoute.getDestinationUri();
                    sourceNode = this.structureHelper.retrieve(token, sourceUri, false);
                }
                if (copyListener != null) {
                    copyListener.beforeCopy(sourceUri, destinationUri, isRootOfCopy);
                }
                if (isRootOfCopy && parameters.isDeleteCreate()) {
                    try {
                        this.structureHelper.retrieve(token, destinationUri);
                        if (parameters.getParameter("parentBindings") != null) {
                            Map parentBindings = (Map)parameters.getParameter("parentBindings");
                            Iterator i = parentBindings.entrySet().iterator();
                            while (i.hasNext()) {
                                Map.Entry me = i.next();
                                String uriToDelete = (String)me.getKey() + "/" + (String)me.getValue();
                                this.delete(token, uriToDelete, deleteRedirector, deleteListener);
                            }
                        } else {
                            this.delete(token, destinationUri, deleteRedirector, deleteListener);
                        }
                    }
                    catch (ObjectNotFoundException onf) {
                    }
                    catch (DeleteMacroException s) {
                        Enumeration en = s.enumerateExceptions();
                        if (!en.hasMoreElements()) break block28;
                        throw (SlideException)en.nextElement();
                    }
                }
            }
            boolean destinationExists = this.destinationExists(token, destinationUri);
            if (parameters.isDeleteCreate() || !destinationExists) {
                try {
                    Map alreadyCopied = (Map)parameters.getParameter("alreadyCopied");
                    if (alreadyCopied.containsKey(sourceNode.getUuri())) {
                        UriHandler destinationUh = new UriHandler(destinationUri);
                        UriHandler destinationParentUh = destinationUh.getParent();
                        String segment = destinationUh.getLastSegment();
                        destinationNode = this.structureHelper.retrieve(token, (String)alreadyCopied.get(sourceNode.getUuri()));
                        ObjectNode destinationParentNode = this.structureHelper.retrieve(token, destinationParentUh.toString());
                        this.structureHelper.addBinding(token, destinationParentNode, segment, destinationNode);
                    } else {
                        this.structureHelper.create(token, sourceNode.copyObject(), destinationUri);
                        destinationNode = this.structureHelper.retrieve(token, destinationUri);
                        alreadyCopied.put(sourceNode.getUuri(), destinationNode.getUri());
                    }
                }
                catch (ObjectNotFoundException s) {
                    throw new ConflictException(s.getObjectUri());
                }
            }
            try {
                Enumeration sourcePermissions = this.securityHelper.enumeratePermissions(token, sourceNode);
                while (sourcePermissions.hasMoreElements()) {
                    NodePermission permission = (NodePermission)sourcePermissions.nextElement();
                    NodePermission newPermission = new NodePermission(destinationUri, permission.getSubjectUri(), permission.getActionUri(), permission.isInheritable(), permission.isNegative());
                    this.securityHelper.grantPermission(token, newPermission);
                }
            }
            catch (AccessDeniedException ex) {
                // empty catch block
            }
            if ((sourceNrds = this.contentHelper.retrieve(token, sourceNode.getUri())).hasRevisions()) {
                NodeRevisionDescriptor sourceNrd = this.contentHelper.retrieve(token, sourceNrds);
                NodeRevisionContent sourceNrc = null;
                if (sourceNrd.getContentLength() > 0L) {
                    sourceNrc = this.contentHelper.retrieve(token, sourceNrds, sourceNrd);
                }
                if (parameters.isDeleteCreate() || !destinationExists) {
                    this.contentHelper.create(token, destinationUri, sourceNrd, sourceNrc);
                } else {
                    NodeRevisionDescriptor destinationNrd = this.contentHelper.retrieve(token, this.contentHelper.retrieve(token, destinationUri));
                    Enumeration sourceProps = sourceNrd.enumerateProperties();
                    while (sourceProps.hasMoreElements()) {
                        destinationNrd.setProperty((NodeProperty)sourceProps.nextElement());
                    }
                    this.contentHelper.store(token, destinationUri, destinationNrd, sourceNrc);
                }
            }
            if (copyListener != null) {
                copyListener.afterCopy(sourceUri, destinationUri, isRootOfCopy, destinationExists);
            }
            if (parameters.isRecursive()) {
                while (sourceNodeChildren.hasMoreElements()) {
                    String childUri = (String)sourceNodeChildren.nextElement();
                    String childDestinationUri = destinationUri + childUri.substring(sourceNode.getUri().length());
                    this.copyObject(token, childUri, childDestinationUri, parameters, false, e, copyRedirector, copyListener, deleteRedirector, deleteListener);
                }
            }
        }
        catch (SlideException ex) {
            e.addException(ex);
        }
    }

    private boolean destinationExists(SlideToken token, String destinationUri) throws ServiceAccessException, LinkedObjectNotFoundException, RevisionDescriptorNotFoundException, ObjectLockedException, AccessDeniedException, VetoException {
        boolean destinationExists = true;
        try {
            this.contentHelper.retrieve(token, this.contentHelper.retrieve(token, destinationUri));
        }
        catch (ObjectNotFoundException x) {
            destinationExists = false;
        }
        return destinationExists;
    }

    private void deleteObject(SlideToken token, String targetUri, MacroException e, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) {
        Domain.debug("Delete object : " + targetUri);
        try {
            ObjectNode currentObject = this.structureHelper.retrieve(token, targetUri, false);
            if (!Configuration.useBinding(this.namespace.getUri(token, targetUri).getStore()) || currentObject.numberOfParentBindings() < 2) {
                if (currentObject.hasChildren()) {
                    Enumeration children = currentObject.enumerateChildren();
                    while (children.hasMoreElements()) {
                        String childUri = (String)children.nextElement();
                        this.deleteObject(token, childUri, e, deleteRedirector, deleteListener);
                    }
                }
                if (currentObject.hasLinks()) {
                    Enumeration links = currentObject.enumerateLinks();
                    while (links.hasMoreElements()) {
                        String linkUri = (String)links.nextElement();
                        this.deleteObject(token, linkUri, e, deleteRedirector, deleteListener);
                    }
                }
                if (deleteRedirector != null) {
                    targetUri = deleteRedirector.getRedirectedTargetUri(targetUri);
                    currentObject = this.structureHelper.retrieve(token, targetUri, false);
                }
                if (deleteListener != null) {
                    deleteListener.beforeDelete(targetUri);
                }
                NodeRevisionDescriptors revisionDescriptors = this.contentHelper.retrieve(token, currentObject.getUri());
                Enumeration locks = this.lockHelper.enumerateLocks(token, currentObject.getUri(), false);
                while (locks.hasMoreElements()) {
                    this.lockHelper.unlock(token, (NodeLock)locks.nextElement());
                }
                Enumeration permissions = this.securityHelper.enumeratePermissions(token, currentObject);
                while (permissions.hasMoreElements()) {
                    NodePermission permission = (NodePermission)permissions.nextElement();
                    this.securityHelper.revokePermission(token, permission);
                }
                if (!revisionDescriptors.isRedirected()) {
                    Enumeration revisionNumberEnum = revisionDescriptors.enumerateRevisionNumbers();
                    if (revisionNumberEnum != null) {
                        while (revisionNumberEnum.hasMoreElements()) {
                            this.contentHelper.remove(token, currentObject.getUri(), (NodeRevisionNumber)revisionNumberEnum.nextElement());
                        }
                    }
                    this.removeHiddenRevisions(token, targetUri);
                    this.contentHelper.remove(token, revisionDescriptors);
                }
            }
            this.structureHelper.remove(token, currentObject);
            if (deleteListener != null) {
                deleteListener.afterDelete(targetUri);
            }
        }
        catch (ObjectHasChildrenException ex) {
        }
        catch (SlideException ex) {
            e.addException(ex);
        }
    }

    private void removeHiddenRevisions(SlideToken token, String targetUri) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, ObjectLockedException, VetoException {
        try {
            this.contentHelper.remove(token, targetUri, NodeRevisionNumber.HIDDEN_0_0);
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            // empty catch block
        }
    }

    private boolean sameStore(SlideToken token, String leftUri, String rightUri) {
        Store leftStore = this.namespace.getUri(token, leftUri).getStore();
        Store rightStore = this.namespace.getUri(token, rightUri).getStore();
        if (leftStore == null || rightStore == null) {
            throw new IllegalStateException("Got null store: leftStore=" + leftStore + ", rightStore=" + rightStore);
        }
        return leftStore == rightStore;
    }

    private boolean isLockNull(SlideToken slideToken, String uriStr) throws ServiceAccessException {
        boolean isLockNull = false;
        try {
            NodeRevisionDescriptor nrd = this.contentHelper.retrieve(slideToken, this.contentHelper.retrieve(slideToken, uriStr));
            isLockNull = this.isLockNull(nrd);
        }
        catch (ServiceAccessException x) {
            throw x;
        }
        catch (SlideException x) {
            // empty catch block
        }
        return isLockNull;
    }

    private boolean isLockNull(NodeRevisionDescriptor nrd) {
        return nrd.propertyValueContains("resourcetype", "lock-null");
    }

    private static class UriHandler {
        String[] tokens = null;
        final String uriDelimiter = "/";

        UriHandler(String uri) {
            StringTokenizer ut = new StringTokenizer(uri, "/");
            int ntok = ut.countTokens();
            this.tokens = new String[ntok];
            for (int i = 0; i < ntok; ++i) {
                this.tokens[i] = ut.nextToken();
            }
        }

        UriHandler(String[] toks) {
            this.tokens = new String[toks.length];
            for (int i = 0; i < toks.length; ++i) {
                this.tokens[i] = toks[i];
            }
        }

        UriHandler(String[] toks, int number) {
            this.tokens = new String[number];
            for (int i = 0; i < number; ++i) {
                this.tokens[i] = toks[i];
            }
        }

        boolean isRoot() {
            return this.tokens.length == 0;
        }

        UriHandler getParent() {
            if (this.isRoot()) {
                return null;
            }
            return new UriHandler(this.tokens, this.tokens.length - 1);
        }

        boolean isParentOf(UriHandler uh) {
            return this.equals(uh.getParent());
        }

        String getLastSegment() {
            return this.tokens[this.tokens.length - 1];
        }

        public boolean equals(Object o) {
            if (o instanceof UriHandler) {
                UriHandler ouh = (UriHandler)o;
                return Arrays.equals(this.tokens, ouh.tokens);
            }
            return false;
        }

        public int hashCode() {
            return this.tokens.length;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            if (this.tokens.length == 0) {
                b.append("/");
            }
            for (int i = 0; i < this.tokens.length; ++i) {
                b.append("/").append(this.tokens[i]);
            }
            return b.toString();
        }
    }
}

