/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.slide.common.PropertyName;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.ContentAdapter;
import org.apache.slide.event.ContentEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.extractor.ExtractorException;
import org.apache.slide.extractor.ExtractorManager;
import org.apache.slide.extractor.PropertyExtractor;

public class PropertyExtractorTrigger
extends ContentAdapter {
    public void create(ContentEvent event) throws VetoException {
        this.store(event);
    }

    public void store(ContentEvent event) throws VetoException {
        try {
            String namespaceName = event.getNamespace() == null ? null : event.getNamespace().getName();
            NodeRevisionDescriptors descriptors = event.getRevisionDescriptors();
            NodeRevisionDescriptor descriptor = event.getRevisionDescriptor();
            NodeRevisionContent content = event.getRevisionContent();
            if (content != null && descriptor != null) {
                PropertyExtractor[] extractor = ExtractorManager.getInstance().getPropertyExtractors(namespaceName, descriptors, descriptor);
                for (int i = 0; i < extractor.length; ++i) {
                    Map extractedProperties = extractor[i].extract(new ByteArrayInputStream(content.getContentBytes()));
                    Iterator j = extractedProperties.entrySet().iterator();
                    while (j.hasNext()) {
                        Map.Entry entry = j.next();
                        Object key = entry.getKey();
                        if (key instanceof PropertyName) {
                            String name = ((PropertyName)key).getName();
                            String namespace = ((PropertyName)key).getNamespace();
                            descriptor.setProperty(name, namespace, entry.getValue());
                            continue;
                        }
                        descriptor.setProperty((String)entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        catch (ExtractorException e) {
            throw new VetoException(e.getMessage());
        }
    }
}

