/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.slide.extractor.AbstractContentExtractor;
import org.apache.slide.extractor.ExtractorException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PDFExtractor
extends AbstractContentExtractor {
    public PDFExtractor(String uri, String contentType, String namespace) {
        super(uri, contentType, namespace);
    }

    public Reader extract(InputStream content) throws ExtractorException {
        try {
            PDFParser parser = new PDFParser(content);
            parser.parse();
            PDDocument document = parser.getPDDocument();
            CharArrayWriter writer = new CharArrayWriter();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setLineSeparator("\n");
            stripper.writeText(document, (Writer)writer);
            document.close();
            writer.close();
            return new CharArrayReader(writer.toCharArray());
        }
        catch (Exception e) {
            throw new ExtractorException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream(args[0]);
        PDFExtractor ex = new PDFExtractor(null, null, null);
        Reader reader = ex.extract(in);
        int c = 0;
        do {
            c = reader.read();
            System.out.print((char)c);
        } while (c != -1);
    }
}

