/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.slide.extractor.AbstractContentExtractor;
import org.apache.slide.extractor.ExtractorException;

public class MSExcelExtractor
extends AbstractContentExtractor {
    public MSExcelExtractor(String uri, String contentType, String namespace) {
        super(uri, contentType, namespace);
    }

    public Reader extract(InputStream content) throws ExtractorException {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            POIFSFileSystem fs = new POIFSFileSystem(content);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    Iterator cells = row.cellIterator();
                    while (cells.hasNext()) {
                        HSSFCell cell = (HSSFCell)cells.next();
                        switch (cell.getCellType()) {
                            case 0: {
                                String num = Double.toString(cell.getNumericCellValue()).trim();
                                if (num.length() <= 0) break;
                                writer.write(num + " ");
                                break;
                            }
                            case 1: {
                                String text = cell.getStringCellValue().trim();
                                if (text.length() <= 0) break;
                                writer.write(text + " ");
                            }
                        }
                    }
                }
            }
            return new CharArrayReader(writer.toCharArray());
        }
        catch (Exception e) {
            throw new ExtractorException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream(args[0]);
        MSExcelExtractor ex = new MSExcelExtractor(null, null, null);
        Reader reader = ex.extract(in);
        int c = 0;
        do {
            c = reader.read();
            System.out.print((char)c);
        } while (c != -1);
    }
}

