/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.MacroListener;
import org.apache.slide.event.RemoteInformation;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;

public class MacroEvent
extends EventObject
implements RemoteInformation {
    public static final Move MOVE = new Move();
    public static final Copy COPY = new Copy();
    public static final Delete DELETE = new Delete();
    public static final String GROUP = "macro";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{MOVE, COPY, DELETE};
    protected static final String SOURCE_URI_KEY = "source-uri";
    protected static final String TARGET_URI_KEY = "target-uri";
    private String sourceURI;
    private String targetURI;
    private SlideToken token;
    private Namespace namespace;

    public MacroEvent(Object source, SlideToken token, Namespace namespace, String tagetURI) {
        this(source, token, namespace, null, tagetURI);
    }

    public MacroEvent(Object source, SlideToken token, Namespace namespace, String sourceURI, String targetURI) {
        super(source);
        this.sourceURI = sourceURI;
        this.targetURI = targetURI;
        this.token = token;
        this.namespace = namespace;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[source-uri=").append(this.sourceURI);
        buffer.append(", target-uri=").append(this.targetURI);
        buffer.append("]");
        return buffer.toString();
    }

    public String[][] getInformation() {
        return new String[][]{{SOURCE_URI_KEY, this.sourceURI}, {TARGET_URI_KEY, this.targetURI}};
    }

    public static final class Delete
    extends VetoableEventMethod {
        public Delete() {
            super(MacroEvent.GROUP, "delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof MacroListener) {
                ((MacroListener)listener).delete((MacroEvent)event);
            }
        }
    }

    public static final class Move
    extends VetoableEventMethod {
        public Move() {
            super(MacroEvent.GROUP, "move");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof MacroListener) {
                ((MacroListener)listener).move((MacroEvent)event);
            }
        }
    }

    public static final class Copy
    extends VetoableEventMethod {
        public Copy() {
            super(MacroEvent.GROUP, "copy");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof MacroListener) {
                ((MacroListener)listener).copy((MacroEvent)event);
            }
        }
    }
}

