/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.cluster;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.common.Uri;
import org.apache.slide.store.ExtendedStore;
import org.apache.slide.store.Store;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.webdav.lib.NotificationListener;
import org.apache.webdav.lib.Subscriber;

public class ClusterCacheRefresher
implements EventListener,
Configurable {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$cluster$ClusterCacheRefresher == null ? (class$org$apache$slide$cluster$ClusterCacheRefresher = ClusterCacheRefresher.class$("org.apache.slide.cluster.ClusterCacheRefresher")) : class$org$apache$slide$cluster$ClusterCacheRefresher).getName();
    protected NotificationListener listener;
    static /* synthetic */ Class class$org$apache$slide$cluster$ClusterCacheRefresher;

    public ClusterCacheRefresher() {
        Domain.log("Creating ClusterCacheRefresher", LOG_CHANNEL, 6);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Domain.log("Configuring ClusterCacheRefresher", LOG_CHANNEL, 6);
        Enumeration nodes = configuration.getConfigurations("node");
        while (nodes.hasMoreElements()) {
            Protocol protocol;
            Configuration node = (Configuration)nodes.nextElement();
            final String host = node.getAttribute("local-host");
            final int port = node.getAttributeAsInt("local-port");
            final String repositoryHost = node.getAttribute("repository-host");
            final int repositoryPort = node.getAttributeAsInt("repository-port");
            String repositoryProtocolString = node.getAttribute("repository-protocol", "http");
            try {
                protocol = Protocol.getProtocol((String)repositoryProtocolString);
            }
            catch (IllegalStateException exception) {
                throw new ConfigurationException("Unknown repository-protocol: " + repositoryProtocolString + ". Must be \"http\" or \"https\".", configuration);
            }
            String username = node.getAttribute("username", "");
            String password = node.getAttribute("password", "");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            String repositoryDomain = node.getAttribute("repository-domain", "/slide");
            int pollInterval = node.getAttributeAsInt("poll-interval", 60000);
            boolean udp = node.getAttributeAsBoolean("udp", true);
            String uri = node.getAttribute("base-uri", "/");
            int depth = Integer.MAX_VALUE;
            int lifetime = node.getAttributeAsInt("subscription-lifetime", 3600);
            int notificationDelay = node.getAttributeAsInt("notification-delay", 0);
            Subscriber contentSubscriber = new Subscriber(){

                public void notify(String uri, Map information) {
                    block3: {
                        NamespaceAccessToken nat = Domain.accessNamespace(new SecurityToken(this), Domain.getDefaultNamespace());
                        try {
                            nat.begin();
                            Iterator keys = information.keySet().iterator();
                            while (keys.hasNext()) {
                                Uri theUri;
                                Store store;
                                String key = keys.next().toString();
                                if (!"uri".equals(key) || !((store = (theUri = nat.getUri(new SlideTokenImpl(new CredentialsToken("")), ClusterCacheRefresher.this.stripUri(information.get(key).toString()))).getStore()) instanceof ExtendedStore)) continue;
                                Domain.log("Resetting cache for " + theUri, LOG_CHANNEL, 6);
                                ((ExtendedStore)store).removeObjectFromCache(theUri);
                            }
                            nat.commit();
                        }
                        catch (Exception e) {
                            if (!Domain.isEnabled(LOG_CHANNEL, 2)) break block3;
                            Domain.log("Error clearing cache: " + e + ". See stderr for stacktrace.", LOG_CHANNEL, 2);
                            e.printStackTrace();
                        }
                    }
                }
            };
            Subscriber structureSubscriber = new Subscriber(){

                public void notify(String uri, Map information) {
                    block3: {
                        NamespaceAccessToken nat = Domain.accessNamespace(new SecurityToken(this), Domain.getDefaultNamespace());
                        try {
                            nat.begin();
                            Iterator keys = information.keySet().iterator();
                            while (keys.hasNext()) {
                                Uri theUri;
                                Store store;
                                String key = keys.next().toString();
                                if (!"uri".equals(key) || !((store = (theUri = nat.getUri(new SlideTokenImpl(new CredentialsToken("")), ClusterCacheRefresher.this.stripUri(information.get(key).toString()))).getParentUri().getStore()) instanceof ExtendedStore)) continue;
                                Domain.log("Resetting cache for " + theUri.getParentUri(), LOG_CHANNEL, 6);
                                ((ExtendedStore)store).removeObjectFromCache(theUri.getParentUri());
                            }
                            nat.commit();
                        }
                        catch (Exception e) {
                            if (!Domain.isEnabled(LOG_CHANNEL, 2)) break block3;
                            Domain.log("Error clearing cache: " + e + ". See stderr for stacktrace.", LOG_CHANNEL, 2);
                            e.printStackTrace();
                        }
                    }
                }
            };
            Thread t = new Thread(new Runnable((Credentials)credentials, repositoryDomain, pollInterval, udp, uri, lifetime, notificationDelay, contentSubscriber, structureSubscriber){
                private boolean success;
                private final /* synthetic */ Credentials val$credentials;
                private final /* synthetic */ String val$repositoryDomain;
                private final /* synthetic */ int val$pollInterval;
                private final /* synthetic */ boolean val$udp;
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ int val$lifetime;
                private final /* synthetic */ int val$notificationDelay;
                private final /* synthetic */ Subscriber val$contentSubscriber;
                private final /* synthetic */ Subscriber val$structureSubscriber;
                {
                    this.val$credentials = val$credentials;
                    this.val$repositoryDomain = val$repositoryDomain;
                    this.val$pollInterval = val$pollInterval;
                    this.val$udp = val$udp;
                    this.val$uri = val$uri;
                    this.val$lifetime = val$lifetime;
                    this.val$notificationDelay = val$notificationDelay;
                    this.val$contentSubscriber = val$contentSubscriber;
                    this.val$structureSubscriber = val$structureSubscriber;
                }

                public void run() {
                    this.success = true;
                    ClusterCacheRefresher.this.listener = new NotificationListener(host, port, repositoryHost, repositoryPort, protocol, this.val$credentials, this.val$repositoryDomain, this.val$pollInterval, this.val$udp);
                    this.success = ClusterCacheRefresher.this.listener.subscribe("Update", this.val$uri, Integer.MAX_VALUE, this.val$lifetime, this.val$notificationDelay, this.val$contentSubscriber, this.val$credentials);
                    this.success = ClusterCacheRefresher.this.listener.subscribe("Update/newmember", this.val$uri, Integer.MAX_VALUE, this.val$lifetime, this.val$notificationDelay, this.val$structureSubscriber, this.val$credentials);
                    this.success = ClusterCacheRefresher.this.listener.subscribe("Delete", this.val$uri, Integer.MAX_VALUE, this.val$lifetime, this.val$notificationDelay, this.val$structureSubscriber, this.val$credentials);
                    this.success = ClusterCacheRefresher.this.listener.subscribe("Move", this.val$uri, Integer.MAX_VALUE, this.val$lifetime, this.val$notificationDelay, this.val$structureSubscriber, this.val$credentials);
                    if (!this.success) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {}
                    } else {
                        try {
                            Thread.sleep(this.val$lifetime * 1000 - 60);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    private String stripUri(String uri) {
        if (uri.indexOf("/") == 0) {
            uri = uri.substring(1);
        }
        if (uri.indexOf("/") > -1) {
            uri = uri.substring(uri.indexOf("/"));
        }
        return uri;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

