/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.xmlutil;

import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlSerializer
implements ContentHandler {
    private static boolean needsNamespaceFix = false;
    private static boolean needsNamespaceFixInitialized = false;
    private static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private ContentHandler nextHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlSerializer(OutputStream outputStream) throws Exception {
        if (!needsNamespaceFixInitialized) {
            XmlSerializer xmlSerializer = this;
            synchronized (xmlSerializer) {
                if (!needsNamespaceFixInitialized) {
                    needsNamespaceFix = this.needsNamespacesAsAttributes();
                    needsNamespaceFixInitialized = true;
                }
            }
        }
        TransformerHandler serializer = this.getTransformerHandler();
        serializer.getTransformer().setOutputProperty("method", "xml");
        serializer.setResult(new StreamResult(outputStream));
        this.nextHandler = needsNamespaceFix ? new NamespaceAsAttributes(serializer) : serializer;
    }

    private TransformerHandler getTransformerHandler() throws TransformerConfigurationException {
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        return transformerFactory.newTransformerHandler();
    }

    private boolean needsNamespacesAsAttributes() throws Exception {
        StringWriter writer = new StringWriter();
        String uri = "namespaceuri";
        String prefix = "nsp";
        String check = "xmlns:" + prefix + "='" + uri + "'";
        TransformerHandler handler = this.getTransformerHandler();
        handler.setResult(new StreamResult(writer));
        handler.startDocument();
        handler.startPrefixMapping(prefix, uri);
        handler.startElement(uri, "element", "", new AttributesImpl());
        handler.endPrefixMapping(prefix);
        handler.endDocument();
        String text = writer.toString();
        boolean needsIt = text.replace('\"', '\'').indexOf(check) == -1;
        return needsIt;
    }

    public void endDocument() throws SAXException {
        this.nextHandler.endDocument();
    }

    public void startDocument() throws SAXException {
        this.nextHandler.startDocument();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.nextHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.nextHandler.ignorableWhitespace(ch, start, length);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.nextHandler.endPrefixMapping(prefix);
    }

    public void skippedEntity(String name) throws SAXException {
        this.nextHandler.skippedEntity(name);
    }

    public void setDocumentLocator(Locator locator) {
        this.nextHandler.setDocumentLocator(locator);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.nextHandler.processingInstruction(target, data);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nextHandler.startPrefixMapping(prefix, uri);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.nextHandler.endElement(namespaceURI, localName, qName);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.nextHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public class NamespaceAsAttributes
    implements ContentHandler {
        private List prefixList = new ArrayList();
        private List uriList = new ArrayList();
        private Map uriToPrefixMap = new HashMap();
        private Map prefixToUriMap = new HashMap();
        private boolean hasMappings = false;
        private ContentHandler nextHandler;

        public NamespaceAsAttributes(ContentHandler nextHandler) {
            this.nextHandler = nextHandler;
        }

        public void startDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.nextHandler.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri != null && !prefix.startsWith("xml") && !this.prefixList.contains(prefix)) {
                this.hasMappings = true;
                this.prefixList.add(prefix);
                this.uriList.add(uri);
                if (prefix.length() > 0) {
                    this.uriToPrefixMap.put(uri, prefix + ":");
                } else {
                    this.uriToPrefixMap.put(uri, prefix);
                }
                this.prefixToUriMap.put(prefix, uri);
            }
            this.nextHandler.startPrefixMapping(prefix, uri);
        }

        public void startElement(String eltUri, String eltLocalName, String eltQName, Attributes attrs) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            if (this.hasMappings) {
                AttributesImpl newAttrs = null;
                int mappingCount = this.prefixList.size();
                int attrCount = attrs.getLength();
                for (int mapping = 0; mapping < mappingCount; ++mapping) {
                    String uri = (String)this.uriList.get(mapping);
                    String prefix = (String)this.prefixList.get(mapping);
                    String qName = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                    boolean found = false;
                    for (int attr = 0; attr < attrCount; ++attr) {
                        if (!qName.equals(attrs.getQName(attr))) continue;
                        if (!uri.equals(attrs.getValue(attr))) {
                            System.err.println("XML serializer: URI in prefix mapping and attribute do not match : '" + uri + "' - '" + attrs.getURI(attr) + "'");
                            throw new SAXException("URI in prefix mapping and attribute do not match");
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (newAttrs == null) {
                        newAttrs = attrCount == 0 ? new AttributesImpl() : new AttributesImpl(attrs);
                    }
                    if (prefix.equals("")) {
                        newAttrs.addAttribute(XmlSerializer.XML_NAMESPACE_URI, "xmlns", "xmlns", "CDATA", uri);
                        continue;
                    }
                    newAttrs.addAttribute(XmlSerializer.XML_NAMESPACE_URI, prefix, qName, "CDATA", uri);
                }
                this.clearMappings();
                this.nextHandler.startElement(eltUri, eltLocalName, eltQName, newAttrs == null ? attrs : newAttrs);
            } else {
                this.nextHandler.startElement(eltUri, eltLocalName, eltQName, attrs);
            }
        }

        public void endElement(String eltUri, String eltLocalName, String eltQName) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            this.nextHandler.endElement(eltUri, eltLocalName, eltQName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            int pos;
            if (this.prefixToUriMap.containsKey(prefix)) {
                this.uriToPrefixMap.remove(this.prefixToUriMap.get(prefix));
                this.prefixToUriMap.remove(prefix);
            }
            if (this.hasMappings && (pos = this.prefixList.lastIndexOf(prefix)) != -1) {
                this.prefixList.remove(pos);
                this.uriList.remove(pos);
            }
            this.nextHandler.endPrefixMapping(prefix);
        }

        public void endDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.nextHandler.endDocument();
        }

        private void clearMappings() {
            this.hasMappings = false;
            this.prefixList.clear();
            this.uriList.clear();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.nextHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.nextHandler.ignorableWhitespace(ch, start, length);
        }

        public void skippedEntity(String name) throws SAXException {
            this.nextHandler.skippedEntity(name);
        }

        public void setDocumentLocator(Locator locator) {
            this.nextHandler.setDocumentLocator(locator);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.nextHandler.processingInstruction(target, data);
        }
    }
}

