/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class DateTimeConverter
implements Converter,
StateHolder {
    protected static final String CONVERSION_MESSAGE_ID = "javax.faces.convert.DateTimeConverter.CONVERSION";
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    protected static final String TYPE_DATE = "date";
    protected static final String TYPE_TIME = "time";
    protected static final String TYPE_BOTH = "both";
    protected static final String STYLE_DEFAULT = "default";
    protected static final String STYLE_MEDIUM = "medium";
    protected static final String STYLE_SHORT = "short";
    protected static final String STYLE_LONG = "long";
    protected static final String STYLE_FULL = "full";
    protected String _dateStyle;
    protected Locale _locale;
    protected String _pattern;
    protected String _timeStyle;
    protected TimeZone _timeZone;
    protected String _type;
    protected boolean _transient;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            DateFormat format = this.getDateFormat();
            format.setLenient(true);
            TimeZone tz = this.getTimeZone();
            if (tz != null) {
                format.setTimeZone(tz);
            }
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, CONVERSION_MESSAGE_ID, new Object[]{value, uiComponent.getId()}), (Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        DateFormat format = this.getDateFormat();
        if (this._timeZone != null) {
            format.setTimeZone(this._timeZone);
        }
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException("Cannot convert value '" + value + "'");
        }
    }

    protected DateFormat getDateFormat() {
        String type = this.getType();
        DateFormat format = null;
        if (this._pattern != null) {
            format = new SimpleDateFormat(this._pattern, this.getLocale());
        } else if (type.equals(TYPE_DATE)) {
            format = DateFormat.getDateInstance(this.calcStyle(this.getDateStyle()), this.getLocale());
        } else if (type.equals(TYPE_TIME)) {
            format = DateFormat.getTimeInstance(this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else if (type.equals(TYPE_BOTH)) {
            format = DateFormat.getDateTimeInstance(this.calcStyle(this.getDateStyle()), this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else {
            throw new ConverterException("invalid type '" + this._type + "'");
        }
        return format;
    }

    protected int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        throw new ConverterException("invalid style '" + name + "'");
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._dateStyle = (String)values[0];
        this._locale = (Locale)values[1];
        this._pattern = (String)values[2];
        this._timeStyle = (String)values[3];
        this._timeZone = (TimeZone)values[4];
        this._type = (String)values[5];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._dateStyle, this._locale, this._pattern, this._timeStyle, this._timeZone, this._type};
        return values;
    }

    public String getDateStyle() {
        return this._dateStyle != null ? this._dateStyle : STYLE_DEFAULT;
    }

    public void setDateStyle(String dateStyle) {
        this._dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public String getTimeStyle() {
        return this._timeStyle != null ? this._timeStyle : STYLE_DEFAULT;
    }

    public void setTimeStyle(String timeStyle) {
        this._timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public String getType() {
        return this._type != null ? this._type : TYPE_DATE;
    }

    public void setType(String type) {
        this._type = type;
    }
}

