/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NamespaceMap
extends HashMap {
    private Element elem = null;

    public NamespaceMap() {
    }

    public NamespaceMap(Hashtable namespaces) {
        Enumeration keys = namespaces.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setNamespace(key, (String)namespaces.get(key));
        }
    }

    public Node getContextNode() {
        if (this.elem == null) {
            DocumentImpl d = new DocumentImpl();
            this.elem = d.createElement("nsmap");
            d.appendChild(this.elem);
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String pfx = (String)entry.getKey();
                String uri = (String)entry.getValue();
                if (pfx.equals("")) {
                    this.elem.setAttribute("xmlns", uri);
                    continue;
                }
                this.elem.setAttribute("xmlns:" + pfx, uri);
            }
        }
        return this.elem;
    }

    public void clearNamespaces() {
        this.clear();
        this.elem = null;
    }

    public String getDefaultNamespaceURI() {
        return (String)this.get("");
    }

    public String getNamespaceURI(String prefix) {
        return (String)this.get(prefix);
    }

    public void setDefaultNamespace(String uri) {
        this.put("", uri);
        this.elem = null;
    }

    public void setNamespace(String prefix, String uri) {
        this.put(prefix, uri);
        this.elem = null;
    }

    public void removeDefaultNamespace() {
        this.remove("");
        this.elem = null;
    }

    public void removeNamespace(String prefix) {
        this.remove(prefix);
        this.elem = null;
    }

    public void includeNamespaces(Map nsMap, boolean override) {
        Iterator newEntries = nsMap.entrySet().iterator();
        while (newEntries.hasNext()) {
            Map.Entry entry = newEntries.next();
            if (!override && super.containsKey(entry.getKey())) continue;
            super.put(entry.getKey(), entry.getValue());
        }
        this.elem = null;
    }
}

