/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.xindice.client.xmldb.DatabaseImpl;
import org.apache.xindice.tools.ArgTokenizer;
import org.apache.xindice.tools.command.Command;
import org.apache.xindice.tools.command.Shutdown;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class XMLTools {
    public static final String COLLECTION = "collection";
    public static final String FILER = "filer";
    public static final String EXTENSION = "extension";
    public static final String FILE_PATH = "filePath";
    public static final String ACTION = "action";
    public static final String NAME_OF = "nameOf";
    public static final String PATTERN = "pattern";
    public static final String QUERY = "query";
    public static final String URI = "uri";
    public static final String VERBOSE = "verbose";
    public static final String TYPE = "type";
    public static final String PAGE_SIZE = "pagesize";
    public static final String MAX_KEY_SIZE = "maxkeysize";
    public static final String DB_SERVER = "dbServ";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String USER = "user";
    public static final String LOCAL = "local";
    public static final String DB_CONFIG = "dbconfig";
    public static final String PASSWORD = "password";
    public static final String AUTO_KEY = "autoKey";
    public static final String NAMESPACES = "namespaces";
    public static final String IMPL_CLASS = "implClass";
    public static final String COMMAND_LIST = "__command_list__";
    public static final String PAGE_COUNT = "pagecount";
    private Hashtable table = new Hashtable();
    private boolean initialized;
    private NodeList commandsList;

    public static void main(String[] args) {
        block2: {
            XMLTools tools = new XMLTools();
            try {
                tools.process(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (!tools.isVerbose()) break block2;
                e.printStackTrace();
            }
        }
    }

    public XMLTools() {
        this.table.put(FILE_PATH, "");
        this.table.put(EXTENSION, "");
        this.table.put(QUERY, "");
        this.table.put(AUTO_KEY, "");
        this.table.put(VERBOSE, "false");
    }

    private Document readCommandsDocument() throws XindiceException, FileNotFoundException {
        File xindiceHome = new File(System.getProperty("xindice.home", "."));
        File commandsFile = new File(xindiceHome, "config/commands.xml");
        return DOMParser.toDocument(new FileInputStream(commandsFile));
    }

    private void parseCommandsList(Document commands) {
        NodeList list = commands.getElementsByTagName(USER);
        if (list.getLength() > 0) {
            Element node = (Element)list.item(0);
            list = node.getElementsByTagName("command");
        }
        this.commandsList = list;
        this.table.put(COMMAND_LIST, this.commandsList);
    }

    public void init() throws XindiceException, FileNotFoundException {
        if (!this.initialized) {
            this.parseCommandsList(this.readCommandsDocument());
            this.initialized = true;
        }
    }

    protected NodeList getCommands() {
        return this.commandsList;
    }

    public void process(String[] args) throws XindiceException {
        try {
            this.init();
            this.parseArguments(args);
            this.execute();
        }
        catch (IllegalArgumentException e) {
            throw new XindiceException("ERROR : " + e.getMessage() + " Try -h for help.", e);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("ERROR : " + e + " Switch found. Parameter missing. Try -h for help.");
        }
        catch (NullPointerException e) {
            throw new NullPointerException("ERROR : " + e + " Try -h for help.");
        }
        catch (Exception e) {
            throw new XindiceException("ERROR : " + e.getMessage() + " Try -h for help.", e);
        }
    }

    protected void parseArguments(String[] args) throws IllegalArgumentException {
        ArgTokenizer at = new ArgTokenizer(args);
        if (!at.hasMoreTokens()) {
            throw new IllegalArgumentException("No arguments found");
        }
        this.table.put(ACTION, at.nextToken());
        while (at.hasMoreTokens()) {
            String token = at.nextToken();
            if (token.equalsIgnoreCase("-c") || token.equalsIgnoreCase("--collection")) {
                String colname = at.nextSwitchToken();
                if (!colname.startsWith("/") && !colname.startsWith("xmldb:xindice")) {
                    throw new IllegalArgumentException("The name of a collection must start with '/'");
                }
                this.table.put(COLLECTION, colname);
                continue;
            }
            if (token.equalsIgnoreCase("--filer")) {
                this.table.put(FILER, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-e") || token.equalsIgnoreCase("--extension")) {
                this.table.put(EXTENSION, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-f") || token.equalsIgnoreCase("--filepath")) {
                this.table.put(FILE_PATH, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-n") || token.equalsIgnoreCase("--nameOf")) {
                this.table.put(NAME_OF, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-p") || token.equalsIgnoreCase("--pattern")) {
                this.table.put(PATTERN, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-q") || token.equalsIgnoreCase("--query")) {
                this.table.put(QUERY, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-u") || token.equalsIgnoreCase("--uri")) {
                this.table.put(URI, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-v") || token.equalsIgnoreCase("--verbose")) {
                this.table.put(VERBOSE, "true");
                continue;
            }
            if (token.equalsIgnoreCase("-l") || token.equalsIgnoreCase("--localdb")) {
                this.table.put(LOCAL, "true");
                continue;
            }
            if (token.equalsIgnoreCase("-d") || token.equalsIgnoreCase("--dbconfig")) {
                String configFile = at.nextSwitchToken();
                if (!new File(configFile).isAbsolute()) {
                    configFile = new File(System.getProperty("user.dir"), configFile).getAbsolutePath();
                }
                System.setProperty("xindice.configuration", configFile);
                this.table.put(DB_CONFIG, configFile);
                continue;
            }
            if (token.equalsIgnoreCase("-s") || token.equalsIgnoreCase("--namespaces")) {
                this.table.put(NAMESPACES, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-t") || token.equalsIgnoreCase("--type")) {
                this.table.put(TYPE, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("+trim")) {
                if (this.table.containsKey(TYPE)) continue;
                this.table.put(TYPE, "trimmed");
                continue;
            }
            if (token.equalsIgnoreCase("-trim")) {
                if (this.table.containsKey(TYPE)) continue;
                this.table.put(TYPE, "string");
                continue;
            }
            if (token.equalsIgnoreCase("--pagesize")) {
                this.table.put(PAGE_SIZE, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("--maxkeysize")) {
                this.table.put(MAX_KEY_SIZE, at.nextSwitchToken());
                continue;
            }
            if (!token.equalsIgnoreCase("--pagecount")) continue;
            this.table.put(PAGE_COUNT, at.nextSwitchToken());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws Exception {
        boolean e2;
        Command command;
        this.init();
        String action = (String)this.table.get(ACTION);
        String commandClass = null;
        if (action != null) {
            NodeList commands = this.getCommands();
            int i = 0;
            while (i < commands.getLength()) {
                Element e2 = (Element)commands.item(i);
                if (action.equals(e2.getAttribute("switch")) || action.equals(e2.getAttribute("name"))) {
                    commandClass = e2.getAttribute("class");
                }
                ++i;
            }
        }
        if (commandClass == null) {
            throw new IllegalArgumentException("\"" + action + "\" not recognized.");
        }
        try {
            try {
                DatabaseImpl db = new DatabaseImpl();
                DatabaseManager.registerDatabase((Database)db);
                command = (Command)Class.forName(commandClass).newInstance();
                command.execute(this.table);
                e2 = true;
                Object var8_11 = null;
                if (!"true".equals(this.table.get(LOCAL))) return e2;
                command = new Shutdown();
            }
            catch (XMLDBException e3) {
                System.err.println("XMLDB Exception " + e3.errorCode + ": " + e3.getMessage());
                if (this.isVerbose()) {
                    e3.printStackTrace(System.err);
                }
                boolean e2 = false;
                Object var8_12 = null;
                if (!"true".equals(this.table.get(LOCAL))) return e2;
                command = new Shutdown();
                command.execute(this.table);
                return e2;
            }
            catch (Exception e4) {
                System.err.println("ERROR : " + e4.getMessage());
                if (this.isVerbose()) {
                    e4.printStackTrace(System.err);
                }
                boolean bl = false;
                Object var8_13 = null;
                if (!"true".equals(this.table.get(LOCAL))) return bl;
                command = new Shutdown();
                command.execute(this.table);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (!"true".equals(this.table.get(LOCAL))) throw throwable;
            command = new Shutdown();
            command.execute(this.table);
            throw throwable;
        }
        command.execute(this.table);
        return e2;
    }

    public boolean handleOption(String option, ArgTokenizer at) {
        return false;
    }

    public void setVerbose(boolean verbose) {
        this.table.put(VERBOSE, verbose ? "true" : "false");
    }

    public boolean isVerbose() {
        return "true".equals(this.table.get(VERBOSE));
    }

    public void setAction(String actionType) {
        this.table.put(ACTION, actionType);
    }

    public String getAction() {
        return (String)this.table.get(ACTION);
    }

    public void setCollectionName(String collectionName) {
        this.table.put(COLLECTION, collectionName);
    }

    public String getCollectionName() {
        return (String)this.table.get(COLLECTION);
    }

    public void setDocumentName(String documentName) {
        this.table.put(NAME_OF, documentName);
    }

    public String getDocumentName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setQuery(String query) {
        this.table.put(QUERY, query);
    }

    public String getQuery() {
        return (String)this.table.get(QUERY);
    }

    public void setName(String name) {
        this.table.put(NAME_OF, name);
    }

    public String getName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setDatabaseServer(String appName) {
        this.table.put(DB_SERVER, appName);
    }

    public String getDatabaseServer() {
        return (String)this.table.get(DB_SERVER);
    }

    public void setPort(String portName) {
        this.table.put(PORT, portName);
    }

    public String getPort() {
        return (String)this.table.get(PORT);
    }

    public void setHost(String hostName) {
        this.table.put(HOST, hostName);
    }

    public String getHost() {
        return (String)this.table.get(HOST);
    }

    public void setFilePath(String fPath) {
        this.table.put(FILE_PATH, fPath);
    }

    public String getFilePath() {
        return (String)this.table.get(FILE_PATH);
    }

    public void setURI(String URI2) {
        this.table.put(URI, URI2);
    }

    public String getURI() {
        return (String)this.table.get(URI);
    }

    public void setImplementClass(String imClassName) {
        this.table.put(IMPL_CLASS, imClassName);
    }

    public String getImplementClass() {
        return (String)this.table.get(IMPL_CLASS);
    }

    public void setUser(String userName) {
        this.table.put(USER, userName);
    }

    public String getUser() {
        return (String)this.table.get(USER);
    }

    public void setPassword(String pswd) {
        this.table.put(PASSWORD, pswd);
    }

    public String getPassword() {
        return (String)this.table.get(PASSWORD);
    }
}

