/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeCallback;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeFiler;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.filer.HashFiler;
import org.apache.xindice.core.filer.Paged;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.dom.DOMParser;

public class DatabaseRebuild {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$tools$DatabaseRebuild == null ? (class$org$apache$xindice$tools$DatabaseRebuild = DatabaseRebuild.class$("org.apache.xindice.tools.DatabaseRebuild")) : class$org$apache$xindice$tools$DatabaseRebuild));
    private static final int CMD_ALL = 0;
    private static final int CMD_COPY = 1;
    private static final int CMD_INDEX = 2;
    private static final char NOT_RAN = '_';
    private static final char SUCCESS = '*';
    private static final char ERROR = '!';
    static /* synthetic */ Class class$org$apache$xindice$tools$DatabaseRebuild;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[1] == null || args[1].length() == 0 || !"copy".equals(args[0]) && !"index".equals(args[0]) && !"rebuild".equals(args[0])) {
            DatabaseRebuild.usage();
            System.exit(1);
        }
        int command = "copy".equals(args[0]) ? 1 : ("index".equals(args[0]) ? 2 : 0);
        File location = new File(args[1]);
        String path = location.getAbsolutePath();
        String name = location.getName();
        if ("".equals(name) || !location.exists() || !location.isDirectory()) {
            System.out.println("Database path must point to existing database directory");
            System.exit(1);
        }
        String config = "<root-collection dbroot='" + path + "/' name='" + name + "'/>";
        Database db = new Database();
        boolean success = true;
        try {
            System.out.println("Processing database " + path);
            System.out.println();
            System.out.println("DI\tCollection name");
            db.setConfig(new Configuration(DOMParser.toDocument(config)));
            if (log.isInfoEnabled()) {
                log.info((Object)"Rebuilding collections...");
            }
            success = DatabaseRebuild.processCollection(db, command);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            db.close();
            System.out.println();
            System.out.println("Legend:");
            System.out.println("    D Data file");
            System.out.println("    I Index files");
            System.out.println("    _ File was skipped");
            System.out.println("    * File was processed successfuly");
            System.out.println("    ! File processing failed");
            System.out.println();
            if (success) {
                System.out.println("Rebuilding database was successfull.");
            } else {
                System.out.println("Rebuilding database failed. Please check logs for more detail.");
            }
            System.exit(success ? 0 : 2);
            throw throwable;
        }
        db.close();
        System.out.println();
        System.out.println("Legend:");
        System.out.println("    D Data file");
        System.out.println("    I Index files");
        System.out.println("    _ File was skipped");
        System.out.println("    * File was processed successfuly");
        System.out.println("    ! File processing failed");
        System.out.println();
        if (success) {
            System.out.println("Rebuilding database was successfull.");
        } else {
            System.out.println("Rebuilding database failed. Please check logs for more detail.");
        }
        System.exit(success ? 0 : 2);
    }

    private static void usage() {
        System.out.println("Xindice 1.1 Database Rebuild Utility");
        System.out.println("Usage:");
        System.out.println("    xindice_rebuild copy    <db location>");
        System.out.println("    xindice_rebuild index   <db location>");
        System.out.println("    xindice_rebuild rebuild <db location>");
        System.out.println();
        System.out.println("DB Location should point to the directory containing Xindice database files.");
        System.out.println();
        System.out.println("Important: Shutdown and backup database before proceeding!");
        System.out.println();
    }

    private static boolean processCollection(Collection col, int command) {
        boolean status;
        String name = col.getCanonicalName();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Processing collection " + name));
            }
            char copy = '_';
            char index = '_';
            switch (command) {
                case 1: {
                    status = DatabaseRebuild.rebuildCollection(col);
                    copy = status ? (char)'*' : '!';
                    break;
                }
                case 2: {
                    status = DatabaseRebuild.rebuildIndex(col);
                    index = status ? (char)'*' : '!';
                    break;
                }
                default: {
                    status = DatabaseRebuild.rebuildCollection(col);
                    char c = copy = status ? (char)'*' : '!';
                    if (!status) break;
                    status = DatabaseRebuild.rebuildIndex(col);
                    index = status ? (char)'*' : '!';
                }
            }
            System.out.println(String.valueOf(copy) + String.valueOf(index) + "\t" + name);
            String[] colNames = col.listCollections();
            int i = 0;
            while (i < colNames.length) {
                boolean result = DatabaseRebuild.processCollection(col.getCollection(colNames[i]), command);
                status = status && result;
                ++i;
            }
        }
        catch (DBException e) {
            log.error((Object)("Got an exception when processing collection " + name), (Throwable)e);
            return false;
        }
        return status;
    }

    private static boolean rebuildCollection(Collection col) {
        String newFileName;
        String oldFileName;
        Paged newFiler;
        Paged oldFiler;
        String canonicalName = col.getCanonicalName();
        try {
            if (col.getFiler() != null) {
                col.getFiler().close();
            }
        }
        catch (DBException e) {
            log.error((Object)("Could not close filer for collection " + canonicalName), (Throwable)e);
            return false;
        }
        Filer itsFiler = col.getFiler();
        if (itsFiler == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Collection " + col.getCanonicalName() + " has no filer. Skipping..."));
            }
            return true;
        }
        if (itsFiler instanceof BTreeFiler) {
            oldFiler = new BTreeCopy();
            newFiler = new BTreeCopy();
        } else if (itsFiler instanceof HashFiler) {
            oldFiler = new HashCopy();
            newFiler = new HashCopy();
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Collection " + col.getCanonicalName() + " has unrecognized filer '" + itsFiler.getClass().getName() + "'. Skipping..."));
            }
            return true;
        }
        try {
            oldFiler.setLocation(col.getCollectionRoot(), col.getName());
            oldFiler.setConfig(col.getFiler().getConfig());
            oldFileName = oldFiler.getFilerFile().getAbsolutePath();
            if (!oldFiler.exists()) {
                log.error((Object)("Filer for " + oldFileName + " does not exists"));
                return false;
            }
            newFiler.setLocation(col.getCollectionRoot(), col.getName() + ".rebuild");
            newFiler.setConfig(col.getFiler().getConfig());
            newFileName = newFiler.getFilerFile().getAbsolutePath();
            if (newFiler.exists()) {
                log.error((Object)("Filer for " + newFileName + " already exists"));
                return false;
            }
        }
        catch (XindiceException e) {
            log.error((Object)("Got an exception when preparing to rebuild " + canonicalName), (Throwable)e);
            return false;
        }
        if (!DatabaseRebuild.copy((FilerCopy)((Object)oldFiler), (FilerCopy)((Object)newFiler), canonicalName)) {
            newFiler.deleteFile();
            return false;
        }
        oldFiler.deleteFile();
        if (!newFiler.getFilerFile().renameTo(oldFiler.getFilerFile())) {
            log.error((Object)("Could not rename successfully rebuilt file " + newFileName + " to " + oldFileName));
            return false;
        }
        try {
            col.getFiler().open();
        }
        catch (DBException e) {
            log.error((Object)("Could not open new file " + oldFileName), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private static boolean copy(FilerCopy oldFiler, FilerCopy newFiler, String canonicalName) {
        block14: {
            DBException e2;
            block13: {
                newFiler.create();
                oldFiler.open();
                newFiler.open();
                oldFiler.copy(newFiler);
                Object var6_3 = null;
                try {
                    oldFiler.close();
                }
                catch (DBException e2) {
                    if (!log.isWarnEnabled()) break block13;
                    log.warn((Object)e2);
                }
            }
            try {
                newFiler.close();
            }
            catch (DBException e2) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e2);
                }
                break block14;
            }
            {
                catch (Exception e3) {
                    boolean bl;
                    block16: {
                        block15: {
                            log.error((Object)("Error copying collection " + canonicalName), (Throwable)e3);
                            bl = false;
                            Object var6_4 = null;
                            try {
                                oldFiler.close();
                            }
                            catch (DBException e2) {
                                if (!log.isWarnEnabled()) break block15;
                                log.warn((Object)e2);
                            }
                        }
                        try {
                            newFiler.close();
                        }
                        catch (DBException e2) {
                            if (!log.isWarnEnabled()) break block16;
                            log.warn((Object)e2);
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                block18: {
                    block17: {
                        Object var6_5 = null;
                        try {
                            oldFiler.close();
                        }
                        catch (DBException e2) {
                            if (!log.isWarnEnabled()) break block17;
                            log.warn((Object)e2);
                        }
                    }
                    try {
                        newFiler.close();
                    }
                    catch (DBException e2) {
                        if (!log.isWarnEnabled()) break block18;
                        log.warn((Object)e2);
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    private static boolean rebuildIndex(Collection col) {
        if (col.getFiler() == null) {
            return true;
        }
        try {
            String[] list = col.listIndexers();
            int i = 0;
            while (i < list.length) {
                Indexer idx = col.getIndexer(list[i]);
                Configuration idxConf = idx.getConfig();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Rebuilding index " + list[i] + " for collection " + col.getCanonicalName()));
                }
                col.dropIndexer(idx);
                col.createIndexer(idxConf);
                ++i;
            }
        }
        catch (DBException e) {
            log.error((Object)("Could not rebuild index for collection " + col.getCanonicalName()), (Throwable)e);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CopyCallback
    implements BTreeCallback {
        private BTreeCopy filer;
        private Filer newFiler;

        public CopyCallback(BTreeCopy filer, Filer newFiler) {
            this.filer = filer;
            this.newFiler = newFiler;
        }

        public boolean indexInfo(Value value, long pointer) {
            try {
                Value v = this.filer.getValue(pointer);
                this.newFiler.writeRecord(new Key(value), v);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return true;
        }
    }

    private static class HashCopy
    extends HashFiler
    implements FilerCopy {
        private HashCopy() {
        }

        public Value getValue(long pointer) throws IOException {
            return super.readValue(pointer);
        }

        public void copy(Filer newFiler) throws IOException, DBException {
            long hashSize = this.getFileHeader().getPageCount();
            long i = 0L;
            while (i < hashSize) {
                HashFiler.HashPageHeader ph;
                Paged.Page page = this.getPage(i);
                while ((ph = (HashFiler.HashPageHeader)page.getPageHeader()).getStatus() == 1) {
                    Value value = this.readValue(page);
                    newFiler.writeRecord(page.getKey(), value);
                    long next = ph.getNextCollision();
                    if (next == -1L) break;
                    page = this.getPage(ph.getNextCollision());
                }
                ++i;
            }
        }

        public boolean deleteFile() {
            return this.getFile().delete();
        }

        public File getFilerFile() {
            return this.getFile();
        }
    }

    private static class BTreeCopy
    extends BTreeFiler
    implements FilerCopy {
        private BTreeCopy() {
        }

        public Value getValue(long pointer) throws IOException {
            return super.readValue(pointer);
        }

        public void copy(Filer newFiler) throws IOException, BTreeException {
            this.query(null, new CopyCallback(this, newFiler));
        }

        public boolean deleteFile() {
            return this.getFile().delete();
        }

        public File getFilerFile() {
            return this.getFile();
        }
    }

    private static interface FilerCopy
    extends Filer {
        public Value getValue(long var1) throws IOException;

        public void copy(Filer var1) throws IOException, DBException;

        public boolean deleteFile();

        public File getFilerFile();
    }
}

