/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.FaultCodes;
import org.apache.xindice.core.meta.MetaData;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.dom.DOMParser;
import org.w3c.dom.Document;

public final class MetaSystemCollection
extends Collection {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$MetaSystemCollection == null ? (class$org$apache$xindice$core$MetaSystemCollection = MetaSystemCollection.class$("org.apache.xindice.core.MetaSystemCollection")) : class$org$apache$xindice$core$MetaSystemCollection));
    public static final String METACOL = "meta";
    public static final String METAS = "Metas";
    public static final String COLLECTION_META_DATA = "_META_DATA_";
    private static String METACOL_DEFINITION = "<collection name='meta'>  <collections>    <collection name='Metas' compressed='true'>    </collection>  </collections></collection>";
    private String dbCanonicalName;
    private String sysCanonicalName;
    static /* synthetic */ Class class$org$apache$xindice$core$MetaSystemCollection;

    public MetaSystemCollection(Database db) {
        super(db);
        this.dbCanonicalName = db.getCanonicalName();
        this.sysCanonicalName = db.getSystemCollection().getCanonicalName();
    }

    public void init() throws DBException {
        try {
            Document metaDoc = DOMParser.toDocument(METACOL_DEFINITION);
            Configuration metaCfg = new Configuration(metaDoc, false);
            this.setConfig(metaCfg);
        }
        catch (Exception e) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"FATAL ERROR: Generating System Collection 'meta'", (Throwable)e);
            }
            System.exit(1);
        }
    }

    public Collection getMetaCollection(Collection collection, boolean create) throws DBException {
        String path = collection.getCanonicalName();
        if (!path.startsWith(this.dbCanonicalName)) {
            return null;
        }
        if (path.startsWith(this.getCanonicalName())) {
            return null;
        }
        if (path.startsWith(this.sysCanonicalName)) {
            return null;
        }
        Collection current = this.getCollection(METAS);
        StringTokenizer st = new StringTokenizer(path.substring(this.dbCanonicalName.length()), "/");
        while (current != null && st.hasMoreTokens()) {
            String segment = st.nextToken().trim();
            if (segment.length() == 0) continue;
            Collection childcol = current.getCollection(segment);
            if (null == childcol) {
                if (!create) {
                    return null;
                }
                String cfgText = "<collection name='" + segment + "' compressed='true'>" + "  <filer class='org.apache.xindice.core.filer.BTreeFiler'/>" + "</collection>";
                try {
                    Document cfgDoc = DOMParser.toDocument(cfgText);
                    Configuration cfg = new Configuration(cfgDoc, false);
                    childcol = current.createCollection(segment, cfg);
                }
                catch (DBException de) {
                    throw de;
                }
                catch (Exception e) {
                    throw new DBException(FaultCodes.getFaultCode(e));
                }
            }
            current = childcol;
        }
        return current;
    }

    public void dropCollectionMeta(Collection collection) throws DBException {
        block3: {
            Collection mcol = this.getMetaCollection(collection, false);
            if (null != mcol) {
                try {
                    this.dropCollection(mcol);
                }
                catch (DBException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
    }

    public MetaData getCollectionMeta(Collection collection) throws DBException {
        Collection mcol = this.getMetaCollection(collection, true);
        if (null != mcol) {
            MetaData meta = (MetaData)mcol.getObject(COLLECTION_META_DATA);
            if (meta == null) {
                meta = new MetaData();
            }
            if (meta.getType() == 0) {
                meta.setType((short)1);
            }
            meta.setOwner(collection.getCanonicalName());
            meta.setDirty(false);
            return meta;
        }
        return null;
    }

    public void setCollectionMeta(Collection collection, MetaData meta) throws DBException {
        if (null == meta) {
            return;
        }
        Collection mcol = this.getMetaCollection(collection, true);
        if (null != mcol) {
            mcol.setObject(COLLECTION_META_DATA, meta);
            meta.setDirty(false);
        }
    }

    public void dropDocumentMeta(Collection collection, String id) throws DBException {
        block3: {
            Collection mcol = this.getMetaCollection(collection, false);
            if (null != mcol) {
                try {
                    mcol.remove(id);
                }
                catch (DBException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
    }

    public MetaData getDocumentMeta(Collection collection, String id) throws DBException {
        Collection mcol = this.getMetaCollection(collection, true);
        if (null != mcol) {
            MetaData meta = (MetaData)mcol.getObject(id);
            if (meta == null) {
                meta = new MetaData();
            }
            if (meta.getType() == 0) {
                meta.setType((short)2);
            }
            meta.setOwner(collection.getCanonicalName() + "/" + id);
            meta.setDirty(false);
            return meta;
        }
        return null;
    }

    public void setDocumentMeta(Collection collection, String id, MetaData meta) throws DBException {
        if (null == meta) {
            return;
        }
        Collection mcol = this.getMetaCollection(collection, true);
        if (null != mcol) {
            mcol.setObject(id, meta);
            meta.setDirty(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

