/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.dom.DBDocument;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$DocumentCache == null ? (class$org$apache$xindice$core$DocumentCache = DocumentCache.class$("org.apache.xindice.core.DocumentCache")) : class$org$apache$xindice$core$DocumentCache));
    private Map table = new WeakHashMap();
    static /* synthetic */ Class class$org$apache$xindice$core$DocumentCache;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document getDocument(Collection col, Key key) {
        Object v = this.table.get(new CacheKey(col, key));
        if (v == null) {
            return null;
        }
        if (v instanceof Document) {
            return (Document)v;
        }
        if (v instanceof String) {
            try {
                Document doc = DOMParser.toDocument((String)v);
                ((DBDocument)doc).setSource(new NodeSource(col, key));
                return doc;
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) return null;
                log.warn((Object)"ignored exception", (Throwable)e);
                return null;
            }
        } else {
            if (!(v instanceof byte[])) return null;
            try {
                SymbolTable s = col.getSymbols();
                NodeSource ns = new NodeSource(col, key);
                return new DocumentImpl((byte[])v, s, ns);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) return null;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return null;
    }

    public void putDocument(Collection col, Key key, byte[] bytes) {
        this.table.put(new CacheKey(col, key), bytes);
    }

    public void putDocument(Collection col, Key key, String chars) {
        this.table.put(new CacheKey(col, key), chars);
    }

    public void removeDocument(Collection col, Key key) {
        this.table.remove(new CacheKey(col, key));
    }

    public static int getCacheControl(Document doc) {
        String cache = "cache";
        NodeList childNodes = doc.getChildNodes();
        int size = childNodes.getLength();
        int i = 0;
        while (i < size) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 7 && n.getNodeName().equals("xindice-cache")) {
                cache = n.getNodeValue().trim();
                break;
            }
            ++i;
        }
        if (cache != null) {
            if (cache.equals("cache")) {
                return -1;
            }
            if (cache.equals("no-cache")) {
                return 0;
            }
            return Integer.parseInt(cache);
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CacheKey {
        private final Collection col;
        private final Key key;
        private String strVal;

        public CacheKey(Collection col, Key key) {
            this.col = col;
            this.key = key;
        }

        public Collection getCollection() {
            return this.col;
        }

        public Key getKey() {
            return this.key;
        }

        public String toString() {
            if (this.strVal == null) {
                this.strVal = this.col.getCanonicalDocumentName(this.key);
            }
            return this.strVal;
        }

        public int hashCode() {
            if (this.strVal == null) {
                this.strVal = this.col.getCanonicalDocumentName(this.key);
            }
            return this.strVal.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CacheKey && this.col == ((CacheKey)o).col && this.key.equals(((CacheKey)o).key);
        }
    }
}

