/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.embed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.client.xmldb.CommonConfigurable;
import org.apache.xindice.client.xmldb.embed.CollectionImpl;
import org.apache.xindice.core.Database;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ReadOnlyException;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.util.XindiceRuntimeException;
import org.apache.xindice.xml.dom.DOMParser;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
extends CommonConfigurable
implements org.xmldb.api.base.Database {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$client$xmldb$embed$DatabaseImpl == null ? (class$org$apache$xindice$client$xmldb$embed$DatabaseImpl = DatabaseImpl.class$("org.apache.xindice.client.xmldb.embed.DatabaseImpl")) : class$org$apache$xindice$client$xmldb$embed$DatabaseImpl));
    public static final String PROP_XINDICE_DB_HOME = "db-home";
    public static final String SYSPROP_XINDICE_DB_HOME = "xindice.db.home";
    public static final String PROP_XINDICE_CONFIGURATION = "configuration";
    public static final String SYSPROP_XINDICE_CONFIGURATION = "xindice.configuration";
    public static final String PROP_XINDICE_MANAGED = "db-managed";
    public static final String SYSPROP_XINDICE_MANAGED = "xindice.db.managed";
    public static final String DRIVER_NAME = "xindice-embed";
    private static final String CONFORMANCE_LEVEL = "0";
    private String configFile;
    static /* synthetic */ Class class$org$apache$xindice$client$xmldb$embed$DatabaseImpl;

    public DatabaseImpl() {
    }

    public DatabaseImpl(CommonConfigurable config) {
        super(config);
    }

    private Database getDatabase(String dbName, String uri) throws XMLDBException {
        Database database = Database.getDatabase(dbName);
        if (database == null && !this.isManaged()) {
            Configuration dbConfig = this.getConfiguration(dbName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mounting database: '" + dbName + "'"));
            }
            if (dbConfig == null) {
                throw new XMLDBException(400, "Database '" + dbName + "' not found: " + uri);
            }
            database = Database.getDatabase(dbConfig);
            if (log.isDebugEnabled()) {
                log.info((Object)("Mounted database: '" + database.getName() + "'"));
            }
        }
        return database;
    }

    protected boolean isManaged() {
        String managed = null;
        try {
            managed = this.getProperty(PROP_XINDICE_MANAGED);
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
        if (managed == null) {
            managed = System.getProperty(SYSPROP_XINDICE_MANAGED);
        }
        return Boolean.valueOf(managed);
    }

    protected Configuration getConfiguration(String dbName) throws XMLDBException {
        Configuration config = this.loadConfiguration();
        Configuration[] roots = config.getChildren("root-collection");
        config = null;
        int i = 0;
        while (i < roots.length) {
            if (dbName.equals(roots[i].getAttribute("name"))) {
                config = roots[i];
                break;
            }
            ++i;
        }
        if (config == null) {
            return null;
        }
        String dbRoot = config.getAttribute("dbroot", "./db/");
        if (!new File(dbRoot).isAbsolute()) {
            String home = null;
            try {
                home = this.getProperty(PROP_XINDICE_DB_HOME);
            }
            catch (XMLDBException e) {
                // empty catch block
            }
            if (home == null) {
                home = System.getProperty(SYSPROP_XINDICE_DB_HOME);
            }
            if (home != null) {
                try {
                    dbRoot = new File(home + File.separator + dbRoot).getCanonicalPath();
                }
                catch (IOException e) {
                    log.warn((Object)"getCanonicalPath failed", (Throwable)e);
                    dbRoot = new File(home + File.separator + dbRoot).getAbsolutePath();
                }
            } else if (this.configFile != null) {
                dbRoot = new File(this.configFile).getAbsoluteFile().getParent() + File.separator + dbRoot;
            } else {
                log.warn((Object)"The database configuration file is not specified and there was no xindice.db.home property set, so Xindice was unable to determine a database location. Database will be created relative to the current directory.");
                try {
                    dbRoot = new File("." + File.separator + dbRoot).getCanonicalPath();
                }
                catch (IOException e) {
                    log.warn((Object)"getCanonicalPath failed", (Throwable)e);
                    dbRoot = new File("." + File.separator + dbRoot).getAbsolutePath();
                }
            }
            try {
                config.setAttribute("dbroot", dbRoot);
            }
            catch (ReadOnlyException e) {
                // empty catch block
            }
        }
        return config;
    }

    private Configuration loadConfiguration() throws XMLDBException {
        Configuration config;
        if (this.configFile == null) {
            try {
                this.configFile = this.getProperty(PROP_XINDICE_CONFIGURATION);
            }
            catch (XMLDBException e) {
                // empty catch block
            }
            if (this.configFile == null) {
                this.configFile = System.getProperty(SYSPROP_XINDICE_CONFIGURATION);
            }
            if ("".equals(this.configFile)) {
                this.configFile = null;
            }
        }
        if (this.configFile != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Specified configuration file: '" + this.configFile + "'"));
            }
            try {
                FileInputStream configXMLFile = new FileInputStream(this.configFile);
                config = new Configuration(DOMParser.toDocument(configXMLFile), false);
            }
            catch (XindiceException e) {
                throw new XMLDBException(0, "Unable to parse database configuration file: " + this.configFile, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new XMLDBException(0, "Database configuration file not found: " + this.configFile);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"No configuration file specified, going with the default configuration");
        }
        try {
            config = new Configuration(DOMParser.toDocument("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"), false);
        }
        catch (XindiceException e) {
            throw new XindiceRuntimeException("Unable to parse default database configuration", e);
        }
        return config;
    }

    public boolean acceptsURI(String uri) throws XMLDBException {
        return uri != null && uri.startsWith(this.getName() + "://");
    }

    public Collection getCollection(String uri, String userName, String password) throws XMLDBException {
        Database database;
        if (!this.acceptsURI(uri)) {
            throw new XMLDBException(5, "Invalid URL: " + uri);
        }
        int firstSlash = (uri = uri.substring(this.getName().length() + 3)).indexOf(47);
        if (firstSlash == -1) {
            throw new XMLDBException(5, "Invalid URL (must have '/'): " + uri);
        }
        String collPath = uri.substring(firstSlash);
        if (!collPath.startsWith("/")) {
            throw new XMLDBException(5, "Invalid URL (collection name must start with '/'): " + uri);
        }
        int colIndex = collPath.indexOf(47, 1);
        String dbName = collPath.substring(1);
        if (colIndex != -1) {
            dbName = collPath.substring(1, colIndex);
        }
        if ((database = this.getDatabase(dbName, uri)) == null) {
            throw new XMLDBException(400, "Database '" + dbName + "' not found. URL: " + uri);
        }
        try {
            return new CollectionImpl(database, collPath);
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
    }

    public String getName() throws XMLDBException {
        return DRIVER_NAME;
    }

    public String[] getNames() throws XMLDBException {
        return new String[]{this.getName()};
    }

    public String getConformanceLevel() throws XMLDBException {
        return CONFORMANCE_LEVEL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

