#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Clarity') or BAIL_OUT('need Clarity to run') }

new_ok('Clarity') or BAIL_OUT('need a Clarity object to run');

package My::Clarity;

use Clarity -self;

BEGIN {
	field foo;
	field bar => {};
	field baz => [[], {}, \[], \{}, undef, \my $lol, qr{^}, \&Clarity::self, \*STDIN];
	field bbq => sub { ++our $i };
}

package main;

my $c = new My::Clarity;

eval { $c->foo };
like($@, qr/uninitialized/, "Using uninitalized foo should throw an error");
$c->foo(undef);
ok(eval { $c->foo; 1 }, "Using initialized foo should not throw an error");

is_deeply($c->bar, {}, "Simple initializer");
is_deeply($c->baz, [[], {}, \[], \{}, undef, \my $lol, qr{^}, \&Clarity::self, \*STDIN], "Complex initializer");

ok(!$c->bbq_isset, "_isset should be false at first");
is($c->bbq, 1, "Initializer should be called");
is($c->bbq, 1, "Initializer should be called only once");
$c->bbq_reset;
is($c->bbq, 2, "Initializer should be called seperately");
ok($c->bbq_isset, "_isset should be true after initialization");

done_testing();
