<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:didl="urn:mpeg:mpeg21:2002:02-DIDL-NS"
    xmlns:dii="urn:mpeg:mpeg21:2002:01-DII-NS"
    xmlns:dc="http://purl.org/dc/elements/1.1/" 
    xmlns:dcterms="http://purl.org/dc/terms/"
    xmlns:mods="http://www.loc.gov/mods/v3" 
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    >
    <xsl:output  method="text" />
    <xsl:param name="handle"/>
    
    <xsl:template match="/">
        <xsl:apply-templates select="didl:DIDL"/>
    </xsl:template>

    <xsl:template match="didl:DIDL">
        <xsl:apply-templates select="didl:Item/didl:Item"/>
        <xsl:text>
Handle: </xsl:text>
        <xsl:value-of select="$handle"/>
    </xsl:template>

    <xsl:template match="didl:Item/didl:Item">
        <xsl:choose>
            <xsl:when test="didl:Descriptor/didl:Statement/rdf:type[@rdf:resource='info:eu-repo/semantics/descriptiveMetadata']">
                 <xsl:apply-templates select="didl:Component/didl:Resource/mods:mods"/>
            </xsl:when>
            <xsl:when test="didl:Descriptor/didl:Statement/rdf:type='info:eu-repo/semantics/descriptiveMetadata'">
                 <xsl:apply-templates select="didl:Component/didl:Resource/mods:mods"/>
            </xsl:when>
            <xsl:when test="didl:Descriptor/didl:Statement/rdf:type='info:eu-repo/semantics/objectFile' or didl:Descriptor/didl:Statement/rdf:type[@rdf:resource='info:eu-repo/semantics/objectFile']">
                <xsl:for-each select="didl:Component/didl:Resource">
                    <xsl:text>
File-URL: </xsl:text>
                    <xsl:value-of select="@ref"/>
                    <xsl:text>
File-Format: </xsl:text>
                    <xsl:value-of select="@mimeType"/>
                </xsl:for-each>
                <!--xsl:for-each select="didl:Descriptor/didl:Statement/rdf:type">
                    <xsl:choose>
                        <xsl:when test=". = 'info:eo-repo/semantics/authorVersion'">
                            <xsl:text>
File-Version: authorVersion</xsl:text>
                        </xsl:when>
                        <xsl:when test=". = 'info:eo-repo/semantics/publishedVersion'">
                            <xsl:text>
File-Version: publishedVersion</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
                <xsl:for-each select="didl:Descriptor/didl:Resource/dcterms:accessRights">
                    <xsl:if test=". = 'info:eu-repo/semantics/closedAccess'">
                        <xsl:text>
Restriction: Closed Access</xsl:text>
                    </xsl:if>
                </xsl:for-each-->
            </xsl:when>
        </xsl:choose>
    </xsl:template>     
          
    <xsl:template match="didl:Component/didl:Resource/mods:mods">
        <xsl:text>Template-Type: ReDIF-Paper 1.0</xsl:text>
        <!--xsl:apply-templates select="mods:titleInfo"/-->
        <xsl:apply-templates select="mods:name"/>
        <xsl:apply-templates select="mods:language"/>
        <xsl:apply-templates select="mods:originInfo/mods:dateIssued"/>
        <xsl:apply-templates select="mods:relatedItem/mods:originInfo/mods:dateIssued"/>
        <xsl:apply-templates select="mods:abstract"/>
        <!--xsl:apply-templates select="mods:classification"/-->
        <xsl:apply-templates select="mods:subject"/>
        <xsl:apply-templates select="mods:genre"/>
        <xsl:apply-templates select="mods:physicalDescription"/>
        <xsl:if test="not(mods:name/mods:role/mods:roleTerm='aut')">
Author-Name: [no author]</xsl:if>
        <xsl:if test="mods:titleInfo">
            <xsl:text>
Title: </xsl:text>
            <xsl:for-each select="mods:titleInfo">
                <xsl:value-of select="mods:title"/>
                <xsl:for-each select="mods:subTitle">
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="."/>
                </xsl:for-each>
                <xsl:text>. </xsl:text>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="contains(mods:classification/@authority, 'jel')">
            <xsl:text>
Classification-JEL: </xsl:text>
            <xsl:for-each select="mods:classification">
                <xsl:value-of select="."/>
                <xsl:text>; </xsl:text>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="mods:genre">
        <xsl:choose>
            <xsl:when test=".='info:eu-repo/semantics/article'">
                <xsl:text>
X-PublishedAs-Type: article
X-PublishedAs-Journal: </xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:titleInfo/mods:title"/>
                <xsl:text>
X-PublishedAs-Year: </xsl:text>
                <xsl:value-of select="substring(../mods:originInfo/mods:dateIssued,1,4)"/>
                <xsl:text>
X-PublishedAs-Volume: </xsl:text>
                <xsl:value-of select='../mods:relatedItem/mods:part/mods:detail[@type="volume"]/mods:number'/>
                <xsl:text>
X-PublishedAs-Pages: </xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:part/mods:extent/mods:start"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:part/mods:extent/mods:end"/>
                <xsl:text>
Publication-Status: Published in </xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:titleInfo/mods:title"/>
                <xsl:text> (</xsl:text> 
                <xsl:value-of select="../mods:originInfo/mods:dateIssued"/>
                <xsl:text>) v.</xsl:text>
                <xsl:value-of select='../mods:relatedItem/mods:part/mods:detail[@type="volume"]/mods:number'/>
                <xsl:text>, p.</xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:part/mods:extent/mods:start"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:part/mods:extent/mods:end"/>
                <!--xsl:text>
Publication-Type: journal article</xsl:text-->                
            </xsl:when>
            <xsl:when test=".='info:eu-repo/semantics/book' or .='info:eu-repo/semantics/doctoralThesis'">
                <xsl:text>
X-PublishedAs-Type: book</xsl:text>
                <xsl:text>
X-PublishedAs-Provider-Name: </xsl:text>
                <xsl:value-of select="../mods:originInfo/mods:publisher"/>
                <xsl:for-each select="../mods:originInfo/mods:place">
                    <xsl:text>
X-PublishedAs-Provider-Location: </xsl:text>
                    <xsl:value-of select="mods:placeTerm"/>
                </xsl:for-each>
                <xsl:text>
X-PublishedAs-Year: </xsl:text>
                <xsl:value-of select="substring(../mods:originInfo/mods:dateIssued,1,4)"/>
                <xsl:for-each select="../mods:identifier">
                    <xsl:if test='starts-with(., "URN:ISBN:") or starts-with(., "urn:isbn:")'>
                        <xsl:text>
X-PublishedAs-ISBN: </xsl:text>
                        <xsl:value-of select="substring(., 10)"/>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>
Publication-Status: Published</xsl:text>
                <!--xsl:text>
Publication-Type: book</xsl:text-->                
                <xsl:if test=".='info:eu-repo/semantics/doctoralThesis'">
                    <xsl:text>
Note: Dissertation</xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:when test=".='info:eu-repo/semantics/bookPart'">
                <xsl:text>
X-PublishedAs-Type: chapter</xsl:text>
                <xsl:text>
X-PublishedAs-Book-Title: </xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:titleInfo/mods:title"/>
                <xsl:for-each select="../mods:relatedItem/mods:titleInfo/mods:subTitle">
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="."/>
                </xsl:for-each>
                <xsl:for-each select="../mods:relatedItem/mods:name">
                    <xsl:text>
X-PublishedAs-Editor-Name: </xsl:text>
                    <xsl:value-of select="mods:namePart[@type='family']/text()"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="mods:namePart[@type='given']/text()"/>
                    <xsl:if test="string-length(mods:affiliation) &gt; 0">
                        <xsl:text>
X-PublishedAs-Editor-Workplace-Name: </xsl:text>
                        <xsl:value-of select="mods:affiliation"/>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>
X-PublishedAs-Provider-Name: </xsl:text>
                <xsl:value-of select="../mods:relatedItem/mods:originInfo/mods:publisher"/>
                <xsl:for-each select="../mods:relatedItem/mods:originInfo/mods:place">
                    <xsl:text>
X-PublishedAs-Provider-Location: </xsl:text>
                    <xsl:value-of select="mods:placeTerm"/>
                </xsl:for-each>
                <xsl:text>
X-PublishedAs-Year: </xsl:text>
                <xsl:value-of select="substring(..//mods:originInfo/mods:dateIssued,1,4)"/>
                <xsl:for-each select="../mods:relatedItem/mods:identifier">
                    <xsl:if test='starts-with(., "URN:ISBN:") or starts-with(., "urn:isbn:")'>
                        <xsl:text>
X-PublishedAs-ISBN: </xsl:text>
                        <xsl:value-of select="substring(., 10)"/>
                    </xsl:if>
                </xsl:for-each>
                <!--xsl:text>
Publication-Type: book chapter</xsl:text-->                
            </xsl:when>
            <!--xsl:when test=".='info:eu-repo/semantics/workingPaper'">
                <xsl:text>
Publication-Type: working paper</xsl:text>                
            </xsl:when-->
            <!--xsl:otherwise>
                <xsl:text>
Publication-Type: other</xsl:text>                
            </xsl:otherwise-->
        </xsl:choose>  
    </xsl:template>
  
    <!--xsl:template match="mods:titleInfo">
        <xsl:text>
Title: </xsl:text>
        <xsl:value-of select="mods:title"/>
        <xsl:for-each select="mods:subTitle">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:template-->

    <xsl:template match="mods:name">
        <xsl:if test="mods:role/mods:roleTerm='aut' or mods:role/mods:roleTerm='edt'">
            <xsl:call-template name="name">
                <xsl:with-param name="name" select="."/>
                <xsl:with-param name="role">Author</xsl:with-param>
            </xsl:call-template>
            <xsl:if test="mods:role/mods:roleTerm='edt'">
                <xsl:call-template name="name">
                    <xsl:with-param name="name" select="."/>
                    <xsl:with-param name="role">X-PublishedAs-Editor</xsl:with-param>
                </xsl:call-template>
            </xsl:if>    
        </xsl:if>
    </xsl:template>

    <xsl:template name="name">
        <xsl:param name="name"/>
        <xsl:param name="role"/>
        <xsl:text>
</xsl:text><xsl:value-of select="$role"/><xsl:text>-Name: </xsl:text>
        <xsl:value-of select="$name/mods:namePart[@type='family']/text()"/>
        <xsl:text>, </xsl:text>
        <xsl:value-of select="$name/mods:namePart[@type='given']/text()"/>
        <xsl:text>
</xsl:text><xsl:value-of select="$role"/><xsl:text>-Name-Last: </xsl:text>
        <xsl:value-of select="$name/mods:namePart[@type='family']/text()"/>
        <xsl:text>
</xsl:text><xsl:value-of select="$role"/><xsl:text>-Name-First: </xsl:text>
        <xsl:value-of select="$name/mods:namePart[@type='given']/text()"/>
        <xsl:if test="string-length($name/mods:affiliation) &gt; 0">
            <xsl:text>
</xsl:text><xsl:value-of select="$role"/><xsl:text>-Workplace-Name: </xsl:text>
            <xsl:value-of select="$name/mods:affiliation"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="mods:language">
        <xsl:text>
Language: </xsl:text>
        <xsl:value-of select="mods:languageTerm"/>
    </xsl:template>

    <xsl:template match="mods:originInfo/mods:dateIssued | mods:relatedItem/mods:originInfo/mods:dateIssued">
        <xsl:text>
Creation-Date: </xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="mods:abstract" >
        <xsl:text>
Abstract: </xsl:text>
        <xsl:value-of select="."/>        
    </xsl:template>
    
    <!--xsl:template match="mods:classification">
        <xsl:text>
Classification-JEL: </xsl:text>
        <xsl:if test="contains(@authority, 'jel')">
            <xsl:value-of select="."/>
        </xsl:if>
    </xsl:template-->

    <xsl:template match="mods:subject">
        <xsl:text>
Keywords: </xsl:text>
        <xsl:for-each select="mods:topic">
            <xsl:value-of select="."/>
            <xsl:text>; </xsl:text>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="mods:physicalDescription">
        <xsl:for-each select="mods:extent">
            <xsl:text>
Length: </xsl:text>
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
