<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0"
	xmlns:foaf="http://xmlns.com/foaf/0.1/"
	xmlns:nereus="http://www.nereus4economics.info/"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	exclude-result-prefixes="foaf nereus rdf"
	>
    <xsl:output encoding="UTF-8" indent="yes" method="xml"/>

    <xsl:param name="domain"/>
    <xsl:param name="target_id"/>

    <xsl:variable name="partnerId"     select="/nereus:partner/@id"/>
    <xsl:variable name="status"        select="/nereus:partner/properties/entry[@key='neeo.partner.status']"/>
    <xsl:variable name="refresh-clear" select="/nereus:partner/properties/entry[@key='neeo.partner.refresh-clear']"/>

    <xsl:template match="/nereus:partner">
        <xsl:apply-templates select="rdf:RDF"/>
    </xsl:template>

    <xsl:template match="rdf:RDF">
		<xsl:apply-templates select="foaf:Organization"/>
	</xsl:template>

	<xsl:template match="foaf:Organization">
		<xsl:if test="rdf:type='info:eu-repo/semantics/institution'">
			<xsl:variable name="repositoryGroup">
			    <xsl:choose>
					<xsl:when test="$partnerId">
						<xsl:value-of select="$partnerId"/>
                    </xsl:when>
                    <!-- dit is nog een overblijfsel van een oude versie - kan weg -->
				    <xsl:otherwise>
				        <xsl:variable name="rg">
					        <xsl:variable name="r">
						<xsl:call-template name="replace">
							<xsl:with-param name="str1" select="@rdf:ID"/>
							<xsl:with-param name="str2">.</xsl:with-param>
							<xsl:with-param name="str3">-</xsl:with-param>
						</xsl:call-template>
					        </xsl:variable>
					        <xsl:call-template name="replace">
						        <xsl:with-param name="str1" select="$r"/>
						        <xsl:with-param name="str2">#</xsl:with-param>
						        <xsl:with-param name="str3">-</xsl:with-param>
					        </xsl:call-template>
				        </xsl:variable>
				        <xsl:call-template name="replace">
					        <xsl:with-param name="str1" select="$rg"/>
					        <xsl:with-param name="str2">/</xsl:with-param>
					        <xsl:with-param name="str3">-</xsl:with-param>
				        </xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<configfiles>
				<file>
                    <xsl:attribute name="name">
                        <xsl:value-of select="$domain"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="$repositoryGroup"/>
						<xsl:text>.repositoryGroup</xsl:text>
					</xsl:attribute>
					<repositoryGroup>
						<id><xsl:value-of select="$repositoryGroup"/></id>
						<name xml:lang="nl"><xsl:value-of select="foaf:name"/></name>
						<name xml:lang="en"><xsl:value-of select="foaf:name"/></name>
						<xsl:for-each select="nereus:repositories/rdf:Bag/rdf:li">
							<xsl:variable name="repository" select="@rdf:nodeID"/>
                            <xsl:for-each select="//rdf:RDF/rdf:Description[@rdf:nodeID=$repository]">
                                <xsl:if test="rdf:type='info:eu-repo/semantics/repository'">
	    							<xsl:variable name="n" select="count(nereus:neeo-sets/rdf:Bag/rdf:li)"/>
		    						<xsl:choose>
					    				<xsl:when test="$n&gt;0">
						    				<!-- there are sets -->
							    			<xsl:for-each select="nereus:neeo-sets/rdf:Bag/rdf:li">
								    			<repositoryId>
									    			<xsl:call-template name="repo-id">
										    			<xsl:with-param name="repository" select="$repository"/>
											    	</xsl:call-template>
												    <xsl:if test="$n&gt;1">
													    <!-- more than 1 set -->
													    <xsl:text>-set-</xsl:text>
													    <xsl:value-of select="."/>
												    </xsl:if>
	    										</repositoryId>
		    								</xsl:for-each>
			    						</xsl:when>
				    					<xsl:otherwise>
					    					<repositoryId>
						    					<xsl:call-template name="repo-id">
							    					<xsl:with-param name="repository" select="$repository"/>
								    			</xsl:call-template>
									    	</repositoryId>
	    								</xsl:otherwise>
                                    </xsl:choose>
                                </xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</repositoryGroup>
                </file>
                <xsl:variable name="use">
                    <xsl:choose>
                        <xsl:when test="$status = 'active'">
                            <xsl:text>true</xsl:text>
                        </xsl:when>
                        <xsl:otherwise/>
                    </xsl:choose>
                </xsl:variable>
                <xsl:variable name="action">
                    <xsl:choose>
                        <xsl:when test="$refresh-clear = 'true'">
                            <xsl:choose>
                                <xsl:when test="$use = 'true'">
                                    <xsl:text>refresh</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>clear</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise/>
                    </xsl:choose>
                </xsl:variable>
				<xsl:for-each select="nereus:repositories/rdf:Bag/rdf:li">
					<xsl:variable name="repository" select="@rdf:nodeID"/>
                    <xsl:for-each select="//rdf:RDF/rdf:Description[@rdf:nodeID=$repository]">
                        <xsl:if test="rdf:type='info:eu-repo/semantics/repository'">
    						<xsl:variable name="baseurl" select="normalize-space(nereus:oaiBaseURL)"/>
	    					<xsl:variable name="metadataPrefix" select="nereus:oaiMetadataPrefix"/>
		    				<xsl:variable name="n" select="count(nereus:neeo-sets/rdf:Bag/rdf:li)"/>
			    			<!-- FIXME repeating the same code as above; but not completely the same -->
				    		<xsl:choose>
					    		<xsl:when test="$n&gt;0">
						    		<!-- there are sets -->
							    	<xsl:for-each select="nereus:neeo-sets/rdf:Bag/rdf:li">
								    	<xsl:variable name="id">
									    	<xsl:call-template name="repo-id">
										    	<xsl:with-param name="repository" select="$repository"/>
				    						</xsl:call-template>
					    					<xsl:if test="$n&gt;1">
						    					<!-- more than 1 set -->
							    				<xsl:text>-set-</xsl:text>
								    			<xsl:value-of select="."/>
									    	</xsl:if>
    									</xsl:variable>
	    								<xsl:call-template name="repo-file">
		    								<xsl:with-param name="id" select="$id"/>
			    							<xsl:with-param name="repositoryGroup" select="$repositoryGroup"/>
				    						<xsl:with-param name="baseurl" select="$baseurl"/>
					    					<xsl:with-param name="set" select="."/>
                                            <xsl:with-param name="metadataPrefix" select="$metadataPrefix"/>
                                            <xsl:with-param name="use" select="$use"/>
                                            <xsl:with-param name="action" select="$action"/>
							    		</xsl:call-template>
								    </xsl:for-each>
    							</xsl:when>
	    						<xsl:otherwise>
		    						<xsl:variable name="id">
			    						<xsl:call-template name="repo-id">
				    						<xsl:with-param name="repository" select="$repository"/>
					    				</xsl:call-template>
						    		</xsl:variable>
							    	<xsl:call-template name="repo-file">
								    	<xsl:with-param name="id" select="$id"/>
									    <xsl:with-param name="repositoryGroup" select="$repositoryGroup"/>
    									<xsl:with-param name="baseurl" select="$baseurl"/>
	    								<xsl:with-param name="metadataPrefix" select="$metadataPrefix"/>
                                        <xsl:with-param name="use" select="$use"/>
                                        <xsl:with-param name="action" select="$action"/>
		    						</xsl:call-template>
			    				</xsl:otherwise>
                            </xsl:choose>
                        </xsl:if>    
					</xsl:for-each>
				</xsl:for-each>
			</configfiles>
		</xsl:if>
	</xsl:template>

	<xsl:template name="repo-id">
		<xsl:param name="repository"/>
		<xsl:variable name="repo-id">
			<xsl:choose>
				<xsl:when test="contains($repository,'://')">
					<xsl:value-of select="substring-after($repository, '://')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$repository"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="id">
			<xsl:choose>
				<xsl:when test="substring($repo-id, string-length($repo-id)) = '/'">
					<xsl:value-of select="substring($repo-id, 1, string-length($repo-id)-1)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$repo-id"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="replace">
			<xsl:with-param name="str1" select="$id"/>
			<xsl:with-param name="str2">.</xsl:with-param>
			<xsl:with-param name="str3">-</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

    <xsl:template name="replace">
        <xsl:param name="str1"/>
        <xsl:param name="str2"/>
        <xsl:param name="str3"/>
        <xsl:choose>
			<xsl:when test="contains($str1, $str2)">
				<xsl:value-of select="substring-before($str1, $str2)"/>
				<xsl:value-of select="$str3"/>
				<xsl:call-template name="replace">
					<xsl:with-param name="str1" select="substring-after($str1, $str2)"/>
					<xsl:with-param name="str2" select="$str2"/>
					<xsl:with-param name="str3" select="$str3"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$str1"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="repo-file">
		<xsl:param name="id"/>
		<xsl:param name="repositoryGroup"/>
		<xsl:param name="baseurl"/>
		<xsl:param name="set"/>
        <xsl:param name="metadataPrefix"/>
        <xsl:param name="use"/>
        <xsl:param name="action"/>
		<file>
            <xsl:attribute name="name">
                <xsl:value-of select="$domain"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="$id"/>
				<xsl:text>.repository</xsl:text>
			</xsl:attribute>
			<repository>
				<id><xsl:value-of select="$id"/></id>
				<repositoryGroupId><xsl:value-of select="$repositoryGroup"/></repositoryGroupId>
                <use><xsl:value-of    select="$use"   /></use>
                <action><xsl:value-of select="$action"/></action>
				<complete>true</complete>
				<baseurl><xsl:value-of select="$baseurl"/></baseurl>
				<xsl:if test="string-length($set)&gt;0">
					<set><xsl:value-of select="$set"/></set>
				</xsl:if>
                <collection><xsl:value-of select="$domain"/></collection>
                <targetId><xsl:value-of select="$target_id"/></targetId>
				<metadataPrefix>
					<xsl:choose>
						<xsl:when test="string-length($metadataPrefix)&gt;0">
							<xsl:value-of select="$metadataPrefix"/>
						</xsl:when>
						<xsl:otherwise><xsl:text>didl</xsl:text></xsl:otherwise>
					</xsl:choose>
				</metadataPrefix>
				<mappingId>default</mappingId>
			</repository>
		</file>
	</xsl:template>
</xsl:stylesheet>
