<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:meta="http://meresco.com/namespace/harvester/meta" 
    version="1.0">
    <xsl:param name="handle"/>
    <xsl:param name="today"/>
    <xsl:output encoding="UTF-8" indent="yes" method="xml"/>
    <!-- The Identity Transformation -->
    <!-- Whenever you match any node or any attribute -->
    <xsl:template match="node()|@*">
        <!-- Copy the current node -->
        <xsl:copy>
            <!-- Including any attributes it has and any child nodes -->
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
                                                                                                    
    <xsl:template match="meta:record">
        <xsl:element name="record" namespace="http://meresco.com/namespace/harvester/meta">
            <xsl:copy-of select="meta:id"/>
            <xsl:element name="repec" namespace="http://meresco.com/namespace/harvester/meta">
                <xsl:element name="handle" namespace="http://meresco.com/namespace/harvester/meta">
                    <xsl:value-of select="$handle"/>
                </xsl:element>
                <xsl:element name="date" namespace="http://meresco.com/namespace/harvester/meta">
                    <xsl:value-of select="$today"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
