/*****************************************************************************

	error.c - source code for the boushi command line tool

	Copyright (c) 2009-2010  Wessel Dankers <wsl@fruit.je>

	This file is part of boushi.

	boushi is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as
	published by the Free Software Foundation, either version 3 of
	the License, or (at your option) any later version.

	boushi is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU General Public License
	and a copy of the GNU Lesser General Public License along with
	boushi.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#include "config.h"
#include "error.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

bool okv(int err, ...) {
	va_list ap;
	char *s;

	if(!err)
		return true;

	va_start(ap, err);
	for(s = strdupa("boushi"); s; s = va_arg(ap, char *))
		fprintf(stderr, "%s: ", s);
	va_end(ap);
	fprintf(stderr, "%s\n", strerror(err));
	fflush(stderr);

	return false;
}
