/*
 * Copyright (c) Stichting SURF. All rights reserved.
 * 
 * A-Select is a trademark registered by SURFnet bv.
 * 
 * This program is distributed under the A-Select license.
 * See the included LICENSE file for details.
 * 
 * If you did not receive a copy of the LICENSE 
 * please contact SURFnet bv. (http://www.surfnet.nl)
 */
package org.aselect.server.elo;

/**
 * Contains the default properties from a registered ELO.
 * <br><br>
 * <b>Concurrency issues:</b> <br> - <br>
 * @author Alfa & Ariss
 */
public class ELO
{
    private String _sID = null;
    private String _sSharedSecret = null;
    private String _sURL = null;
    private int _iLevel = 0;
    private boolean _bShowTemplate;
    
    /**
     * Default constructor.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b>
     * <br> - sEloID != null<br>
     * <br> - sEloSharedSecret != null<br>
     * <br> - sEloURL != null<br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @param sEloID The ELO Identifier.
     * @param sEloSharedSecret The Shared secret that is known by the ELO.
     * @param sEloURL The URL the ELO is reachable at.
     * @param iLevel The AuthSP level the ELO is granted.
     * @param bShowTemplate TRUE to show template
     */
    public ELO (String sEloID, String sEloSharedSecret, String sEloURL, 
        int iLevel, boolean bShowTemplate)
    {
        super();
        _sID = sEloID;
        _sSharedSecret = sEloSharedSecret;
        _sURL = sEloURL;
        _iLevel = iLevel;
        _bShowTemplate = bShowTemplate;
    }

    /**
     * returns the ELO ID.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @return the ELO id.
     */
    public String getID()
    {
        return _sID;
    }
    
    /**
     * sets the ELO ID.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @param sEloID The ELO ID.
     */
    public void setID(String sEloID)
    {
        this._sID = sEloID;
    }
    
    /**
     * returns the shared secret associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @return the shared secret associated with the ELO.
     */
    public String getSharedSecret()
    {
        return _sSharedSecret;
    }
    
    /**
     * The shared secret associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @param sEloSharedSecret the shared secret associated with the ELO.
     */
    public void setSharedSecret(String sEloSharedSecret)
    {
        this._sSharedSecret = sEloSharedSecret;
    }
    
    /**
     * returns the URL associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @return The URL associated with the ELO.
     */
    public String getURL()
    {
        return _sURL;
    }
    
    /**
     * sets the URL associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @param sEloURL The URL associated with the ELO.
     */
    public void setURL(String sEloURL)
    {
        this._sURL = sEloURL;
    }

    /**
     * Returns the AuthSP level associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @return the level.
     */
    public int getLevel()
    {
        return _iLevel;
    }

    /**
     * Sets the AuthSP level associated with the ELO.
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @param iLevel The ELO level.
     */
    public void setLevel(int iLevel)
    {
        _iLevel = iLevel;
    }
    
    /**
     * Returns if a template should be shown after setting the SSO notification 
     * cookie.
     * <br><br>
     * <b>Description:</b>
     * <br>
     * <br><br>
     * <b>Concurrency issues:</b> <br> - <br>
     * <br>
     * <b>Preconditions:</b> <br> - <br>
     * <br>
     * <b>Postconditions:</b> <br> - <br>
     * @return TRUE if template should be showed
     */
    public boolean showTemplate()
    {
        return _bShowTemplate;
    }
}
