/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.session;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.authspserver.sam.AuthSPSAMAgent;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.StorageManager;

public class AuthSPSessionManager
extends StorageManager {
    public static final String MODULE = "AuthSPSessionManager";
    private static AuthSPSessionManager _oAuthSPSessionManager;
    private AuthSPSystemLogger _systemLogger;
    private AuthSPConfigManager _configManager;

    public static AuthSPSessionManager getHandle() {
        if (_oAuthSPSessionManager == null) {
            _oAuthSPSessionManager = new AuthSPSessionManager();
        }
        return _oAuthSPSessionManager;
    }

    public void init() throws ASelectException {
        String string = "init()";
        try {
            this._systemLogger = AuthSPSystemLogger.getHandle();
            this._configManager = AuthSPConfigManager.getHandle();
            Object object = null;
            try {
                object = this._configManager.getSection(null, "storagemanager", "id=session");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'storagemanager' section with id='session' found in configuration", aSelectException);
                throw aSelectException;
            }
            super.init(object, (ConfigManager)this._configManager, (SystemLogger)this._systemLogger, (SAMAgent)AuthSPSAMAgent.getHandle());
            this._systemLogger.log(Level.INFO, MODULE, string, "Session manager Successfully started.");
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void createSession(String string, Hashtable hashtable) throws ASelectException {
        String string2 = "createSession()";
        try {
            if (this.containsKey(string)) {
                StringBuffer stringBuffer = new StringBuffer("Session already exists: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectException("0001");
            }
            this.put(string, hashtable);
        }
        catch (ASelectStorageException aSelectStorageException) {
            if (aSelectStorageException.getMessage().equals("6010")) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Maximum number of sessions reached", aSelectStorageException);
                throw new ASelectException("0050", (Throwable)aSelectStorageException);
            }
            throw aSelectStorageException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not create session with rid: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void updateSession(String string, Hashtable hashtable) throws ASelectException {
        String string2 = "updateSession()";
        try {
            if (!this.containsKey(string)) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No sessions found with id: " + string);
                throw new ASelectException("0050");
            }
            Hashtable hashtable2 = (Hashtable)this.get(string);
            hashtable2.putAll(hashtable);
            this.update(string, hashtable2);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not update session with rid: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Hashtable getSessionContext(String string) throws ASelectException {
        String string2 = "getSessionContext()";
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)this.get(string);
        }
        catch (ASelectStorageException aSelectStorageException) {
            StringBuffer stringBuffer = new StringBuffer("Could not resolve session with rid: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), aSelectStorageException);
            throw new ASelectException("0001", (Throwable)aSelectStorageException);
        }
        return hashtable;
    }

    private AuthSPSessionManager() {
    }
}

