/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.sam;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.aselect.authspserver.config.Version;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.service.SAMServiceServlet;

public class SAMService
extends SAMServiceServlet {
    public static final String MODULE = "SAMService";
    private AuthSPSystemLogger _systemLogger;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._systemLogger = AuthSPSystemLogger.getHandle();
        super.init(servletConfig);
        this._systemLogger.log(Level.INFO, MODULE, "init()", "Successfully started SAM Service.");
    }

    public void destroy() {
        super.destroy();
    }

    protected Hashtable getSAMInfo() {
        Hashtable hashtable = this.getCommonSAMInfo();
        return hashtable;
    }

    protected SystemLogger getSystemLogger() {
        return this._systemLogger;
    }

    protected int operational() {
        int n = 0;
        ServletContext servletContext = this.getServletContext().getContext(super.getContextUrl() + "/server");
        if (servletContext != null) {
            Object object = servletContext.getAttribute("CryptoEngine");
            Object object2 = servletContext.getAttribute("working_dir");
            Object object3 = servletContext.getAttribute("friendly_name");
            if (object != null && object2 != null && object3 != null) {
                n = 1;
            } else {
                this.getSystemLogger().log(Level.WARNING, MODULE, "operational()", "Can't find AuthSP Server attributes in servlet context.");
            }
        }
        return n;
    }

    protected String getSysDescr() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("A-Select AuthSP Server v");
        stringBuffer.append(Version.getVersion());
        String string2 = Version.getSP();
        if (!string2.equals("")) {
            stringBuffer.append(" ,SP ");
            stringBuffer.append(string2);
        }
        if (!(string = Version.getPatch()).equals("")) {
            stringBuffer.append(" ,Patch ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String getVersion() {
        return Version.getVersion();
    }
}

