/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.config.Version;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.authspserver.sam.AuthSPSAMAgent;
import org.aselect.authspserver.session.AuthSPSessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.servlet.ASelectHttpServlet;

public class AuthSPServlet
extends ASelectHttpServlet {
    private static final String MODULE = "AuthSPServlet";
    private static final String CONFIG_ID = "authspserver";
    private boolean _bRestartable = false;
    private String _sMySharedSecret = null;
    private AuthSPSystemLogger _systemLogger = null;
    private AuthSPAuthenticationLogger _authenticationLogger = null;
    private AuthSPSessionManager _oAuthSPSessionManager = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        Object object = null;
        String string2 = null;
        try {
            Object object2;
            Comparable<File> comparable;
            Object object3;
            File file;
            super.init(servletConfig);
            if (this._systemLogger != null) {
                this._systemLogger.closeHandlers();
            } else {
                this._systemLogger = AuthSPSystemLogger.getHandle();
            }
            if (this._authenticationLogger != null) {
                this._authenticationLogger.closeHandlers();
            } else {
                this._authenticationLogger = AuthSPAuthenticationLogger.getHandle();
            }
            ServletContext servletContext = servletConfig.getServletContext();
            string2 = servletConfig.getInitParameter("working_dir");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'working_dir' parameter from deployment descriptor.");
                throw new ASelectConfigException("4009");
            }
            String string3 = servletConfig.getInitParameter("sql_driver");
            String string4 = servletConfig.getInitParameter("sql_url");
            String string5 = servletConfig.getInitParameter("sql_user");
            String string6 = servletConfig.getInitParameter("sql_password");
            String string7 = servletConfig.getInitParameter("sql_table");
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!(file = new File(string2 = string2 + CONFIG_ID)).exists()) {
                StringBuffer stringBuffer = new StringBuffer("Could not access the working_dir as configured in web.xml: ");
                stringBuffer.append(string2);
                this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                throw new ASelectException("4009");
            }
            AuthSPConfigManager authSPConfigManager = AuthSPConfigManager.getHandle();
            if (string3 != null || string6 != null || string4 != null || string7 != null) {
                object3 = new StringBuffer("Reading config from database: ");
                ((StringBuffer)object3).append(string4);
                this._systemLogger.log(Level.CONFIG, MODULE, string, ((StringBuffer)object3).toString());
                authSPConfigManager.init(string3, string5, string6, string4, string7, CONFIG_ID, this._systemLogger);
            } else {
                object3 = new StringBuffer(string2);
                ((StringBuffer)object3).append(File.separator);
                ((StringBuffer)object3).append("conf");
                ((StringBuffer)object3).append(File.separator);
                ((StringBuffer)object3).append("authsp.xml");
                comparable = new File(((StringBuffer)object3).toString());
                if (!((File)comparable).exists()) {
                    StringBuffer stringBuffer = new StringBuffer("Could not access the config file: ");
                    stringBuffer.append((StringBuffer)object3);
                    this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                object2 = new StringBuffer("Reading config from file: ");
                ((StringBuffer)object2).append((StringBuffer)object3);
                this._systemLogger.log(Level.CONFIG, MODULE, string, ((StringBuffer)object2).toString());
                authSPConfigManager.init(((StringBuffer)object3).toString(), this._systemLogger);
            }
            try {
                object = authSPConfigManager.getSection(null, CONFIG_ID);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'authspserver' found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            object3 = null;
            try {
                object3 = authSPConfigManager.getSection(object, "logging", "id=system");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'logging' config section with id='system' found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._systemLogger.init(object3, string2);
            comparable = new StringBuffer("Starting A-Select AuthSP Server ");
            ((StringBuffer)comparable).append(Version.getVersion());
            this._systemLogger.log(Level.INFO, MODULE, string, ((StringBuffer)comparable).toString());
            object2 = null;
            try {
                object2 = authSPConfigManager.getSection(object, "logging", "id=authentication");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'logging' config section with id='authentication' found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._authenticationLogger.init(object2, string2);
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully initialized AuthSPAuthenticationLogger.");
            try {
                this._sMySharedSecret = authSPConfigManager.getParam(object, "shared_secret");
                boolean bl = this._bRestartable = this._sMySharedSecret != null;
                if (!this._bRestartable) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'shared_secret' is empty");
                    throw new ASelectException("4009");
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'shared_secret' configured, disabling servlet restart.");
                this._bRestartable = false;
            }
            if (servletContext.getAttribute("CryptoEngine") != null) {
                servletContext.removeAttribute("CryptoEngine");
            }
            if (servletContext.getAttribute("friendly_name") != null) {
                servletContext.removeAttribute("friendly_name");
            }
            if (servletContext.getAttribute("SessionManager") != null) {
                servletContext.removeAttribute("SessionManager");
            }
            String string8 = null;
            try {
                string8 = authSPConfigManager.getParam(object, "organization_friendly_name");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'organization_friendly_name' config parameter in authspserver config section", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            string8 = string8.trim();
            CryptoEngine cryptoEngine = new CryptoEngine(string2, this._systemLogger);
            this._systemLogger.log(Level.INFO, MODULE, string, "CryptoEngine successfully initialized.");
            servletContext.setAttribute("CryptoEngine", (Object)cryptoEngine);
            this._systemLogger.log(Level.INFO, MODULE, string, "The CryptoEngine is set to the servlet context.");
            servletContext.setAttribute("working_dir", (Object)string2);
            this._systemLogger.log(Level.INFO, MODULE, string, "The working_dir is set to the servlet context.");
            servletContext.setAttribute("friendly_name", (Object)string8);
            this._systemLogger.log(Level.INFO, MODULE, string, "The friendly_name is set to the servlet context.");
            AuthSPSAMAgent.getHandle().init();
            this._oAuthSPSessionManager = AuthSPSessionManager.getHandle();
            this._oAuthSPSessionManager.init();
            servletContext.setAttribute("SessionManager", (Object)this._oAuthSPSessionManager);
            this._systemLogger.log(Level.INFO, MODULE, string, "The SessionManager is set to the servlet context.");
            this._systemLogger.log(Level.INFO, MODULE, string, "A-Select AuthSP Server is successfully initialized");
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Initializing failed", aSelectException);
            this.closeResources();
            this.closeLoggers();
            throw new ServletException("Initializing failed");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Initializing failed", exception);
            this.closeResources();
            this.closeLoggers();
            throw new ServletException("Initializing failed");
        }
    }

    public String getServletInfo() {
        return "AuthSPServlet - loads AuthSP engine";
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (this._bRestartable) {
            super.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
            String string = httpServletRequest.getParameter("request");
            if (string != null) {
                PrintWriter printWriter = null;
                try {
                    printWriter = httpServletResponse.getWriter();
                    if (string.equals("restart")) {
                        this.handleRestartRequest(httpServletRequest, this._sMySharedSecret, printWriter, this._systemLogger);
                    }
                }
                catch (IOException iOException) {
                    throw new ServletException("Error sending response: " + iOException.getMessage());
                }
                finally {
                    if (printWriter == null) {
                        printWriter.close();
                    }
                }
            }
        }
    }

    public void destroy() {
        this.closeResources();
        this._systemLogger.log(Level.INFO, MODULE, "destroy()", "A-Select AuthSP Server stopped.");
        this.closeLoggers();
        super.destroy();
    }

    private void closeResources() {
        AuthSPSAMAgent.getHandle().destroy();
        if (this._oAuthSPSessionManager != null) {
            this._oAuthSPSessionManager.destroy();
            this._oAuthSPSessionManager = null;
        }
    }

    private void closeLoggers() {
        if (this._authenticationLogger != null) {
            this._authenticationLogger.closeHandlers();
            this._authenticationLogger = null;
        }
        if (this._systemLogger != null) {
            this._systemLogger.closeHandlers();
            this._systemLogger = null;
        }
    }

    protected boolean isRestartableServlet() {
        return false;
    }

    protected synchronized boolean restartServlets(SystemLogger systemLogger) {
        String string = "restartServlets()";
        boolean bl = true;
        try {
            StringBuffer stringBuffer = new StringBuffer("Restart: ");
            ServletConfig servletConfig = this.getServletConfig();
            servletConfig.getServletContext().setAttribute("restarting_servlets", (Object)"true");
            Hashtable hashtable = (Hashtable)servletConfig.getServletContext().getAttribute("restartable_servlets");
            try {
                this.init(servletConfig);
            }
            catch (Exception exception) {
                bl = false;
            }
            stringBuffer.append(MODULE).append(" (");
            stringBuffer.append(bl ? "OK" : "Failed");
            stringBuffer.append(")");
            if (bl && hashtable != null) {
                stringBuffer.append(", ");
                boolean bl2 = true;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ASelectHttpServlet aSelectHttpServlet = (ASelectHttpServlet)hashtable.get(string2);
                    try {
                        aSelectHttpServlet.init(aSelectHttpServlet.getServletConfig());
                    }
                    catch (Exception exception) {
                        bl2 = false;
                    }
                    bl &= bl2;
                    stringBuffer.append(string2).append(" (");
                    stringBuffer.append(bl2 ? "OK" : "Failed");
                    stringBuffer.append(")");
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(", ");
                }
            }
            systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
        }
        catch (Exception exception) {
            if (systemLogger != null) {
                systemLogger.log(Level.SEVERE, this.getModuleName(), string, "Restarting servlets failed", (Throwable)exception);
            } else {
                System.err.println(this.getModuleName() + " " + string + exception.getMessage());
            }
            bl = false;
        }
        this.getServletConfig().getServletContext().removeAttribute("restarting_servlets");
        return bl;
    }
}

