/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.processor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.log.ASelectSystemLogger;

public class NMVPair {
    private static final String MODULE = "NMVPair";
    private ASelectSystemLogger _systemLogger = ASelectSystemLogger.getHandle();
    private String _sName;
    private List _listValues;

    public NMVPair(String string) {
        this._sName = string;
        this._listValues = new LinkedList();
    }

    public NMVPair(String string, String string2) {
        this._sName = string;
        this._listValues = new LinkedList();
        this._listValues.add(string2);
    }

    public NMVPair(String string, Vector vector) {
        this._sName = string;
        this._listValues = new LinkedList();
        this._listValues.addAll(vector);
    }

    public void updateMixedHashtable(Hashtable hashtable) {
        if (this._listValues.size() > 1) {
            hashtable.put(this._sName, new Vector(this._listValues));
        } else {
            hashtable.put(this._sName, this._listValues.get(0));
        }
    }

    public void addValue(String string) {
        this._listValues.add(string);
    }

    public void addValues(Vector vector) {
        this._listValues.addAll(vector);
    }

    public String encodeMV() {
        String string = "encodeMV()";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        try {
            string2 = URLEncoder.encode(this._sName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.FINE, MODULE, string, "Could not url encode with UTF-8", (Throwable)unsupportedEncodingException);
            return stringBuffer.toString();
        }
        Iterator iterator = this._listValues.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            try {
                String string4 = URLEncoder.encode(string3, "UTF-8");
                stringBuffer.append(string2);
                stringBuffer.append('=');
                stringBuffer.append(string4);
                if (!iterator.hasNext()) continue;
                stringBuffer.append('&');
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not url encode with UTF-8", (Throwable)unsupportedEncodingException);
            }
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this._sName;
    }

    public List getValues() {
        return this._listValues;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("N: ");
        stringBuffer.append(this._sName);
        stringBuffer.append(" V: ");
        stringBuffer.append(this._listValues);
        return stringBuffer.toString();
    }
}

