/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.elo;

import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.elo.IELOStorage;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;

public class ELOFactory {
    private static final String MODULE = "EloFactory";
    private static ELOFactory _oInstance = null;
    private SystemLogger _oLogger = null;
    private IELOStorage _oStorage = null;

    public static ELOFactory getHandle() throws ASelectException {
        if (_oInstance == null) {
            _oInstance = new ELOFactory();
        }
        return _oInstance;
    }

    public IELOStorage getEloStore() {
        return this._oStorage;
    }

    private ELOFactory() throws ASelectException {
        String string = "ELOFactory()";
        ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
        this._oLogger = ASelectSystemLogger.getHandle();
        Object object = null;
        try {
            object = aSelectConfigManager.getSection(null, "elostore");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oLogger.log(Level.WARNING, MODULE, string, "No config section 'elostore' found");
            throw new ASelectException("4009");
        }
        String string2 = null;
        try {
            string2 = aSelectConfigManager.getParam(object, "class");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oLogger.log(Level.WARNING, MODULE, string, "No config item 'class' in section 'elostore' found");
            throw new ASelectException("4009");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
            this._oStorage = (IELOStorage)clazz.newInstance();
            this._oStorage.init(object, (ConfigManager)aSelectConfigManager, this._oLogger);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._oLogger.log(Level.WARNING, MODULE, string, "'IEloStore' class not found: " + string2, (Throwable)classNotFoundException);
            throw new ASelectException("4009", (Throwable)classNotFoundException);
        }
        catch (ASelectException aSelectException) {
            this._oLogger.log(Level.WARNING, MODULE, string, "Could not initialize 'IEloStore' class: " + string2, (Throwable)aSelectException);
            throw new ASelectException("4009", (Throwable)aSelectException);
        }
        catch (ClassCastException classCastException) {
            this._oLogger.log(Level.WARNING, MODULE, string, "Not a correct 'IEloStore' class (wrong type): " + string2, (Throwable)classCastException);
            throw new ASelectException("4009", (Throwable)classCastException);
        }
        catch (Exception exception) {
            this._oLogger.log(Level.WARNING, MODULE, string, "'IEloStore' class could not be loaded: " + string2, (Throwable)exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }
}

