/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross.selectorhandler;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.elo.ELO;
import org.aselect.server.elo.ELOFactory;
import org.aselect.server.elo.IELOStorage;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.sam.agent.SAMResource;

public class RedirectSelectorHandler
implements ISelectorHandler {
    private static final String MODULE = "RedirectSelectorHandler";
    private static final String COOKIE_NOTIFICATION = "elo";
    private static final String SESSION_ELO_ID = "elo_id";
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;
    private SessionManager _sessionManager;
    private ASelectSAMAgent _samAgent;
    private IELOStorage _eloStorage;
    private SAMResource _samActiveResource;
    private String _sTargetResourceGroup;
    private String _sTargetUrl;
    private Hashtable _htRemoteServers;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._sessionManager = SessionManager.getHandle();
            this._samAgent = ASelectSAMAgent.getHandle();
            this._eloStorage = ELOFactory.getHandle().getEloStore();
            CrossASelectManager crossASelectManager = CrossASelectManager.getHandle();
            this._htRemoteServers = crossASelectManager.getRemoteServers();
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(object, "target");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'target' section found in configuration");
                throw new ASelectException("4009");
            }
            try {
                this._sTargetResourceGroup = this._configManager.getParam(object2, "resourcegroup");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'resourcegroup' item found in 'target' section in configuration");
                throw new ASelectException("4009");
            }
            this.getTargetUrl();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize the default selector handler", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Hashtable getRemoteServerId(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "getRemoteServerId()";
        Hashtable hashtable2 = null;
        try {
            String string2 = (String)hashtable.get("remote_idp");
            if (string2 != null) {
                hashtable2 = this.resolveIDP(httpServletResponse, hashtable, string2);
            } else {
                ELO eLO = this.getELOFromCookie(hashtable);
                if (eLO != null) {
                    String string3 = (String)hashtable.get("rid");
                    if (string3 == null) {
                        this._systemLogger.log(Level.FINE, MODULE, string, "No required 'rid' parameter in request");
                        throw new ASelectException("0030");
                    }
                    Hashtable hashtable3 = this._sessionManager.getSessionContext(string3);
                    if (hashtable3 == null) {
                        this._systemLogger.log(Level.FINE, MODULE, string, "Session expired or no session found with rid: " + string3);
                        throw new ASelectException("0102");
                    }
                    hashtable3.put(SESSION_ELO_ID, eLO.getID());
                    this._sessionManager.updateSession(string3, hashtable3);
                    this.redirectToELO(httpServletResponse, string3, eLO);
                } else {
                    this.redirectToWAYF(httpServletResponse, hashtable);
                }
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not resolve remote server", (Throwable)exception);
            throw new ASelectException("0030");
        }
        return hashtable2;
    }

    private ELO getELOFromCookie(Hashtable hashtable) throws ASelectException {
        String string = "getELOFromCookie()";
        ELO eLO = null;
        String string2 = this.getNotificationCookie(hashtable);
        if (string2 != null) {
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Cookie value is not a URL: " + string2);
                throw new ASelectException("4011");
            }
            eLO = this._eloStorage.getEloByURL(string2);
            if (eLO == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Cookie value contains a non existing ELO URL: " + string2);
            }
        }
        return eLO;
    }

    private void redirectToWAYF(HttpServletResponse httpServletResponse, Hashtable hashtable) throws ASelectException {
        String string = "redirectToWAYF()";
        StringBuffer stringBuffer = null;
        try {
            String string2 = (String)hashtable.get("rid");
            if (string2 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "No required 'rid' parameter in request");
                throw new ASelectException("0030");
            }
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string2);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Session expired or no session found with rid: " + string2);
                throw new ASelectException("0102");
            }
            String string3 = (String)hashtable2.get("app_id");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'app_id' found in session with rid: " + string2);
                throw new ASelectException("0070");
            }
            String string4 = this.getTargetUrl();
            stringBuffer = new StringBuffer(string4);
            if (string4.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("rid=").append(string2);
            stringBuffer.append("&requestor=").append(string3);
            this._systemLogger.log(Level.FINER, MODULE, string, "Performing redirect: " + stringBuffer.toString());
            try {
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not send redirect: " + stringBuffer.toString(), (Throwable)iOException);
                throw new ASelectException("0030");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not resolve remote server id", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private void redirectToELO(HttpServletResponse httpServletResponse, String string, ELO eLO) throws ASelectException {
        String string2 = "redirectToELO()";
        StringBuffer stringBuffer = null;
        try {
            String string3 = eLO.getURL();
            stringBuffer = new StringBuffer(string3);
            if (string3.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("rid=").append(string);
            this._systemLogger.log(Level.FINER, MODULE, string2, "Performing redirect: " + stringBuffer.toString());
            try {
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not send redirect: " + stringBuffer.toString(), (Throwable)iOException);
                throw new ASelectException("0030");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not resolve remote server id", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private Hashtable resolveIDP(HttpServletResponse httpServletResponse, Hashtable hashtable, String string) throws ASelectException {
        String string2 = "resolveIDP()";
        Hashtable<String, String> hashtable2 = null;
        try {
            if (string.equalsIgnoreCase("")) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Empty 'remote_idp' in response");
                throw new ASelectException("0030");
            }
            if (this._htRemoteServers.containsKey(string)) {
                hashtable2 = new Hashtable<String, String>();
                hashtable2.put("organization_id", string);
            } else {
                ELO eLO = this._eloStorage.getEloByID(string);
                if (eLO == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "Value 'remote_idp' in response is not an ELO id: " + string);
                    throw new ASelectException("0030");
                }
                String string3 = (String)hashtable.get("rid");
                if (string3 == null) {
                    this._systemLogger.log(Level.FINE, MODULE, string2, "No required 'rid' parameter in request");
                    throw new ASelectException("0030");
                }
                Hashtable hashtable3 = this._sessionManager.getSessionContext(string3);
                if (hashtable3 == null) {
                    this._systemLogger.log(Level.FINE, MODULE, string2, "Session expired or no session found with rid: " + string3);
                    throw new ASelectException("0102");
                }
                hashtable3.put(SESSION_ELO_ID, eLO.getID());
                this._sessionManager.updateSession(string3, hashtable3);
                this.redirectToELO(httpServletResponse, string3, eLO);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not resolve remote server id", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return hashtable2;
    }

    private String getNotificationCookie(Hashtable hashtable) {
        String string = "getNotificationCookie()";
        String string2 = null;
        Cookie[] cookieArray = (Cookie[])hashtable.get("aselect_cookies");
        if (cookieArray == null) {
            this._systemLogger.log(Level.FINER, MODULE, string, "No cookies found in request");
        } else {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (!COOKIE_NOTIFICATION.equalsIgnoreCase(cookie.getName())) continue;
                string2 = cookie.getValue();
                break;
            }
        }
        return string2;
    }

    private String getTargetUrl() throws ASelectException {
        block7: {
            String string = "getTargetUrl()";
            try {
                if (this._sTargetUrl != null && this._samActiveResource != null && this._samActiveResource.live()) break block7;
                this._samActiveResource = this._samAgent.getActiveResource(this._sTargetResourceGroup);
                Object object = this._samActiveResource.getAttributes();
                try {
                    this._sTargetUrl = this._configManager.getParam(object, "url");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No 'url' configuration item found in resourcegroup with id: " + this._sTargetResourceGroup);
                    throw new ASelectException("4011");
                }
                try {
                    new URL(this._sTargetUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Configured 'url' item in resourcegroup is not a valid URL: " + this._sTargetUrl, (Throwable)malformedURLException);
                    throw new ASelectException("4011");
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not retrieve target url from resourcegroup: " + this._sTargetResourceGroup, (Throwable)exception);
                throw new ASelectException("0001");
            }
        }
        return this._sTargetUrl;
    }
}

