/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.storagemanager;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.IStorageHandler;

public class StorageManager {
    public static final String MODULE = "StorageManager";
    private long _iMax;
    private IStorageHandler _oStorageHandler;
    private Cleaner _oCleaner;
    private long _lExpireTime = 0L;

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger, SAMAgent sAMAgent) throws ASelectStorageException {
        Object object2;
        String string;
        Class<?> clazz;
        Object object3;
        String string2 = "init()";
        try {
            object3 = configManager.getSection(object, "handler");
        }
        catch (ASelectConfigException aSelectConfigException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "'<handler />' is missing in the configuration file. value was null");
            throw new ASelectStorageException("6001", aSelectConfigException);
        }
        String string3 = null;
        try {
            string3 = configManager.getParam(object, "max");
        }
        catch (ASelectConfigException aSelectConfigException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "No valid 'max' config item found in storagemanager config section", aSelectConfigException);
            throw new ASelectStorageException("6001", aSelectConfigException);
        }
        try {
            this._iMax = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            systemLogger.log(Level.WARNING, MODULE, string2, "'max' config item in storagemanager config section is not a long: " + string3, exception);
            throw new ASelectStorageException("6001", exception);
        }
        try {
            clazz = Class.forName(configManager.getParam(object3, "class"));
        }
        catch (ASelectConfigException aSelectConfigException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "'class' is missing in the configuration file", aSelectConfigException);
            throw new ASelectStorageException("6001", aSelectConfigException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "Could not load the IStorageHandler, class not found", classNotFoundException);
            throw new ASelectStorageException("6001", classNotFoundException);
        }
        try {
            string = configManager.getParam(object3, "id");
        }
        catch (ASelectConfigException aSelectConfigException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "'id' is missing in the configuration file", aSelectConfigException);
            throw new ASelectStorageException("6001", aSelectConfigException);
        }
        try {
            object2 = configManager.getSection(object, "storagehandler", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            systemLogger.log(Level.WARNING, MODULE, string2, "<storagehandler> </storagehandler> is missing in the configuration file", aSelectConfigException);
            throw new ASelectStorageException("6001", aSelectConfigException);
        }
        try {
            String string4 = configManager.getParam(object, "expire");
            this._lExpireTime = Long.parseLong(string4.trim()) * 1000L;
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._lExpireTime = -1L;
            systemLogger.log(Level.CONFIG, MODULE, string2, "'expire' config item not specified. Cleaning disabled.");
        }
        long l = 0L;
        if (this._lExpireTime != -1L) {
            try {
                String string5 = configManager.getParam(object, "interval");
                l = Long.parseLong(string5.trim()) * 1000L;
            }
            catch (ASelectConfigException aSelectConfigException) {
                l = 60000L;
                systemLogger.log(Level.CONFIG, MODULE, string2, "'interval' config item not specified. Using default (1 minute)");
            }
        }
        try {
            this.destroy();
            this._oStorageHandler = (IStorageHandler)clazz.newInstance();
            this._oStorageHandler.init(object2, configManager, systemLogger, sAMAgent);
            this._oCleaner = new Cleaner();
            this._oCleaner.init(this._lExpireTime, l, systemLogger);
            this._oCleaner.interrupt();
            this._oCleaner.start();
        }
        catch (Exception exception) {
            systemLogger.log(Level.WARNING, MODULE, string2, "Could not initialize the StorageManager", exception);
            throw new ASelectStorageException("6001", exception);
        }
    }

    public Object get(Object object) throws ASelectStorageException {
        return this._oStorageHandler.get(object);
    }

    public long getExpirationTime(Object object) throws ASelectStorageException {
        long l = this._oStorageHandler.getTimestamp(object);
        return l + this._lExpireTime;
    }

    public long getTimestamp(Object object) throws ASelectStorageException {
        long l = this._oStorageHandler.getTimestamp(object);
        return l;
    }

    public Hashtable getAll() throws ASelectStorageException {
        return this._oStorageHandler.getAll();
    }

    public long getCount() throws ASelectStorageException {
        return this._oStorageHandler.getCount();
    }

    public void put(Object object, Object object2) throws ASelectStorageException {
        if (this._oStorageHandler.isMaximum(this._iMax)) {
            throw new ASelectStorageException("6010");
        }
        Long l = new Long(System.currentTimeMillis());
        this._oStorageHandler.put(object, object2, l);
    }

    public void update(Object object, Object object2) throws ASelectStorageException {
        Long l = new Long(System.currentTimeMillis());
        this._oStorageHandler.put(object, object2, l);
    }

    public boolean containsKey(Object object) throws ASelectStorageException {
        return this._oStorageHandler.containsKey(object);
    }

    public void remove(Object object) throws ASelectStorageException {
        this._oStorageHandler.remove(object);
    }

    public void removeAll() throws ASelectStorageException {
        this._oStorageHandler.removeAll();
    }

    public void destroy() {
        if (this._oStorageHandler != null) {
            this._oStorageHandler.destroy();
            this._oStorageHandler = null;
        }
        if (this._oCleaner != null) {
            this._oCleaner.destroy();
            this._oCleaner = null;
        }
    }

    private class Cleaner
    extends Thread {
        private long _lInterval = 0L;
        private long _lExpireTime = 0L;
        private boolean _bGo = false;
        private SystemLogger _systemLogger;

        public void init(long l, long l2, SystemLogger systemLogger) {
            this._lExpireTime = l;
            this._lInterval = l2;
            this._systemLogger = systemLogger;
            if (this._lExpireTime > 0L) {
                this._bGo = true;
            }
        }

        public void run() {
            String string = "run()";
            while (this._bGo) {
                try {
                    Cleaner.sleep(this._lInterval);
                    long l = System.currentTimeMillis();
                    Long l2 = new Long(l - this._lExpireTime);
                    StorageManager.this._oStorageHandler.cleanup(l2);
                }
                catch (ASelectStorageException aSelectStorageException) {
                    this._systemLogger.log(Level.INFO, StorageManager.MODULE, string, "The storage cleanup failed.", aSelectStorageException);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.INFO, StorageManager.MODULE, string, "The cleaner could not do her work properly.", exception);
                }
            }
            this._systemLogger.log(Level.FINE, StorageManager.MODULE, string, "The cleaner has stopped.");
        }

        public void destroy() {
            this._bGo = false;
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

