/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.agent.polling;

import java.net.URI;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.ISAMPollingMethod;

public class SAMICMPPollingMethod
implements ISAMPollingMethod {
    private static final String MODULE = "SAMICMPPollingMethod";
    private StringBuffer _sbPingCommand;
    private SystemLogger _oSystemLogger;

    public void init(Object object, Object object2, ConfigManager configManager, SystemLogger systemLogger) throws ASelectSAMException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "init()";
        String string2 = null;
        String string3 = null;
        URI uRI = null;
        this._oSystemLogger = systemLogger;
        try {
            try {
                string2 = configManager.getParam(object, "url");
            }
            catch (Exception exception) {
                stringBuffer.append("Error retrieving config item 'url' from the resource section.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                throw new ASelectSAMException("4009", exception);
            }
            try {
                string3 = configManager.getParam(object2, "pingcommand");
            }
            catch (Exception exception) {
                stringBuffer.append("Error retrieving config item 'pingcommand' from the resource section.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                throw new ASelectSAMException("4009", exception);
            }
            uRI = new URI(string2);
            if (uRI.getScheme().equalsIgnoreCase("jdbc")) {
                uRI = this.parseJDBCString(string2);
            }
            if (uRI.getHost() == null) {
                stringBuffer.append("The configured url doesn't contain a host.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                throw new ASelectSAMException("4009");
            }
            this._sbPingCommand = new StringBuffer(string3);
            this._sbPingCommand.append(" ");
            this._sbPingCommand.append(uRI.getHost());
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw aSelectSAMException;
        }
        catch (Exception exception) {
            stringBuffer.append("An error occured during the initialization of the SAM ICMP Poller: ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
            throw new ASelectSAMException("4009", exception);
        }
    }

    public boolean poll() {
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        String string = "poll()";
        boolean bl = false;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(this._sbPingCommand.toString());
            bl = process.waitFor() == 0;
        }
        catch (Exception exception) {
            stringBuffer.append("An error occured during the polling of the resource with command '");
            stringBuffer.append(this._sbPingCommand);
            stringBuffer.append("'");
            this._oSystemLogger.log(Level.FINE, MODULE, string, stringBuffer.toString(), exception);
        }
        return bl;
    }

    private URI parseJDBCString(String string) throws ASelectSAMException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "parseJDBCString()";
        URI uRI = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.startsWith("//")) continue;
                uRI = new URI("jdbc", string3.substring(2), null, null);
            }
        }
        catch (Exception exception) {
            stringBuffer.append("Could not parse the JDBC URI '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            this._oSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectSAMException("4008");
        }
        if (uRI == null) {
            stringBuffer.append("Invalid JDBC URI '");
            stringBuffer.append(string);
            stringBuffer.append("'. Empty result after creating the URI object.");
            this._oSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            throw new ASelectSAMException("4008");
        }
        return uRI;
    }
}

