/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.server.raw;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IProtocolRequest;
import org.aselect.system.communication.server.IProtocolResponse;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;

public class RawMessageCreator
implements IMessageCreatorInterface {
    private static final String ENCODED_BRACES = "%5B%5D";
    private Hashtable _htInputTable;
    private StringBuffer _sbOutputMessage = null;
    private IProtocolRequest _oRequest;
    private IProtocolResponse _oResponse;
    private SystemLogger _systemLogger;
    private final String MODULE = "RawMessageCreator";

    public RawMessageCreator(SystemLogger systemLogger) {
        this._systemLogger = systemLogger;
    }

    public boolean init(IProtocolRequest iProtocolRequest, IProtocolResponse iProtocolResponse) throws ASelectCommunicationException {
        this._oRequest = iProtocolRequest;
        this._oResponse = iProtocolResponse;
        String string = "init()";
        boolean bl = false;
        String string2 = this._oRequest.getProperty("QueryString");
        if (string2 != null) {
            this._htInputTable = new Hashtable();
            try {
                this._htInputTable = this.convertCGIMessage(string2);
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.WARNING, "RawMessageCreator", string, "Can't convert QueryString to Hashtable", aSelectCommunicationException);
                throw new ASelectCommunicationException("4007", aSelectCommunicationException);
            }
            if (this._htInputTable.isEmpty()) {
                this._systemLogger.log(Level.WARNING, "RawMessageCreator", string, "Can't convert QueryString to Hashtable, empty input message.");
                throw new ASelectCommunicationException("4007");
            }
        } else {
            this._systemLogger.log(Level.WARNING, "RawMessageCreator", string, "Invalid request, no QueryString");
            throw new ASelectCommunicationException("4007");
        }
        this._sbOutputMessage = new StringBuffer();
        bl = true;
        return bl;
    }

    public String getParam(String string) throws ASelectCommunicationException {
        String string2 = "getParam()";
        StringBuffer stringBuffer = null;
        String string3 = null;
        if (string != null) {
            if (!this._htInputTable.containsKey(string)) {
                stringBuffer = new StringBuffer("Can't find parameter name: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.FINE, "RawMessageCreator", string2, stringBuffer.toString());
                throw new ASelectCommunicationException("4007");
            }
        } else {
            this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, "No parameter name supplied");
            throw new ASelectCommunicationException("4007");
        }
        string3 = (String)this._htInputTable.get(string);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getArray(String string) throws ASelectCommunicationException {
        String string2 = "getArray()";
        StringBuffer stringBuffer = null;
        String[] stringArray = null;
        if (string != null) {
            if (this._htInputTable.containsKey(string)) {
                try {
                    return (String[])this._htInputTable.get(string);
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("Could not cast to String array: \"");
                    stringBuffer.append(exception.getMessage());
                    stringBuffer.append("\" Parameter name: ");
                    stringBuffer.append(string).append(ENCODED_BRACES);
                    this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, stringBuffer.toString(), exception);
                    throw new ASelectCommunicationException("4007");
                }
            }
            stringBuffer = new StringBuffer("Can't find parameter: ");
            stringBuffer.append(string).append(ENCODED_BRACES);
            this._systemLogger.log(Level.FINE, "RawMessageCreator", string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, "No parameter name supplied.");
        throw new ASelectCommunicationException("4007");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setParam(String string, String string2) throws ASelectCommunicationException {
        String string3 = "setParam()";
        StringBuffer stringBuffer = null;
        boolean bl = false;
        if (string != null && string2 != null) {
            try {
                string2 = URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer = new StringBuffer("Could not URL encode parameter '");
                stringBuffer.append(string);
                stringBuffer.append("' with value '");
                stringBuffer.append(string).append("'");
                this._systemLogger.log(Level.WARNING, "RawMessageCreator", string3, stringBuffer.toString(), unsupportedEncodingException);
                throw new ASelectCommunicationException("0001");
            }
            if (this._sbOutputMessage.indexOf(string + "=") == -1) {
                if (this._sbOutputMessage.length() > 0) {
                    this._sbOutputMessage.append("&" + string + "=" + string2);
                    return true;
                } else {
                    this._sbOutputMessage.append(string + "=" + string2);
                }
                return true;
            }
            stringBuffer = new StringBuffer("Parameter ");
            stringBuffer.append(string);
            stringBuffer.append(" already exists in output message");
            this._systemLogger.log(Level.FINE, "RawMessageCreator", string3, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        this._systemLogger.log(Level.WARNING, "RawMessageCreator", string3, "Unable to set empty parameter");
        throw new ASelectCommunicationException("4007");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setParam(String string, String[] stringArray) throws ASelectCommunicationException {
        String string2 = "setParam()";
        StringBuffer stringBuffer = null;
        boolean bl = false;
        if (string != null && stringArray != null) {
            if (this._sbOutputMessage.indexOf(string + ENCODED_BRACES + "=") == -1) {
                if (this._sbOutputMessage.length() > 0) {
                    this._sbOutputMessage.append("&");
                }
                try {
                    this._sbOutputMessage.append(this.convertArray(string, stringArray));
                    return true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    stringBuffer = new StringBuffer("Could not URL encode array parameter '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                    this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, stringBuffer.toString(), unsupportedEncodingException);
                    throw new ASelectCommunicationException("0001");
                }
            }
            stringBuffer = new StringBuffer("Parameter ");
            stringBuffer.append(string);
            stringBuffer.append("[] already exists in output message");
            this._systemLogger.log(Level.FINE, "RawMessageCreator", string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, "Unable to set empty parameter.");
        throw new ASelectCommunicationException("4007");
    }

    public Hashtable convertCGIMessage(String string) throws ASelectCommunicationException {
        Hashtable<String, Object> hashtable;
        block8: {
            String string2 = "convertCGIMessage()";
            hashtable = new Hashtable<String, Object>();
            StringTokenizer stringTokenizer = null;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            try {
                Vector vector;
                if (string == null) break block8;
                stringTokenizer = new StringTokenizer(string, "&");
                while (stringTokenizer.hasMoreElements()) {
                    String string3;
                    int n;
                    String string4 = (String)stringTokenizer.nextElement();
                    if (string4.trim().equals("") || (n = string4.indexOf(61)) == -1) continue;
                    String string5 = string4.substring(0, n);
                    try {
                        string3 = string4.substring(n + 1);
                    }
                    catch (Exception exception) {
                        string3 = "";
                    }
                    if (string5 == null || string3 == null) continue;
                    string3 = URLDecoder.decode(string3, "UTF-8");
                    if (string5.endsWith(ENCODED_BRACES)) {
                        string5 = string5.substring(0, string5.lastIndexOf(ENCODED_BRACES));
                        vector = null;
                        vector = hashtable2.containsKey(string5) ? (Vector)hashtable2.get(string5) : new Vector();
                        vector.add(string3);
                        hashtable2.put(string5, vector);
                        continue;
                    }
                    hashtable.put(string5, string3);
                }
                if (!hashtable2.isEmpty()) {
                    vector = hashtable2.keys();
                    while (vector.hasMoreElements()) {
                        String string6 = (String)vector.nextElement();
                        Vector vector2 = (Vector)hashtable2.get(string6);
                        String[] stringArray = new String[vector2.size()];
                        stringArray = vector2.toArray(stringArray);
                        hashtable.put(string6, stringArray);
                    }
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, "Exception during converting the CGI message", exception);
                throw new ASelectCommunicationException("0001", exception);
            }
        }
        return hashtable;
    }

    public boolean send() throws ASelectCommunicationException {
        String string = "send()";
        boolean bl = false;
        if (this._sbOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, "RawMessageCreator", string, "Supplied message is empty");
            throw new ASelectCommunicationException("4007");
        }
        bl = this.sendMessage(this._sbOutputMessage.toString());
        this._htInputTable = null;
        this._sbOutputMessage = null;
        return bl;
    }

    private boolean sendMessage(String string) throws ASelectCommunicationException {
        String string2 = "sendMessage()";
        boolean bl = false;
        try {
            OutputStream outputStream = this._oResponse.getOutputStream();
            outputStream.write(string.getBytes());
            outputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, "RawMessageCreator", string2, "Error sending message", iOException);
            throw new ASelectCommunicationException("4006");
        }
        return bl;
    }

    private StringBuffer convertArray(String string, String[] stringArray) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("&");
            }
            String string2 = URLEncoder.encode(stringArray[i], "UTF-8");
            stringBuffer.append(string).append(ENCODED_BRACES).append("=").append(string2);
        }
        return stringBuffer;
    }
}

