/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.tgt;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.authspprotocol.handler.AuthSPHandlerManager;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class TGTIssuer {
    private static final String MODULE = "TGTIssuer";
    private static final String COOKIE_ASELECT_UID = "aselect_uid";
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger = ASelectSystemLogger.getHandle();
    private CryptoEngine _cryptoEngine;
    private String _sServerId;
    private SessionManager _sessionManager;
    private TGTManager _tgtManager;
    private AuthSPHandlerManager _authSPHandlerManager;

    public TGTIssuer(String string) {
        this._configManager = ASelectConfigManager.getHandle();
        this._cryptoEngine = CryptoEngine.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._tgtManager = TGTManager.getHandle();
        this._authSPHandlerManager = AuthSPHandlerManager.getHandle();
        this._sServerId = string;
    }

    public void issueCrossTGT(String string, String string2, Hashtable hashtable, HttpServletResponse httpServletResponse, String string3, HttpServletRequest httpServletRequest) throws ASelectException {
        String string4 = "issueCrossTGT()";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        try {
            Object object;
            Serializable serializable;
            String string8;
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("No session found, session expired: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString());
                throw new ASelectException("0102");
            }
            String string9 = (String)hashtable2.get("app_url");
            Integer n = (Integer)hashtable2.get("level");
            String string10 = (String)hashtable2.get("app_id");
            String string11 = (String)hashtable2.get("remote_organization");
            String string12 = (String)hashtable2.get("remote_organization_url");
            String string13 = (String)hashtable.get("uid");
            String string14 = (String)hashtable.get("organization");
            string5 = (String)hashtable.get("authsp_level");
            string2 = (String)hashtable.get("authsp");
            String string15 = (String)hashtable.get("attributes");
            string7 = (String)hashtable2.get("arp_target");
            if (string13 != null) {
                string8 = URLEncoder.encode(string13, "UTF-8");
                string8 = URLEncoder.encode(string8, "UTF-8");
            }
            string8 = null;
            if (hashtable2.get("remote_session") != null) {
                string9 = (String)hashtable2.get("local_as_url");
                string8 = (String)hashtable2.get("local_organization");
                serializable = new StringBuffer("[unknown@");
                ((StringBuffer)serializable).append(string8);
                ((StringBuffer)serializable).append("]");
                string10 = ((StringBuffer)serializable).toString();
            }
            serializable = new Hashtable<String, String>();
            ((Hashtable)serializable).put("uid", string13);
            ((Hashtable)serializable).put("organization", string14);
            ((Hashtable)serializable).put("authsp_level", string5);
            ((Hashtable)serializable).put("authsp", string2);
            ((Hashtable)serializable).put("app_level", n.toString());
            ((Hashtable)serializable).put("app_id", string10);
            ((Hashtable)serializable).put("rid", string);
            if (string7 != null) {
                ((Hashtable)serializable).put("arp_target", string7);
            }
            if (string11 != null && !string11.equals(string14)) {
                ((Hashtable)serializable).put("proxy_organization", string11);
                if (string12 != null) {
                    ((Hashtable)serializable).put("proxy_organization_url", string12);
                }
            }
            if (string15 != null) {
                ((Hashtable)serializable).put("remote_attributes", string15);
            }
            if (string8 != null) {
                ((Hashtable)serializable).put("local_organization", string8);
            }
            Hashtable hashtable3 = null;
            if (string3 != null && (hashtable3 = this._tgtManager.getTGT(string3)) != null) {
                object = this.verifyTGT(hashtable3, (Hashtable)serializable);
                if (!((Hashtable)object).isEmpty()) {
                    ((Hashtable)serializable).putAll(object);
                }
                ((Hashtable)serializable).put("rid", string);
                this._tgtManager.updateTGT(string3, (Hashtable)serializable);
                string6 = string3;
            }
            if (hashtable3 == null) {
                string6 = this._tgtManager.createTGT((Hashtable)serializable);
                if (this._configManager.isSingleSignOn()) {
                    this.setASelectCookie(string6, string13, httpServletResponse, httpServletRequest);
                }
                if ((object = (String)hashtable2.get("uid")) == null) {
                    object = string13;
                }
                this.setUIDCookie(httpServletResponse, (String)object, httpServletRequest);
            }
            this.sendRedirect(string9, string6, string, httpServletResponse);
            this._sessionManager.killSession(string);
        }
        catch (ASelectException aSelectException) {
            StringBuffer stringBuffer = new StringBuffer("Issue TGT for request '");
            stringBuffer.append(string).append("' failed");
            this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Issue TGT for request '");
            stringBuffer.append(string).append("' failed due to internal error");
            this._systemLogger.log(Level.SEVERE, MODULE, string4, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void issueTGT(String string, String string2, Hashtable hashtable, HttpServletResponse httpServletResponse, String string3, HttpServletRequest httpServletRequest) throws ASelectException {
        String string4 = "issueTGT()";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("No session found, session expired: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString());
                throw new ASelectException("0102");
            }
            string7 = (String)hashtable2.get("arp_target");
            String string8 = (String)hashtable2.get("app_url");
            String string9 = (String)hashtable2.get("user_id");
            String string10 = (String)hashtable2.get("organization");
            String string11 = (String)hashtable2.get("app_id");
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            Integer n = (Integer)hashtable2.get("level");
            Vector vector = (Vector)hashtable2.get("sso_groups");
            string5 = this._authSPHandlerManager.getLevel(string2).toString();
            try {
                object2 = this._configManager.getSection(null, "authsps");
                object = this._configManager.getSection(object2, "authsp", "id=" + string2);
                string5 = this._configManager.getParam(object, "level");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string5 = ((Integer)hashtable2.get("authsp_level")).toString();
            }
            object2 = URLEncoder.encode(string9, "UTF-8");
            object2 = URLEncoder.encode((String)object2, "UTF-8");
            object = null;
            if (hashtable2.get("remote_session") != null) {
                string8 = (String)hashtable2.get("local_as_url");
                object = (String)hashtable2.get("local_organization");
                serializable = new StringBuffer("[unknown@");
                ((StringBuffer)serializable).append((String)object);
                ((StringBuffer)serializable).append("]");
                string11 = ((StringBuffer)serializable).toString();
            }
            serializable = new Hashtable<String, String>();
            ((Hashtable)serializable).put("uid", string9);
            ((Hashtable)serializable).put("organization", string10);
            ((Hashtable)serializable).put("authsp_level", string5);
            ((Hashtable)serializable).put("authsp", string2);
            ((Hashtable)serializable).put("app_level", n.toString());
            ((Hashtable)serializable).put("app_id", string11);
            ((Hashtable)serializable).put("rid", string);
            if (string7 != null) {
                ((Hashtable)serializable).put("arp_target", string7);
            }
            if (hashtable3 != null) {
                ((Hashtable)serializable).put("allowed_user_authsps", hashtable3);
            }
            if (object != null) {
                ((Hashtable)serializable).put("local_organization", object);
            }
            if (vector != null) {
                ((Hashtable)serializable).put("sso_groups", vector);
            }
            if (hashtable != null) {
                ((Hashtable)serializable).putAll(hashtable);
            }
            Hashtable hashtable4 = null;
            if (string3 != null && (hashtable4 = this._tgtManager.getTGT(string3)) != null) {
                Hashtable hashtable5 = this.verifyTGT(hashtable4, (Hashtable)serializable);
                if (!hashtable5.isEmpty()) {
                    ((Hashtable)serializable).putAll(hashtable5);
                }
                ((Hashtable)serializable).put("rid", string);
                this._tgtManager.updateTGT(string3, (Hashtable)serializable);
                string6 = string3;
            }
            if (hashtable4 == null) {
                string6 = this._tgtManager.createTGT((Hashtable)serializable);
                if (this._configManager.isSingleSignOn()) {
                    this.setASelectCookie(string6, string9, httpServletResponse, httpServletRequest);
                }
                this.setUIDCookie(httpServletResponse, string9, httpServletRequest);
            }
            this.sendRedirect(string8, string6, string, httpServletResponse);
            this._sessionManager.killSession(string);
        }
        catch (ASelectException aSelectException) {
            StringBuffer stringBuffer = new StringBuffer("Issue TGT for request '");
            stringBuffer.append(string).append("' failed");
            this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Issue TGT for request '");
            stringBuffer.append(string).append("' failed due to internal error");
            this._systemLogger.log(Level.SEVERE, MODULE, string4, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void issueErrorTGT(String string, String string2, HttpServletResponse httpServletResponse) throws ASelectException {
        String string3 = "issueErrorTGT()";
        SessionManager sessionManager = null;
        try {
            String string4;
            Object object;
            sessionManager = SessionManager.getHandle();
            TGTManager tGTManager = TGTManager.getHandle();
            Hashtable hashtable = sessionManager.getSessionContext(string);
            if (hashtable == null) {
                StringBuffer stringBuffer = new StringBuffer("No session found, session expired: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString());
                throw new ASelectException("0102");
            }
            Object object2 = (String)hashtable.get("app_url");
            if (hashtable.get("remote_session") != null) {
                object2 = object = (String)hashtable.get("local_as_url");
            }
            object = new Hashtable();
            String string5 = (String)hashtable.get("app_id");
            if (string5 != null) {
                ((Hashtable)object).put("app_id", string5);
            }
            if ((string4 = (String)hashtable.get("local_organization")) != null) {
                ((Hashtable)object).put("local_organization", string4);
            }
            ((Hashtable)object).put("rid", string);
            ((Hashtable)object).put("result_code", string2);
            String string6 = tGTManager.createTGT((Hashtable)object);
            this.sendRedirect((String)object2, string6, string, httpServletResponse);
            sessionManager.killSession(string);
        }
        catch (ASelectException aSelectException) {
            StringBuffer stringBuffer = new StringBuffer("Issue cancel TGT for request '");
            stringBuffer.append(string).append("' failed");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Issue cancel TGT for request '");
            stringBuffer.append(string).append("' failed due to internal error");
            this._systemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void sendRedirect(String string, String string2, String string3, HttpServletResponse httpServletResponse) throws ASelectException {
        String string4 = "sendRedirect()";
        StringBuffer stringBuffer = null;
        try {
            string = string.indexOf("?") > 0 ? string + "&" : string + "?";
            String string5 = this._cryptoEngine.encryptTGT(Utils.stringToHex((String)string2));
            stringBuffer = new StringBuffer(string);
            stringBuffer.append("aselect_credentials=");
            stringBuffer.append(string5);
            stringBuffer.append("&rid=");
            stringBuffer.append(string3);
            stringBuffer.append("&a-select-server=");
            stringBuffer.append(this._sServerId);
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer2 = new StringBuffer("Could not send redirect to user: ");
            stringBuffer2.append(stringBuffer.toString());
            this._systemLogger.log(Level.SEVERE, MODULE, string4, stringBuffer2.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void setASelectCookie(String string, String string2, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws ASelectException {
        String string3 = "setASelectCookie()";
        try {
            String string4;
            String string5;
            StringBuffer stringBuffer = new StringBuffer("tgt=");
            stringBuffer.append(string);
            stringBuffer.append("&uid=");
            stringBuffer.append(string2);
            stringBuffer.append("&a-select-server=");
            stringBuffer.append(this._sServerId);
            Cookie cookie = new Cookie("aselect_credentials", stringBuffer.toString());
            if (this._configManager.getCookiesVersion() != -1) {
                cookie.setVersion(this._configManager.getCookiesVersion());
            }
            if ((string5 = this._configManager.getCookieDomain()) != null) {
                cookie.setDomain(string5);
            }
            if ((string4 = this._configManager.getCookieDomainPath()) != null) {
                cookie.setPath(string4);
            }
            if (httpServletRequest.isSecure()) {
                cookie.setSecure(true);
            }
            httpServletResponse.addCookie(cookie);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not create an A-Select cookie for user: ");
            stringBuffer.append(string2);
            this._systemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void setUIDCookie(HttpServletResponse httpServletResponse, String string, HttpServletRequest httpServletRequest) throws ASelectException {
        String string2 = "setUIDCookie()";
        try {
            String string3;
            String string4;
            Cookie cookie = new Cookie(COOKIE_ASELECT_UID, string);
            if (this._configManager.getCookiesVersion() != -1) {
                cookie.setVersion(this._configManager.getCookiesVersion());
            }
            if ((string4 = this._configManager.getUIDCookieDomain()) != null) {
                cookie.setDomain(string4);
            }
            if ((string3 = this._configManager.getUIDCookieDomainPath()) != null) {
                cookie.setPath(string3);
            }
            if (httpServletRequest.isSecure()) {
                cookie.setSecure(true);
            }
            httpServletResponse.addCookie(cookie);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not create an A-Select cookie for user: " + string, exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private Hashtable verifyTGT(Hashtable hashtable, Hashtable hashtable2) {
        int n;
        int n2;
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        String string = (String)hashtable.get("authsp_level");
        String string2 = (String)hashtable2.get("authsp_level");
        if (string != null && string2 != null && (n2 = new Integer(string).intValue()) > (n = new Integer(string2).intValue())) {
            hashtable3.put("authsp_level", string);
        }
        return hashtable3;
    }
}

