/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.session;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.StorageManager;
import org.aselect.system.utils.Utils;

public class SessionManager
extends StorageManager {
    public static final String MODULE = "SessionManager";
    private static SessionManager _oSessionManager;
    private long _lSessionsCounter = 0L;
    private long _lProcessTime;
    private SystemLogger _systemLogger;

    public void init() throws ASelectException, ASelectConfigException {
        String string = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
            Object object = null;
            try {
                object = aSelectConfigManager.getSection(null, "storagemanager", "id=session");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'storagemanager' section with id='session' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            super.init(object, (ConfigManager)aSelectConfigManager, this._systemLogger, (SAMAgent)ASelectSAMAgent.getHandle());
            this._lSessionsCounter = 0L;
            this._systemLogger.log(Level.INFO, MODULE, string, "Session manager Successfully started.");
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    public static SessionManager getHandle() {
        if (_oSessionManager == null) {
            _oSessionManager = new SessionManager();
        }
        return _oSessionManager;
    }

    public void destroy() {
        super.destroy();
    }

    public synchronized String createSession(Hashtable hashtable) throws ASelectException {
        String string = "createSession()";
        String string2 = null;
        try {
            byte[] byArray = new byte[8];
            CryptoEngine.nextRandomBytes(byArray);
            string2 = Utils.toHexString((byte[])byArray);
            while (this.containsKey(string2)) {
                CryptoEngine.nextRandomBytes(byArray);
                string2 = Utils.toHexString((byte[])byArray);
            }
            this.put(string2, hashtable);
            ++this._lSessionsCounter;
        }
        catch (ASelectStorageException aSelectStorageException) {
            if (aSelectStorageException.getMessage().equals("6010")) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Maximum number of sessions reached", (Throwable)aSelectStorageException);
                throw new ASelectException("0050", (Throwable)aSelectStorageException);
            }
            throw aSelectStorageException;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not create session", (Throwable)exception);
            string2 = null;
        }
        return string2;
    }

    public boolean createSession(String string, Hashtable hashtable) {
        String string2 = "createSession()";
        boolean bl = false;
        try {
            this.put(string, hashtable);
            bl = true;
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not update session: " + string, (Throwable)aSelectStorageException);
        }
        return bl;
    }

    public boolean updateSession(String string, Hashtable hashtable) {
        String string2 = "updateSession()";
        boolean bl = false;
        try {
            if (this.containsKey(string)) {
                this.update(string, hashtable);
                bl = true;
            }
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not update session with id: " + string, (Throwable)aSelectStorageException);
        }
        return bl;
    }

    public Hashtable getSessionContext(String string) {
        String string2 = "getSessionContext()";
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)this.get(string);
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not find context for session with id: " + string, (Throwable)aSelectStorageException);
        }
        return hashtable;
    }

    public synchronized void killSession(String string) {
        String string2 = "killSession()";
        try {
            this._lProcessTime = System.currentTimeMillis() - this.getTimestamp(string);
            this.remove(string);
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not remove session with id: " + string, (Throwable)aSelectStorageException);
        }
    }

    public long getProcessingTime() {
        return this._lProcessTime;
    }

    public long getCounter() {
        return this._lSessionsCounter;
    }

    private SessionManager() {
    }
}

