/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler;

import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.IRequestHandler;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public abstract class AbstractRequestHandler
implements IRequestHandler {
    protected ASelectSystemLogger _systemLogger;
    protected ASelectConfigManager _configManager;
    protected SessionManager _oSessionManager;
    protected ServletConfig _oServletConfig;
    private static final String MODULE = "AbstractRequestHandler";
    private String _sID;
    private Pattern _pTarget;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._oSessionManager = SessionManager.getHandle();
            this._oServletConfig = servletConfig;
            try {
                this._sID = this._configManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' in 'handler' section found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string2 = null;
            try {
                string2 = this._configManager.getParam(object, "target");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'target' in 'handler' section found", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._pTarget = Pattern.compile(string2);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Not a valid pattern: " + string2, exception);
                throw new ASelectException("4009", (Throwable)exception);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public String getID() {
        return this._sID;
    }

    public Pattern getPattern() {
        return this._pTarget;
    }
}

