/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross.selectorhandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.config.Version;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class DefaultSelectorHandler
implements ISelectorHandler {
    private static final String MODULE = "DefaultSelectorHandler";
    private String _sHTMLSelectForm;
    private String _sMyServerId;
    private String _sFriendlyName;
    private CrossASelectManager _crossASelectManager;
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        try {
            this._crossASelectManager = CrossASelectManager.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            Object object2 = this._configManager.getSection(null, "aselect");
            this._sMyServerId = this._configManager.getParam(object2, "server_id");
            this._sFriendlyName = this._configManager.getParam(object2, "organization_friendly_name");
            this.loadHTMLTemplates();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize the default selector handler", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Hashtable getRemoteServerId(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable hashtable3 = this._crossASelectManager.getRemoteServers();
        String string = null;
        string = (String)hashtable.get("remote_server");
        if (string == null || string.equalsIgnoreCase("")) {
            this.showSelectForm(hashtable, printWriter, hashtable3);
            return null;
        }
        hashtable2.put("organization_id", string);
        return hashtable2;
    }

    private void showSelectForm(Hashtable hashtable, PrintWriter printWriter, Hashtable hashtable2) throws ASelectException {
        String string = "showSelectForm()";
        String string2 = null;
        try {
            string2 = this._sHTMLSelectForm;
            String string3 = (String)hashtable.get("rid");
            string2 = Utils.replaceString((String)string2, (String)"[rid]", (String)string3);
            string2 = Utils.replaceString((String)string2, (String)"[aselect_url]", (String)((String)hashtable.get("my_url")));
            string2 = Utils.replaceString((String)string2, (String)"[request]", (String)"cross_login");
            string2 = Utils.replaceString((String)string2, (String)"[a-select-server]", (String)this._sMyServerId);
            string2 = Utils.replaceString((String)string2, (String)"[available_remote_servers]", (String)this.getRemoteServerHTML(hashtable2));
            StringBuffer stringBuffer = new StringBuffer((String)hashtable.get("my_url")).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(this._sMyServerId).append("&rid=").append((String)hashtable.get("rid"));
            string2 = Utils.replaceString((String)string2, (String)"[cancel]", (String)stringBuffer.toString());
            Hashtable hashtable3 = SessionManager.getHandle().getSessionContext(string3);
            if (hashtable3 != null) {
                string2 = this._configManager.updateTemplate(string2, hashtable3);
            }
            printWriter.println(string2);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not show select form", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private String getRemoteServerHTML(Hashtable hashtable) {
        String string = new String();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string = string + "<OPTION VALUE='" + string2 + "'>" + string3 + "</OPTION>\n";
        }
        return string;
    }

    private void loadHTMLTemplates() throws ASelectException {
        String string = this._configManager.getWorkingdir() + File.separator + "conf" + File.separator + "html" + File.separator;
        this._sHTMLSelectForm = this.loadHTMLTemplate(string + "defaultcrossselect.html");
        this._sHTMLSelectForm = Utils.replaceString((String)this._sHTMLSelectForm, (String)"[version]", (String)Version.getVersion());
        this._sHTMLSelectForm = Utils.replaceString((String)this._sHTMLSelectForm, (String)"[organization_friendly]", (String)this._sFriendlyName);
    }

    private String loadHTMLTemplate(String string) throws ASelectException {
        String string2 = new String();
        BufferedReader bufferedReader = null;
        String string3 = "loadHTMLTemplate()";
        try {
            String string4;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = string2 + string4 + "\n";
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load '");
            stringBuffer.append(string).append("'HTML template.");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not close '");
                stringBuffer.append(string).append("' FileInputStream.");
                this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            }
        }
        return string2;
    }
}

