/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class CrossASelectManager {
    private static final String MODULE = "CrossASelectManager";
    private static final String TAG_FRIENLDY_NAME = "[requestor_friendly_name]";
    private static final String TAG_MAINTAINER_EMAIL = "[requestor_maintainer_email]";
    private static final String TAG_SHOW_URL = "[requestor_url]";
    private static CrossASelectManager _oCrossASelectManager;
    private ASelectConfigManager _oASelectConfigManager;
    private ASelectSystemLogger _systemLogger;
    private static ISelectorHandler _iSelectorHandler;
    private Object _oCrossConfigSection;
    private Object _oHandlerConfigSection;
    private Object _oRemoteConfigSection;
    private Object _oLocalConfigSection;
    private boolean _bRemoteServersEnabled = false;
    private boolean _bCrossSelectorEnabled = false;
    private boolean _bLocalServersEnabled = false;
    private boolean _bRequireLocalSigning;
    private boolean _bUseRemoteSigning;
    private Hashtable _htLocalServerPublicKeys = null;
    private Hashtable _htForcedOrganisations = null;
    private Hashtable _htRemoteServers;
    private String _sMyOrg;
    private Hashtable _htLocalServerInfo;

    private CrossASelectManager() {
    }

    public static CrossASelectManager getHandle() {
        if (_oCrossASelectManager == null) {
            _oCrossASelectManager = new CrossASelectManager();
        }
        return _oCrossASelectManager;
    }

    public void init() throws ASelectConfigException {
        String string = "init()";
        this._oASelectConfigManager = ASelectConfigManager.getHandle();
        this._systemLogger = ASelectSystemLogger.getHandle();
        this._bRemoteServersEnabled = false;
        this._bCrossSelectorEnabled = false;
        this._bLocalServersEnabled = false;
        this._htForcedOrganisations = new Hashtable();
        this._htLocalServerInfo = new Hashtable();
        Object object = null;
        try {
            object = this._oASelectConfigManager.getSection(null, "aselect");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No 'aselect' config section found", aSelectConfigException);
            throw aSelectConfigException;
        }
        try {
            this._sMyOrg = this._oASelectConfigManager.getParam(object, "organization");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'organization' config parameter in aselect config section", aSelectConfigException);
            throw aSelectConfigException;
        }
        try {
            this._oCrossConfigSection = this._oASelectConfigManager.getSection(null, "cross_aselect");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.INFO, MODULE, string, "'cross_aselect' disabled.");
            return;
        }
        try {
            this._bLocalServersEnabled = this.loadLocalServerSettings();
            if (this._bLocalServersEnabled) {
                this._systemLogger.log(Level.INFO, MODULE, string, "This server can act as remote server.");
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to load local servers.", aSelectException);
            throw new ASelectConfigException(aSelectException.getMessage());
        }
        try {
            this._bRemoteServersEnabled = this.loadRemoteServerSettings();
            if (this._bRemoteServersEnabled) {
                this._systemLogger.log(Level.INFO, MODULE, string, "This server can act as local server.");
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to load remote servers.", aSelectException);
            throw new ASelectConfigException(aSelectException.getMessage());
        }
        try {
            if (this._bRemoteServersEnabled) {
                this._bCrossSelectorEnabled = this.loadRemoteSelectorSettings();
            }
            if (this._bCrossSelectorEnabled) {
                this._systemLogger.log(Level.INFO, MODULE, string, "cross_selector enabled.");
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to load cross_selector.", aSelectException);
            throw new ASelectConfigException(aSelectException.getMessage());
        }
    }

    public boolean isLocalSigningRequired() {
        return this._bRequireLocalSigning;
    }

    public boolean isForcedAuthenticateEnabled(String string) {
        String string2 = "isForcedAuthenticateEnabled()";
        boolean bl = false;
        try {
            Boolean bl2 = (Boolean)this._htForcedOrganisations.get(string.toLowerCase());
            bl = bl2;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Organization id not found:");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
        }
        return bl;
    }

    public boolean useRemoteSigning() {
        return this._bUseRemoteSigning;
    }

    public boolean remoteServersEnabled() {
        return this._bRemoteServersEnabled;
    }

    public boolean isCrossSelectorEnabled() {
        return this._bCrossSelectorEnabled;
    }

    public boolean localServersEnabled() {
        return this._bLocalServersEnabled;
    }

    public ISelectorHandler getSelectorHandler() {
        return _iSelectorHandler;
    }

    public String getRemoteParam(String string, String string2) {
        String string3 = null;
        String string4 = "getRemoteParam()";
        Object object = null;
        try {
            try {
                object = this._oASelectConfigManager.getSection(this._oRemoteConfigSection, "organization", "id=" + string);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid 'organization' section found for '");
                stringBuffer.append(string).append("' in 'remote_servers' config.");
                this._systemLogger.log(Level.FINE, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            try {
                string3 = this._oASelectConfigManager.getParam(object, string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid '");
                stringBuffer.append(string2).append("' found for '");
                stringBuffer.append(string).append("' in 'organization' section");
                this._systemLogger.log(Level.FINE, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            string3 = string3.trim();
            return string3;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string4, "Internal error", exception);
            return null;
        }
    }

    public String getLocalParam(String string, String string2) {
        String string3 = null;
        String string4 = "getLocalParam()";
        Object object = null;
        try {
            try {
                object = this._oASelectConfigManager.getSection(this._oLocalConfigSection, "organization", "id=" + string);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid 'organization' section found for '");
                stringBuffer.append(string).append("' in 'local_servers' config");
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            try {
                string3 = this._oASelectConfigManager.getParam(object, string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid '");
                stringBuffer.append(string2).append("' found for '");
                stringBuffer.append(string).append("' in 'organization' section");
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            string3 = string3.trim();
            return string3;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string4, "Internal error", exception);
            return null;
        }
    }

    public String getOptionalLocalParam(String string, String string2) throws ASelectException {
        String string3 = null;
        String string4 = "getOptionalLocalParam()";
        Object object = null;
        try {
            object = this._oASelectConfigManager.getSection(this._oLocalConfigSection, "organization", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("No valid 'organisation' section found for '");
            stringBuffer.append(string).append("' in A-Select config");
            this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
            throw new ASelectException("4011");
        }
        try {
            string3 = this._oASelectConfigManager.getParam(object, string2);
            string3 = string3.trim();
        }
        catch (ASelectConfigException aSelectConfigException) {
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string4, "Internal error", exception);
            throw new ASelectException("0001");
        }
        return string3;
    }

    public PublicKey getLocalASelectServerPublicKey(String string) {
        return (PublicKey)this._htLocalServerPublicKeys.get(string.toLowerCase());
    }

    public String getHandlerConfig(String string) {
        String string2;
        String string3 = "getHandlerConfig()";
        try {
            string2 = this._oASelectConfigManager.getParam(this._oHandlerConfigSection, string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.FINE, MODULE, string3, "No handler configuration found", aSelectConfigException);
            string2 = "";
        }
        return string2;
    }

    public Hashtable getRemoteServers() {
        return this._htRemoteServers;
    }

    public Hashtable getLocalServerInfo(String string) {
        Hashtable hashtable = new Hashtable();
        if (this._htLocalServerInfo != null && string != null) {
            hashtable = (Hashtable)this._htLocalServerInfo.get(string);
        }
        return hashtable;
    }

    private boolean loadLocalServerSettings() throws ASelectException {
        String string;
        String string2 = "loadLocalServerSettings()";
        Object object = null;
        try {
            this._oLocalConfigSection = this._oASelectConfigManager.getSection(this._oCrossConfigSection, "local_servers");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string2, "No 'local_servers' section found. This A-Select Server can not act as remote server (cross).", aSelectConfigException);
            return false;
        }
        try {
            object = this._oASelectConfigManager.getSection(this._oLocalConfigSection, "organization");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No valid 'organization' section found in 'local_servers' section", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            string = this._oASelectConfigManager.getParam(this._oLocalConfigSection, "require_signing");
            this._bRequireLocalSigning = new Boolean(string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._bRequireLocalSigning = false;
            this._systemLogger.log(Level.CONFIG, MODULE, string2, "No valid 'require_signing' parameter found in section 'local_servers', Using default value 'false'", aSelectConfigException);
        }
        if (this._bRequireLocalSigning) {
            this.loadLocalServerSigningKeys(this._oASelectConfigManager.getWorkingdir());
        }
        while (object != null) {
            Object object2;
            string = null;
            Boolean bl = new Boolean(false);
            try {
                string = this._oASelectConfigManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No valid 'id' parameter found in section 'organisation'", aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                object2 = this._oASelectConfigManager.getParam(object, "forced_authenticate");
                bl = new Boolean((String)object2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No valid 'forced_authenticate' parameter found in section 'local_servers', setting forced_authenticate to FALSE", aSelectConfigException);
            }
            if (string.equalsIgnoreCase(this._sMyOrg)) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Organization conflict: The configured local organization is equal to the current A-Select Server organization.");
                throw new ASelectException("4009");
            }
            this._htForcedOrganisations.put(string.toLowerCase(), bl);
            object2 = new Hashtable();
            String string3 = null;
            try {
                string3 = this._oASelectConfigManager.getParam(object, "maintainer_email");
                ((Hashtable)object2).put(TAG_MAINTAINER_EMAIL, string3);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No optional 'maintainer_email' config item found in 'organization' config section", aSelectConfigException);
            }
            String string4 = null;
            try {
                string4 = this._oASelectConfigManager.getParam(object, "friendly_name");
                ((Hashtable)object2).put(TAG_FRIENLDY_NAME, string4);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No optional 'friendly_name' config item found in 'organization' config section", aSelectConfigException);
            }
            String string5 = null;
            try {
                string5 = this._oASelectConfigManager.getParam(object, "show_url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No optional 'show_url' config item found in 'organization' config section", aSelectConfigException);
            }
            Boolean bl2 = null;
            bl2 = string5 == null ? new Boolean(true) : new Boolean(string5);
            ((Hashtable)object2).put(TAG_SHOW_URL, bl2);
            this._htLocalServerInfo.put(string.toLowerCase(), object2);
            object = this._oASelectConfigManager.getNextSection(object);
        }
        return true;
    }

    private boolean loadRemoteServerSettings() throws ASelectException {
        Object object;
        String string = "loadRemoteServerSettings()";
        this._htRemoteServers = new Hashtable();
        try {
            this._oRemoteConfigSection = this._oASelectConfigManager.getSection(this._oCrossConfigSection, "remote_servers");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'remote_servers' section found. This A-Select Server can not act as local server (cross).", aSelectConfigException);
            return false;
        }
        try {
            object = this._oASelectConfigManager.getParam(this._oRemoteConfigSection, "sign_requests");
            this._bUseRemoteSigning = new Boolean((String)object);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._bRequireLocalSigning = false;
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'sign_requests' parameter found in section 'local_servers', Using default value 'false'", aSelectConfigException);
        }
        object = null;
        try {
            object = this._oASelectConfigManager.getSection(this._oRemoteConfigSection, "organization");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Not even one 'organization' config section found in 'remote_servers' section", aSelectConfigException);
        }
        while (object != null) {
            String string2 = null;
            try {
                string2 = this._oASelectConfigManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'id' config item found in 'organization' config section", aSelectConfigException);
                throw aSelectConfigException;
            }
            String string3 = null;
            try {
                string3 = this._oASelectConfigManager.getParam(object, "friendly_name");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'friendly_name' config item found in 'organization' config section", aSelectConfigException);
                throw aSelectConfigException;
            }
            if (string2.equalsIgnoreCase(this._sMyOrg)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Organization conflict: The configured remote organization is equal to the current A-Select Server organization.");
                throw new ASelectException("4009");
            }
            this._htRemoteServers.put(string2, string3);
            object = this._oASelectConfigManager.getNextSection(object);
        }
        return true;
    }

    private boolean loadRemoteSelectorSettings() throws ASelectException {
        Object object;
        String string = "loadRemoteSelectorSettings()";
        try {
            object = this._oASelectConfigManager.getSection(this._oCrossConfigSection, "cross_selector");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "'cross_selector' disabled", aSelectConfigException);
            return false;
        }
        try {
            String string2 = this._oASelectConfigManager.getParam(object, "handler");
            this._oHandlerConfigSection = this._oASelectConfigManager.getSection(object, "handler", "id=" + string2);
            _iSelectorHandler = null;
            Class<?> clazz = Class.forName(this.getHandlerConfig("class"));
            _iSelectorHandler = (ISelectorHandler)clazz.newInstance();
            _iSelectorHandler.init(this._oHandlerConfigSection);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to initialize cross_selector: ", aSelectConfigException);
            throw aSelectConfigException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to initialize cross_selector: ", exception);
            throw new ASelectException("4011", (Throwable)exception);
        }
        return true;
    }

    private void loadLocalServerSigningKeys(String string) throws ASelectException {
        String string2 = "loadLocalServerSigningKeys()";
        try {
            String string3 = string + File.separator + "keystores" + File.separator + "cross" + File.separator + "local_servers.keystore";
            this._htLocalServerPublicKeys = new Hashtable();
            Object object = null;
            try {
                object = this._oASelectConfigManager.getSection(this._oLocalConfigSection, "organization");
            }
            catch (ASelectConfigException aSelectConfigException) {
                // empty catch block
            }
            while (object != null) {
                String string4 = this._oASelectConfigManager.getParam(object, "id");
                this._htLocalServerPublicKeys.put(string4.toLowerCase(), this.loadPublicKeyFromKeystore(string3, string4));
                object = this._oASelectConfigManager.getNextSection(object);
            }
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Failed to load configuration of local servers.", aSelectConfigException);
            throw aSelectConfigException;
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Failed to load public keys of local servers.", aSelectException);
            throw aSelectException;
        }
    }

    private PublicKey loadPublicKeyFromKeystore(String string, String string2) throws ASelectException {
        String string3 = "loadPublicKeyFromKeystore()";
        try {
            string2 = string2.toLowerCase();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            return x509Certificate.getPublicKey();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("could not load '");
            stringBuffer.append(string2);
            stringBuffer.append("' from '");
            stringBuffer.append(string);
            stringBuffer.append("'.");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("4005");
        }
    }
}

