/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.config.Version;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectUDBException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.Utils;

public class ASelectConfigManager
extends ConfigManager {
    public static final String MODULE = "ASelectConfigManager";
    private static ASelectConfigManager _oASelectConfigManager;
    public static final String TAG_FRIENLDY_NAME = "[requestor_friendly_name]";
    public static final String TAG_MAINTAINER_EMAIL = "[requestor_maintainer_email]";
    public static final String TAG_SHOW_URL = "[requestor_url]";
    public static final String TAG_LANGUAGE = "[language]";
    public static final String TAG_COUNTRY = "[country]";
    private Object _oASelectConfigSection;
    private boolean _bSingleSignOn;
    private boolean _bUDBEnabled;
    private String _sWorkingDir;
    private String _sRedirectURL;
    private Hashtable _htAuthspKeys = new Hashtable();
    private Properties _propErrorMessages = new Properties();
    private Hashtable _htServerCrypto = new Hashtable();
    private Hashtable _htPrivilegedPublicKeys = new Hashtable();
    private String _sLoginForm;
    private String _sDirectLoginForm;
    private String _sSelectForm;
    private String _sErrorForm;
    private String _sPopupForm;
    private String _sServerInfoForm;
    private String _sUserInfoForm;
    private String _sLoggedOutForm;
    private ASelectSystemLogger _systemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private String _sCookieDomain = null;
    private String _sCookieDomainPath = null;
    private String _sUIDCookieDomain = null;
    private String _sUIDCookieDomainPath = null;
    private boolean _bCrossFallbackEnabled = false;
    private int _iCookiesVersion;

    public static ASelectConfigManager getHandle() {
        if (_oASelectConfigManager == null) {
            _oASelectConfigManager = new ASelectConfigManager();
        }
        return _oASelectConfigManager;
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws ASelectException {
        Object object;
        String string8 = "init()";
        StringBuffer stringBuffer = null;
        this._sWorkingDir = string;
        this._systemLogger = ASelectSystemLogger.getHandle();
        this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
        if (string2 != null || string4 != null || string5 != null || string6 != null) {
            stringBuffer = new StringBuffer("Reading config from database: ");
            stringBuffer.append(string5);
            this._systemLogger.log(Level.CONFIG, MODULE, string8, stringBuffer.toString());
            super.init(string2, string3, string4, string5, string6, string7, (SystemLogger)this._systemLogger);
        } else {
            object = new StringBuffer(string);
            if (!string.endsWith(File.separator)) {
                ((StringBuffer)object).append(File.separator);
            }
            ((StringBuffer)object).append("conf");
            ((StringBuffer)object).append(File.separator);
            ((StringBuffer)object).append("aselect.xml");
            stringBuffer = new StringBuffer("Reading config from file: ");
            stringBuffer.append(((StringBuffer)object).toString());
            this._systemLogger.log(Level.CONFIG, MODULE, string8, stringBuffer.toString());
            super.init(((StringBuffer)object).toString(), (SystemLogger)this._systemLogger);
        }
        try {
            this._oASelectConfigSection = this.getSection(null, "aselect");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string8, "Could not find aselect config section in config file", aSelectConfigException);
            throw aSelectConfigException;
        }
        object = null;
        try {
            object = this.getSection(this._oASelectConfigSection, "logging", "id=system");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string8, "No valid 'logging' config section with id='system' found.", exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        this._systemLogger.init(object, string);
        stringBuffer = new StringBuffer("Starting ");
        stringBuffer.append(Version.getVersion());
        this._systemLogger.log(Level.INFO, MODULE, string8, stringBuffer.toString());
        Object object2 = null;
        try {
            object2 = this.getSection(this._oASelectConfigSection, "logging", "id=authentication");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string8, "No valid 'logging' config section with id='authentication' found.", exception);
            throw new ASelectException("4009");
        }
        this._oASelectAuthenticationLogger.init(object2, string);
        this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully initialized ASelectAuthenticationLogger.");
        StringBuffer stringBuffer2 = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer2.append(File.separator);
        }
        stringBuffer2.append("conf");
        stringBuffer2.append(File.separator);
        stringBuffer2.append("errors");
        stringBuffer2.append(File.separator);
        stringBuffer2.append("errors.conf");
        File file = new File(stringBuffer2.toString());
        if (!file.exists()) {
            StringBuffer stringBuffer3 = new StringBuffer("No errors config file found: ");
            stringBuffer3.append(stringBuffer2.toString());
            this._systemLogger.log(Level.SEVERE, MODULE, string8, stringBuffer3.toString());
            throw new ASelectConfigException("4005");
        }
        try {
            this._propErrorMessages.load(new FileInputStream(stringBuffer2.toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._systemLogger.log(Level.WARNING, MODULE, string8, "Error loading error messages", fileNotFoundException);
            throw new ASelectException("4005");
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string8, "Error loading error messages", iOException);
            throw new ASelectException("4006");
        }
        try {
            this._sRedirectURL = this.getParam(this._oASelectConfigSection, "redirect_url");
            new URL(this._sRedirectURL);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string8, "No configuration item 'redirect_url' defined, using default");
        }
        catch (MalformedURLException malformedURLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string8, "Configured configuration item 'redirect_url' isn't an URL: " + this._sRedirectURL);
            throw new ASelectException("4009", (Throwable)malformedURLException);
        }
        stringBuffer = new StringBuffer("Successfully loaded ");
        stringBuffer.append(this._propErrorMessages.size());
        stringBuffer.append(" error messages from: ");
        stringBuffer.append(stringBuffer2.toString());
        this._systemLogger.log(Level.INFO, MODULE, string8, stringBuffer.toString());
        this.checkEssentialConfig();
        this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully parsed essential system configuration.");
        try {
            ASelectSAMAgent.getHandle().init();
        }
        catch (ASelectSAMException aSelectSAMException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string8, "Can't initialize SAMAgent", aSelectSAMException);
            throw aSelectSAMException;
        }
        this.loadDefaultPrivateKey(string);
        String string9 = null;
        try {
            string9 = this.getParam(this._oASelectConfigSection, "single_sign_on");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string8, "No 'single_sign_on' config item found, using default: single_sign_on = enabled", aSelectConfigException);
        }
        boolean bl = this._bSingleSignOn = string9 == null || string9.equalsIgnoreCase("true");
        if (!this._bSingleSignOn) {
            this._systemLogger.log(Level.INFO, MODULE, string8, "Single sign-on is disabled");
        }
        this._systemLogger.log(Level.INFO, MODULE, string8, "Single sign-on is enabled");
        this.readCredentialsCookieSettings(this._oASelectConfigSection);
        this.readUIDCookieSettings(this._oASelectConfigSection);
        this.readOptionalCookiesSettings();
        if (this._htServerCrypto.size() > 0) {
            this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully loaded default private key.");
            this.loadAuthSPSettings(string);
            this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully loaded AuthSP settings.");
            try {
                this.checkUDBSettings();
                this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully loaded UDB settings.");
                this._bUDBEnabled = true;
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string8, "No valid UDB settings found, resume starting with UDB disabled.");
                this._bUDBEnabled = false;
            }
        }
        this.loadHTMLTemplates(string);
        this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully loaded HTML templates");
        this.loadPrivilegedSettings(string);
        this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully loaded privileged settings");
        this._systemLogger.log(Level.INFO, MODULE, string8, "Successfully initialized A-Select Server Config Manager");
    }

    public boolean isSingleSignOn() {
        return this._bSingleSignOn;
    }

    public boolean isUDBEnabled() {
        return this._bUDBEnabled;
    }

    public String getCookieDomain() {
        return this._sCookieDomain;
    }

    public String getCookieDomainPath() {
        return this._sCookieDomainPath;
    }

    public String getUIDCookieDomain() {
        return this._sUIDCookieDomain;
    }

    public String getUIDCookieDomainPath() {
        return this._sUIDCookieDomainPath;
    }

    public int getCookiesVersion() {
        return this._iCookiesVersion;
    }

    public String getWorkingdir() {
        return this._sWorkingDir;
    }

    public String getRedirectURL() {
        return this._sRedirectURL;
    }

    public Hashtable getAuthspSettings() {
        return this._htAuthspKeys;
    }

    public PublicKey getPrivilegedPublicKey(String string) {
        return (PublicKey)this._htPrivilegedPublicKeys.get(string);
    }

    public PrivateKey getDefaultPrivateKey() {
        return (PrivateKey)this._htServerCrypto.get("private_key");
    }

    public X509Certificate getDefaultCertificate() {
        return (X509Certificate)this._htServerCrypto.get("signing_cert");
    }

    public String getDefaultCertId() {
        return (String)this._htServerCrypto.get("cert_id");
    }

    public String getErrorMessage(String string) {
        String string2 = null;
        try {
            string2 = this._propErrorMessages.getProperty(string).trim();
            if (string2 == null) {
                return string;
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string2;
    }

    public String getForm(String string) {
        if (string.equals("login")) {
            return this._sLoginForm;
        }
        if (string.equals("direct_login")) {
            return this._sDirectLoginForm;
        }
        if (string.equals("userinfo")) {
            return this._sUserInfoForm;
        }
        if (string.equals("select")) {
            return this._sSelectForm;
        }
        if (string.equals("popup")) {
            return this._sPopupForm;
        }
        if (string.equals("serverinfo")) {
            return this._sServerInfoForm;
        }
        if (string.equals("error")) {
            return this._sErrorForm;
        }
        if (string.equals("loggedout")) {
            return this._sLoggedOutForm;
        }
        return "";
    }

    public String updateTemplate(String string, Hashtable hashtable) throws ASelectException {
        String string2 = "updateTemplate()";
        String string3 = null;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        try {
            string3 = string;
            if (hashtable != null) {
                String string9 = (String)hashtable.get("local_organization");
                if (string9 != null) {
                    Hashtable hashtable2 = CrossASelectManager.getHandle().getLocalServerInfo(string9);
                    if (hashtable2 != null) {
                        string4 = (String)hashtable2.get(TAG_FRIENLDY_NAME);
                        string5 = (String)hashtable2.get(TAG_MAINTAINER_EMAIL);
                        Boolean bl = (Boolean)hashtable2.get(TAG_SHOW_URL);
                        if (bl != null && bl.booleanValue()) {
                            string6 = (String)hashtable.get("local_as_url");
                        }
                    }
                } else {
                    String string10 = (String)hashtable.get("app_id");
                    if (string10 != null) {
                        string4 = ApplicationManager.getHandle().getFriendlyName(string10);
                        string5 = ApplicationManager.getHandle().getMaintainerEmail(string10);
                        if (ApplicationManager.getHandle().isShowUrl(string10)) {
                            string6 = (String)hashtable.get("app_url");
                        }
                    }
                }
                string7 = (String)hashtable.get("language");
                string8 = (String)hashtable.get("country");
            }
            if (string4 == null) {
                string4 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)TAG_FRIENLDY_NAME, (String)string4);
            if (string5 == null) {
                string5 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)TAG_MAINTAINER_EMAIL, (String)string5);
            if (string6 == null) {
                string6 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)TAG_SHOW_URL, (String)string6);
            if (string7 == null) {
                string7 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)TAG_LANGUAGE, (String)string7);
            if (string8 == null) {
                string8 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)TAG_COUNTRY, (String)string8);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not update template with optional parameters", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return string3;
    }

    private ASelectConfigManager() {
    }

    private void loadDefaultPrivateKey(String string) throws ASelectException {
        String string2 = "loadDefaultPrivateKey()";
        String string3 = "aselect.keystore";
        String string4 = null;
        try {
            try {
                string4 = this.getParam(this._oASelectConfigSection, "keystore_password");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("Missing keystore_password in config.xml\n");
                stringBuffer.append("\tAuthentication of users is disabled.\n");
                stringBuffer.append("\tOnly cross authentication is possible through ");
                stringBuffer.append("cross A-Select servers running on other organizations.");
                this._systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString());
                return;
            }
            String string5 = this.getParam(this._oASelectConfigSection, "server_id");
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append(string3);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            char[] cArray = string4.toCharArray();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string5, cArray);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string5);
            byte[] byArray = x509Certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            String string6 = Utils.toHexString((byte[])messageDigest.digest());
            this._htServerCrypto.put("signing_cert", x509Certificate);
            this._htServerCrypto.put("private_key", privateKey);
            this._htServerCrypto.put("cert_id", string6);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not load my private key", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private void loadAuthSPSettings(String string) throws ASelectException {
        String string2 = "loadAuthSPSettings()";
        Object object = null;
        Object object2 = null;
        try {
            try {
                object2 = this.getSection(null, "authsps");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No valid 'authsps' config section found", aSelectConfigException);
            }
            if (object2 != null) {
                try {
                    object = this.getSection(object2, "authsp");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "No valid 'authsp' config section found", aSelectConfigException);
                }
            }
            while (object != null) {
                if (this.checkAuthSPConfig(object)) {
                    this.loadAuthSPPublicKey(string, object);
                }
                object = this.getNextSection(object);
            }
            if (this._htAuthspKeys.size() == 0) {
                StringBuffer stringBuffer = new StringBuffer("No authsp definitions found. AuthSP's disabled. ");
                stringBuffer.append("Can be valid if A-Select Server is configured in Cross A-Select modus.");
                this._systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString());
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load AuthSP settings.");
            stringBuffer.append("AuthSP's disabled.");
            stringBuffer.append("Can be valid if A-Select Server is configured in Cross A-Select modus");
            this._systemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString(), exception);
        }
    }

    private void loadAuthSPPublicKey(String string, Object object) throws ASelectException {
        String string2 = "loadAuthSPPublicKey()";
        PublicKey publicKey = null;
        StringBuffer stringBuffer = null;
        File file = null;
        KeyStore keyStore = null;
        X509Certificate x509Certificate = null;
        try {
            String string3 = this.getParam(object, "id");
            string3 = string3.trim();
            string3 = string3.toLowerCase();
            String string4 = this.getParam(object, "type");
            string4 = string4.toLowerCase();
            if (!string4.equals("remote") && !string4.equals("local")) {
                StringBuffer stringBuffer2 = new StringBuffer(string3);
                stringBuffer2.append(" type=");
                stringBuffer2.append(string4);
                stringBuffer2.append(" is illegal. Use 'local' or 'remote'.");
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer2.toString());
                throw new ASelectException("4009");
            }
            stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append(string4);
            stringBuffer.append(File.separator);
            stringBuffer.append(string4).append("_authsp.keystore");
            file = new File(stringBuffer.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer3 = new StringBuffer("Keystore doesn't exist: ");
                stringBuffer3.append(stringBuffer.toString());
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer3.toString());
                throw new ASelectException("4009");
            }
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            x509Certificate = (X509Certificate)keyStore.getCertificate(string3);
            if (x509Certificate == null) {
                StringBuffer stringBuffer4 = new StringBuffer("No public key found for alias: '");
                stringBuffer4.append(string3).append("'");
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer4.toString());
                throw new ASelectException("4009");
            }
            publicKey = x509Certificate.getPublicKey();
            this._htAuthspKeys.put(string3 + ".public_key", publicKey);
            int n = 1;
            x509Certificate = (X509Certificate)keyStore.getCertificate(string3 + n);
            while (x509Certificate != null) {
                publicKey = x509Certificate.getPublicKey();
                StringBuffer stringBuffer5 = new StringBuffer(string3);
                stringBuffer5.append(n);
                stringBuffer5.append(".public_key");
                this._htAuthspKeys.put(stringBuffer5.toString(), publicKey);
                x509Certificate = (X509Certificate)keyStore.getCertificate(string3 + ++n);
            }
            this.loadAuthSPSpecificPrivateKey(string, object);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not load AuthSP public key", exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }

    private void loadAuthSPSpecificPrivateKey(String string, Object object) throws ASelectException {
        String string2 = "loadAuthSPSpecificPrivateKey()";
        String string3 = null;
        String string4 = null;
        try {
            string3 = this.getParam(object, "id");
            string3 = string3.trim();
            string3 = string3.toLowerCase();
            try {
                string4 = this.getParam(object, "specific_key_password");
            }
            catch (ASelectConfigException aSelectConfigException) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append(string3);
            stringBuffer.append("_specific.keystore");
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer2 = new StringBuffer("Keystore doesn't exist: ");
                stringBuffer2.append(stringBuffer.toString());
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer2.toString());
                throw new ASelectException("4009");
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            char[] cArray = string4.toCharArray();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string3, cArray);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string3);
            byte[] byArray = x509Certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            String string5 = Utils.toHexString((byte[])messageDigest.digest());
            this._htAuthspKeys.put(string3 + ".specific_private_key", privateKey);
            this._htAuthspKeys.put(string3 + ".specific_private_key.cert_id", string5);
        }
        catch (ASelectConfigException aSelectConfigException) {
            return;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("could not load specific private key for alias '");
            stringBuffer.append(string3);
            stringBuffer.append("'");
            this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString(), exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }

    private void loadHTMLTemplates(String string) throws ASelectException {
        String string2 = "loadHTMLTemplates()";
        try {
            this._sLoginForm = new String();
            this._sErrorForm = new String();
            this._sSelectForm = new String();
            this._sPopupForm = new String();
            this._sServerInfoForm = new String();
            this._sUserInfoForm = new String();
            this._sLoggedOutForm = new String();
            this._sDirectLoginForm = new String();
            this._sServerInfoForm = this.loadHTMLTemplate(string, "serverinfo.html");
            this._sUserInfoForm = this.loadHTMLTemplate(string, "userinfo.html");
            this._sLoggedOutForm = this.loadHTMLTemplate(string, "loggedout.html");
            this._sErrorForm = this.loadHTMLTemplate(string, "error.html");
            if (this._htServerCrypto.size() > 0) {
                this._sLoginForm = this.loadHTMLTemplate(string, "login.html");
                this._sSelectForm = this.loadHTMLTemplate(string, "select.html");
                this._sPopupForm = this.loadHTMLTemplate(string, "popup.html");
                this._sDirectLoginForm = this.loadHTMLTemplate(string, "directlogin.html");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Error loading HTML templates", exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }

    private String loadHTMLTemplate(String string, String string2) throws ASelectException {
        String string3 = null;
        String string4 = "";
        BufferedReader bufferedReader = null;
        String string5 = "loadHTMLTemplate()";
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("conf");
            stringBuffer.append(File.separator);
            stringBuffer.append("html");
            stringBuffer.append(File.separator);
            stringBuffer.append(string2);
            Comparable<File> comparable = new File(stringBuffer.toString());
            if (!((File)comparable).exists()) {
                this._systemLogger.log(Level.WARNING, MODULE, string5, "Required template not found: " + stringBuffer.toString());
                throw new ASelectException("4009");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)comparable)));
            while ((string3 = bufferedReader.readLine()) != null) {
                string4 = string4 + string3 + "\n";
            }
            string4 = Utils.replaceString((String)string4, (String)"[version]", (String)Version.getVersion());
            string4 = Utils.replaceString((String)string4, (String)"[organization_friendly]", (String)this.getParam(this._oASelectConfigSection, "organization_friendly_name"));
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load '");
            stringBuffer.append(string2).append("' HTML template.");
            this._systemLogger.log(Level.WARNING, MODULE, string5, stringBuffer.toString(), exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not close '");
                stringBuffer.append(string2).append("' FileInputStream");
                this._systemLogger.log(Level.WARNING, MODULE, string5, stringBuffer.toString(), exception);
            }
        }
        return string4;
    }

    private void loadPrivilegedSettings(String string) throws ASelectException {
        String string2 = "loadPrivilegedSettings()";
        this._htPrivilegedPublicKeys = new Hashtable();
        try {
            Object object = this.getSection(null, "applications");
            Object object2 = null;
            try {
                object2 = this.getSection(object, "application");
            }
            catch (ASelectConfigException aSelectConfigException) {
                // empty catch block
            }
            while (object2 != null) {
                String string3 = this.getParam(object2, "id");
                String string4 = null;
                try {
                    string4 = this.getParam(object2, "privileged");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
                if (string4 != null && string4.equalsIgnoreCase("true")) {
                    this.loadPrivilegedPublicKey(string, string3);
                }
                object2 = this.getNextSection(object2);
            }
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string2, "No privileged applications configured", aSelectConfigException);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.INFO, MODULE, string2, "Error loading privileged settings", exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }

    private void loadPrivilegedPublicKey(String string, String string2) throws ASelectException {
        String string3 = "loadPrivilegedPublicKey()";
        try {
            string2 = string2.toLowerCase();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append("keystores");
            stringBuffer.append(File.separator);
            stringBuffer.append("applications");
            stringBuffer.append(File.separator);
            stringBuffer.append("privileged_applications.keystore");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(stringBuffer.toString()), null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            PublicKey publicKey = x509Certificate.getPublicKey();
            this._htPrivilegedPublicKeys.put(string2, publicKey);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load public key of privileged application '");
            stringBuffer.append(string2);
            stringBuffer.append("'");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
    }

    private boolean checkAuthSPConfig(Object object) {
        String string = null;
        String string2 = "checkAuthSPConfig()";
        try {
            string = this.getParam(object, "id");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Missing 'id' parameter in authSP section", aSelectConfigException);
            return false;
        }
        try {
            this.getParam(object, "handler");
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("Missing 'handler' parameter in ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), aSelectConfigException);
            return false;
        }
        try {
            this.getParam(object, "level");
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("Missing 'level' parameter in ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), aSelectConfigException);
            return false;
        }
        try {
            this.getParam(object, "friendly_name");
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("Missing 'friendly_name' parameter in ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), aSelectConfigException);
            return false;
        }
        try {
            this.getParam(object, "type");
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("Missing 'type' parameter in ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), aSelectConfigException);
            return false;
        }
        return true;
    }

    private void checkUDBSettings() throws ASelectException {
        Object object;
        Object object2 = null;
        String string = null;
        Object object3 = null;
        String string2 = null;
        IUDBConnector iUDBConnector = null;
        String string3 = "checkUDBSettings()";
        try {
            object2 = this.getSection(null, "udb");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string3, "Could not retrieve optional 'udb' config section", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            object = this.getParam(object2, "cross_fallback");
            this._bCrossFallbackEnabled = ((String)object).trim().equalsIgnoreCase("true");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string3, "Could not find 'cross_fallback' param in udb config section, so 'cross_fallback' disabled.", aSelectConfigException);
        }
        try {
            string = this.getParam(object2, "connector");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not retrieve 'connector' config parameter in udb config section", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            object3 = this.getSection(object2, "connector", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not retrieve connector config parameter in udb config section", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            string2 = this.getParam(object3, "class");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not retrieve 'class' config parameter in udb connector config section", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            object = Class.forName(string2);
            iUDBConnector = (IUDBConnector)((Class)object).newInstance();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "The configured udb connector class is not a valid UDBConnector class", exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        try {
            iUDBConnector.init(object3);
        }
        catch (ASelectUDBException aSelectUDBException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not initialize UDB as configured in the udb resource", aSelectUDBException);
            throw new ASelectException("4009", (Throwable)aSelectUDBException);
        }
    }

    private void checkEssentialConfig() throws ASelectException {
        String string = "checkEssentialConfig()";
        try {
            this.getParam(this._oASelectConfigSection, "organization");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'organization' parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(this._oASelectConfigSection, "organization_friendly_name");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'organization_friendly_name' parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(this._oASelectConfigSection, "server_id");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'server_id' parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        Object object = null;
        try {
            object = this.getSection(null, "storagemanager", "id=session");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'storagemanager' section with id=session in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(object, "max");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'max' parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(object, "expire");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'expire' (in session section) parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009");
        }
        try {
            object = this.getSection(null, "storagemanager", "id=tgt");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'storagemanager' section with id=tgt in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(object, "max");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'max' parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        try {
            this.getParam(object, "expire");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "missing 'expire' (in tgt section) parameter in configuration", aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
    }

    private void readUIDCookieSettings(Object object) {
        String string = "readUIDCookieSettings()";
        try {
            this._sUIDCookieDomain = this.getParam(object, "uid_cookie_domain");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._sUIDCookieDomain = null;
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No specific cookie domain for A-Select User ID cookie configured, using the default domain");
        }
        if (this._sUIDCookieDomain != null) {
            if (this._sUIDCookieDomain.trim().length() == 0) {
                this._sUIDCookieDomain = null;
            } else if (!this._sUIDCookieDomain.startsWith(".")) {
                this._sUIDCookieDomain = "." + this._sUIDCookieDomain;
            }
            if (this._sUIDCookieDomain != null) {
                this._systemLogger.log(Level.INFO, MODULE, string, "The following cookie domain will be used for setting the A-Select User ID cookie: " + this._sUIDCookieDomain);
            } else {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No specific cookie domain for A-Select User ID cookie configured, using the default domain");
            }
        }
        try {
            Object object2 = this.getSection(object, "uid_cookie_domain");
            this._sUIDCookieDomainPath = this.getParam(object2, "path");
            this._systemLogger.log(Level.INFO, MODULE, string, "The following path will be used for setting the A-Select UID cookie: " + this._sUIDCookieDomainPath);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._sUIDCookieDomainPath = null;
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'path' item in 'uid_cookie_domain' section found in configuration");
            this._systemLogger.log(Level.CONFIG, MODULE, string, "The A-Select UID cookie path will be set to de default path");
        }
    }

    private void readCredentialsCookieSettings(Object object) {
        String string = "readCredentialsCookieSettings()";
        try {
            this._sCookieDomain = this.getParam(object, "cookie_domain");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._sCookieDomain = null;
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No specific cookie domain for A-Select Credentials cookie configured, using the default domain");
        }
        if (this._sCookieDomain != null) {
            if (this._sCookieDomain.trim().length() == 0) {
                this._sCookieDomain = null;
            } else if (!this._sCookieDomain.startsWith(".")) {
                this._sCookieDomain = "." + this._sCookieDomain;
            }
            if (this._sCookieDomain != null) {
                this._systemLogger.log(Level.INFO, MODULE, string, "The following cookie domain will be used for setting the A-Select Credentials cookie: " + this._sCookieDomain);
            } else {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No specific cookie domain for A-Select Credentials cookie configured, using the default domain");
            }
        }
        try {
            Object object2 = this.getSection(object, "cookie_domain");
            this._sCookieDomainPath = this.getParam(object2, "path");
            this._systemLogger.log(Level.INFO, MODULE, string, "The following path will be used for setting the A-Select Credentials cookie: " + this._sCookieDomainPath);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._sCookieDomainPath = null;
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'path' item in 'cookie_domain' section found in configuration");
            this._systemLogger.log(Level.CONFIG, MODULE, string, "The A-Select Credentials cookie path will be set to de default path");
        }
    }

    private void readOptionalCookiesSettings() throws ASelectException {
        block9: {
            String string = "readOptionalCookiesSettings()";
            try {
                this._iCookiesVersion = -1;
                Object object = null;
                try {
                    object = this.getSection(this._oASelectConfigSection, "cookies");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'cookies' section found in configuration");
                }
                String string2 = null;
                try {
                    string2 = this.getParam(object, "version");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'version' item in 'cookies' section found in configuration");
                }
                if (string2 == null) break block9;
                try {
                    this._iCookiesVersion = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid 'version' item in 'cookies' section found in configuration (must be a number): " + string2);
                    throw new ASelectException("4009");
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error during reading optional 'cookies' configuration", exception);
                throw new ASelectException("0001");
            }
        }
    }

    public boolean isCrossFallBackEnabled() {
        return this._bCrossFallbackEnabled;
    }
}

