/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPDirectLoginProtocolHandler;
import org.aselect.server.authspprotocol.handler.AuthSPHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;

public class AuthSPHandlerManager {
    private static final String MODULE = "AuthSPHandlerManager";
    private static AuthSPHandlerManager _oAuthSPHandlerManager;
    private Hashtable _htAuthSPHandlers;
    private ASelectConfigManager _oASelectConfigManager;
    private SystemLogger _systemLogger;

    public static AuthSPHandlerManager getHandle() {
        if (_oAuthSPHandlerManager == null) {
            _oAuthSPHandlerManager = new AuthSPHandlerManager();
        }
        return _oAuthSPHandlerManager;
    }

    public void init() throws ASelectException {
        String string = "init()";
        try {
            this._oASelectConfigManager = ASelectConfigManager.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            Object object = null;
            this._htAuthSPHandlers = new Hashtable();
            try {
                object = this._oASelectConfigManager.getSection(null, "authsps");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'authsps' section found in A-Select config, AuthSP's are disabled");
                return;
            }
            Object object2 = null;
            try {
                object2 = this._oASelectConfigManager.getSection(object, "authsp");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "Not a single 'authsp' section found in A-Select config", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            while (object2 != null) {
                Object object3;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                boolean bl = false;
                try {
                    string2 = this._oASelectConfigManager.getParam(object2, "id");
                    string4 = this._oASelectConfigManager.getParam(object2, "resourcegroup");
                    string3 = this._oASelectConfigManager.getParam(object2, "handler");
                    string5 = this._oASelectConfigManager.getParam(object2, "type");
                    string6 = this._oASelectConfigManager.getParam(object2, "friendly_name");
                    string7 = this._oASelectConfigManager.getParam(object2, "popup");
                    string8 = this._oASelectConfigManager.getParam(object2, "level");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "failed to retrieve required parameter for configured authsp.", (Throwable)aSelectConfigException);
                    throw aSelectConfigException;
                }
                try {
                    object3 = this._oASelectConfigManager.getParam(object2, "direct_authsp");
                    bl = Boolean.valueOf((String)object3);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    bl = false;
                }
                object3 = null;
                try {
                    object3 = new Integer(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    this._systemLogger.log(Level.SEVERE, MODULE, string, "Error during initializing", (Throwable)numberFormatException);
                    throw new ASelectException("0101");
                }
                Boolean bl2 = new Boolean(string7);
                AuthSPHandler authSPHandler = new AuthSPHandler(string2, string3, string4, string5, string6, (Integer)object3, bl2);
                authSPHandler.setDirectAuthSP(bl);
                this._htAuthSPHandlers.put(string2, authSPHandler);
                object2 = this._oASelectConfigManager.getNextSection(object2);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Error during initializing", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Vector getConfiguredAuthSPs() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._htAuthSPHandlers.elements();
        while (enumeration.hasMoreElements()) {
            AuthSPHandler authSPHandler = (AuthSPHandler)enumeration.nextElement();
            vector.add(authSPHandler.getId());
        }
        return vector;
    }

    public Vector getConfiguredAuthSPs(Integer n, Integer n2) {
        if (n2 == null) {
            return this.getConfiguredAuthSPs(n);
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._htAuthSPHandlers.elements();
        while (enumeration.hasMoreElements()) {
            AuthSPHandler authSPHandler = (AuthSPHandler)enumeration.nextElement();
            Integer n3 = authSPHandler.getLevel();
            if (n3 < n || n3 > n2) continue;
            vector.add(authSPHandler.getId());
        }
        return vector;
    }

    public Vector getConfiguredAuthSPs(Integer n) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._htAuthSPHandlers.elements();
        while (enumeration.hasMoreElements()) {
            AuthSPHandler authSPHandler = (AuthSPHandler)enumeration.nextElement();
            Integer n2 = authSPHandler.getLevel();
            if (n2 < n) continue;
            vector.add(authSPHandler.getId());
        }
        return vector;
    }

    public boolean isDirectAuthSP(String string) throws ASelectException {
        String string2 = "isDirectAuthSP()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.isDirectAuthSP();
    }

    public String getFriendlyName(String string) throws ASelectException {
        String string2 = "getFriendlyName()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.getFriendlyName();
    }

    public String getHandler(String string) throws ASelectException {
        String string2 = "getHandler()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.getHandler();
    }

    public String getType(String string) throws ASelectException {
        String string2 = "getType()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.getType();
    }

    public Integer getLevel(String string) throws ASelectException {
        String string2 = "getLevel()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.getLevel();
    }

    public String getResourceGroup(String string) throws ASelectException {
        String string2 = "getResourceGroup()";
        AuthSPHandler authSPHandler = (AuthSPHandler)this._htAuthSPHandlers.get(string);
        if (authSPHandler == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No AuthSPHandler found with Id: '" + string + "'.");
            throw new ASelectException("0001");
        }
        return authSPHandler.getResourceGroup();
    }

    public String getUrl(String string) throws ASelectException {
        String string2 = "getUrl()";
        String string3 = null;
        String string4 = this.getResourceGroup(string);
        SAMResource sAMResource = null;
        try {
            try {
                sAMResource = ASelectSAMAgent.getHandle().getActiveResource(string4);
            }
            catch (ASelectSAMException aSelectSAMException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No resource retrieved for AuthSP: '" + string + "'.");
                throw new ASelectException("0001");
            }
            Object object = sAMResource.getAttributes();
            try {
                string3 = this._oASelectConfigManager.getParam(object, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No resource retrieved for AuthSP: '" + string + "'.");
                throw new ASelectException("0001");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Exception occured", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return string3;
    }

    public IAuthSPDirectLoginProtocolHandler getAuthSPDirectLoginProtocolHandler(String string) throws ASelectException {
        String string2 = "getAuthSPAPIProtocolHandler()";
        IAuthSPDirectLoginProtocolHandler iAuthSPDirectLoginProtocolHandler = null;
        String string3 = this.getHandler(string);
        try {
            Class<?> clazz = Class.forName(string3);
            Object obj = clazz.newInstance();
            if (!(obj instanceof IAuthSPDirectLoginProtocolHandler)) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Failed to initialize handler AuthSPHandler, because handler: '" + string3 + "' is not an instance of IAuthSPDirectLoginProtocolHandler");
                throw new ASelectException("0001");
            }
            iAuthSPDirectLoginProtocolHandler = (IAuthSPDirectLoginProtocolHandler)obj;
            iAuthSPDirectLoginProtocolHandler.init(string);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Failed to initialize IAuthSPDirectLoginProtocolHandler due to class not found exception", (Throwable)classNotFoundException);
            throw new ASelectException("0001");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Failed to initialize IAuthSPDirectLoginProtocolHandler due to unhandled exception", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return iAuthSPDirectLoginProtocolHandler;
    }
}

