/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.attributes.requestors.IAttributeRequestor;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class AttributeGatherer {
    private static final String _MODULE = "AttributeGatherer";
    private static AttributeGatherer _this;
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;
    private Hashtable _htRequestors;
    private Hashtable _htReleasePolicies;
    private Hashtable _htDuplicatePolicies;
    private Vector _vReleasePolicies;
    private String _sDefaultReleasePolicy;

    public static AttributeGatherer getHandle() {
        if (_this == null) {
            _this = new AttributeGatherer();
        }
        return _this;
    }

    public void init() throws ASelectException {
        block29: {
            String string = null;
            Object object = null;
            Object object2 = null;
            Object object3 = null;
            this._htRequestors = null;
            this._htReleasePolicies = null;
            this._vReleasePolicies = null;
            this._sDefaultReleasePolicy = null;
            this._htDuplicatePolicies = new Hashtable();
            this._configManager = ASelectConfigManager.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            try {
                Object object4;
                Object object5;
                Hashtable<String, Vector<Object>> hashtable;
                String string2;
                Object object6;
                try {
                    object = this._configManager.getSection(null, "attribute_gathering");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, _MODULE, "init()", "Attribute gathering disabled.");
                }
                if (object == null) break block29;
                string = "attribute_requestors";
                object2 = this._configManager.getSection(object, "attribute_requestors");
                this._htRequestors = new Hashtable();
                Object object7 = null;
                try {
                    object7 = this._configManager.getSection(object2, "requestor");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
                while (object7 != null) {
                    string = "id";
                    object6 = this._configManager.getParam(object7, "id");
                    string = "class";
                    string2 = this._configManager.getParam(object7, "class");
                    try {
                        hashtable = this._configManager.getSection(null, "requestor", "id=" + (String)object6);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        string = "requestor id=" + (String)object6;
                        throw aSelectConfigException;
                    }
                    try {
                        object5 = Class.forName(string2);
                        object4 = (IAttributeRequestor)((Class)object5).newInstance();
                        object4.init(hashtable);
                        this._htRequestors.put(object6, object4);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("Class \"").append(string2).append("\" is not a valid attribute requestor");
                        this._systemLogger.log(Level.SEVERE, _MODULE, "init()", stringBuffer.toString(), exception);
                        throw new ASelectException("4009", (Throwable)exception);
                    }
                    try {
                        object7 = this._configManager.getNextSection(object7);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        object7 = null;
                    }
                }
                string = "attribute_release_policies";
                object3 = this._configManager.getSection(object, "attribute_release_policies");
                try {
                    this._sDefaultReleasePolicy = this._configManager.getParam(object3, "default");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
                object6 = null;
                this._htReleasePolicies = new Hashtable();
                this._vReleasePolicies = new Vector();
                try {
                    object6 = this._configManager.getSection(object3, "release_policy");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
                while (object6 != null) {
                    string = "id";
                    string2 = this._configManager.getParam(object6, "id");
                    if (this._htReleasePolicies.containsKey(string2)) {
                        object5 = new StringBuffer("Release policy \"").append(string2).append("\" is defined more than once.");
                        this._systemLogger.log(Level.SEVERE, _MODULE, "init()", ((StringBuffer)object5).toString());
                        throw new ASelectException("4009");
                    }
                    string = "attribute";
                    object5 = this._configManager.getSection(object6, "attribute");
                    hashtable = new Hashtable<String, Vector<Object>>();
                    while (object5 != null) {
                        string = "id";
                        object4 = this._configManager.getParam(object5, "id");
                        string = "requestor";
                        String string3 = this._configManager.getParam(object5, "requestor");
                        Vector<Object> vector = (Vector<Object>)hashtable.get(string3);
                        if (vector == null) {
                            vector = new Vector<Object>();
                        }
                        vector.add(object4);
                        hashtable.put(string3, vector);
                        try {
                            object5 = this._configManager.getNextSection(object5);
                        }
                        catch (ASelectConfigException aSelectConfigException) {}
                    }
                    this._htReleasePolicies.put(string2, hashtable);
                    this._vReleasePolicies.add(string2);
                    try {
                        string = "duplicate";
                        object4 = this._configManager.getParam(object6, "duplicate");
                        this._htDuplicatePolicies.put(string2, object4);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        // empty catch block
                    }
                    try {
                        object6 = this._configManager.getNextSection(object6);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        object6 = null;
                    }
                }
                this._systemLogger.log(Level.INFO, _MODULE, "init()", "Succesfully parsed attributes configuration.");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("Configuration parameter or section \"").append(string).append("\" not found.");
                this._systemLogger.log(Level.WARNING, _MODULE, "init()", stringBuffer.toString(), aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, _MODULE, "init()", "Unexpected error while initializing", exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
    }

    public Hashtable gatherAttributes(Hashtable hashtable) throws ASelectException {
        Object object;
        Object object2;
        Hashtable<StringBuffer, Vector<Object>> hashtable2 = new Hashtable<StringBuffer, Vector<Object>>();
        String string = null;
        boolean bl = false;
        if (this._vReleasePolicies == null) {
            return null;
        }
        if (this._htReleasePolicies == null) {
            return null;
        }
        String string2 = (String)hashtable.get("uid");
        string = (String)hashtable.get("arp_target");
        if (string != null) {
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", "Error decoding arp_target parameter, e");
            }
        } else {
            this._systemLogger.log(Level.CONFIG, _MODULE, "gatherAttributes()", "No arp_target parameter defined");
            string = null;
        }
        String string3 = null;
        String string4 = (String)hashtable.get("local_organization");
        String string5 = (String)hashtable.get("app_id");
        if (string4 != null) {
            if (string != null) {
                object2 = this._vReleasePolicies.elements();
                while (object2.hasMoreElements() && !bl) {
                    object = (String)object2.nextElement();
                    if (!Utils.matchWildcardMask((String)string, (String)object)) continue;
                    string3 = object;
                    bl = true;
                }
            }
            if (string3 == null && !bl) {
                string3 = CrossASelectManager.getHandle().getOptionalLocalParam(string4, "attribute_policy");
            }
        } else {
            string3 = ApplicationManager.getHandle().getAttributePolicy(string5);
        }
        if (string3 == null) {
            string3 = this._sDefaultReleasePolicy;
        }
        if (string3 == null) {
            return hashtable2;
        }
        object2 = (Hashtable)this._htReleasePolicies.get(string3);
        if (object2 == null) {
            object = new StringBuffer("Unknown release policy '").append(string3).append("' configured for application '").append(string5).append("'");
            this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", ((StringBuffer)object).toString());
        } else {
            try {
                object = ((Hashtable)object2).keys();
                while (object.hasMoreElements()) {
                    CharSequence charSequence;
                    Serializable serializable;
                    String string6 = (String)object.nextElement();
                    Vector vector = (Vector)((Hashtable)object2).get(string6);
                    IAttributeRequestor iAttributeRequestor = null;
                    iAttributeRequestor = (IAttributeRequestor)this._htRequestors.get(string6);
                    if (iAttributeRequestor == null) {
                        serializable = new StringBuffer("Unknown requestor \"").append(string6).append("\"");
                        throw new Exception(((StringBuffer)serializable).toString());
                    }
                    serializable = null;
                    try {
                        serializable = iAttributeRequestor.getAttributes(hashtable, vector);
                    }
                    catch (ASelectAttributesException aSelectAttributesException) {
                        charSequence = new StringBuffer("Could not gather attributes for user \"").append(string2).append("\"");
                        this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", charSequence.toString(), aSelectAttributesException);
                    }
                    if (serializable == null) continue;
                    serializable = this.filterAttributes((Hashtable)serializable, vector);
                    Enumeration enumeration = ((Hashtable)serializable).keys();
                    while (enumeration.hasMoreElements()) {
                        charSequence = (String)enumeration.nextElement();
                        if (hashtable2.containsKey(charSequence)) {
                            String string7 = (String)this._htDuplicatePolicies.get(string3);
                            StringBuffer stringBuffer = new StringBuffer("Attribute \"").append((String)charSequence).append("\" returned by attribute requestor \"").append(string6).append("\" already exists (\"duplicate\"=\"" + string7 + "\").");
                            this._systemLogger.log(Level.INFO, _MODULE, "gatherAttributes()", stringBuffer.toString());
                            if (string7 == null) continue;
                            if (string7.equals("merge")) {
                                Object v = hashtable2.get(charSequence);
                                Vector vector2 = null;
                                if (v instanceof String) {
                                    vector2 = new Vector();
                                    vector2.add(v);
                                } else if (v instanceof Vector) {
                                    vector2 = (Vector)v;
                                } else {
                                    this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", "Attribute value (existing) neither String nor Vector!");
                                }
                                if (vector2 == null) continue;
                                Object v2 = ((Hashtable)serializable).get(charSequence);
                                if (v2 instanceof String) {
                                    vector2.add(v2);
                                } else if (v2 instanceof Vector) {
                                    vector2.addAll((Vector)v2);
                                } else {
                                    this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", "Attribute value (to-be-added) neither String nor Vector!");
                                }
                                hashtable2.put((StringBuffer)charSequence, vector2);
                                continue;
                            }
                            if (string7.equals("replace")) {
                                hashtable2.put((StringBuffer)charSequence, (Vector<Object>)((Hashtable)serializable).get(charSequence));
                                continue;
                            }
                            if (string7.equals("delete")) {
                                hashtable2.remove(charSequence);
                                continue;
                            }
                            this._systemLogger.log(Level.WARNING, _MODULE, "gatherAttributes()", "Unknown attribute policy \"duplicate\" option: \"" + string7 + "\"!");
                            continue;
                        }
                        hashtable2.put((StringBuffer)charSequence, (Vector<Object>)((Hashtable)serializable).get(charSequence));
                    }
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, _MODULE, "gatherAttributes()", "Error while gathering attributes", exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
        return hashtable2;
    }

    public void destroy() {
        String string = "destroy()";
        try {
            if (this._htRequestors != null) {
                Enumeration enumeration = this._htRequestors.elements();
                while (enumeration.hasMoreElements()) {
                    IAttributeRequestor iAttributeRequestor = (IAttributeRequestor)enumeration.nextElement();
                    iAttributeRequestor.destroy();
                }
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, _MODULE, string, "Error during the process of the destroy", exception);
        }
    }

    private AttributeGatherer() {
    }

    private Hashtable filterAttributes(Hashtable hashtable, Vector vector) {
        if (hashtable == null || vector == null) {
            return hashtable;
        }
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Object v;
                String string2 = (String)enumeration2.nextElement();
                if (!Utils.matchWildcardMask((String)string, (String)string2) || (v = hashtable.get(string)) == null) continue;
                hashtable2.put(string, v);
            }
        }
        return hashtable2;
    }
}

