/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.admin;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.table.AbstractTableModel;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;

public class TGTMonitorModel
extends AbstractTableModel
implements Runnable {
    public static final String MODULE = "TGTMonitorModel";
    private Thread _oRunnerThread;
    private String[] _saTGTs;
    private String[] _saHeaders = new String[]{"Issued to", "From Organization", "TGT Expires at", "AuthSP Used", "TGT Level", "For Application"};
    private int _iCheckInterval;
    private Hashtable _htTGTContexts;
    private TGTManager _oTGTManager = TGTManager.getHandle();
    private ASelectConfigManager _oConfigManager = ASelectConfigManager.getHandle();
    private boolean _bActive = false;

    public TGTMonitorModel(int n) {
        this._iCheckInterval = n;
        String string = null;
        Integer n2 = null;
        try {
            Object object = this._oConfigManager.getSection(null, "storagemanager", "id=tgt");
            string = this._oConfigManager.getParam(object, "max");
            n2 = Integer.valueOf(string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            ASelectSystemLogger.getHandle().log(Level.SEVERE, MODULE, "TGTMonitorModel()", "No valid 'max' config item found in 'storagemanager' config section with id='tgt'", aSelectConfigException);
            n2 = Integer.valueOf("100");
        }
        this._saTGTs = new String[n2.intValue()];
        this.getServerStatus();
        this._bActive = true;
        this._oRunnerThread = new Thread(this);
        this._oRunnerThread.start();
        this.fireTableDataChanged();
    }

    public void stop() {
        this._bActive = false;
        this._oRunnerThread.interrupt();
    }

    public long getTGTCounter() {
        return this._oTGTManager.getTGTCounter();
    }

    public int getRowCount() {
        return this._htTGTContexts.size();
    }

    public int getColumnCount() {
        return this._saHeaders.length;
    }

    public Object getValueAt(int n, int n2) {
        String string = this._saTGTs[n];
        Hashtable hashtable = (Hashtable)this._htTGTContexts.get(string);
        if (n2 == 0) {
            return (String)hashtable.get("uid");
        }
        if (n2 == 1) {
            String string2 = (String)hashtable.get("proxy_organization");
            if (string2 == null) {
                return (String)hashtable.get("organization");
            }
            return (String)hashtable.get("organization") + "@" + string2;
        }
        if (n2 == 2) {
            try {
                long l = this._oTGTManager.getExpirationTime(string);
                return new Date(l).toString();
            }
            catch (ASelectStorageException aSelectStorageException) {
                return "unknown";
            }
        }
        if (n2 == 3) {
            return (String)hashtable.get("authsp");
        }
        if (n2 == 4) {
            return (String)hashtable.get("authsp_level");
        }
        if (n2 == 5) {
            return (String)hashtable.get("app_id");
        }
        if (n2 == 6) {
            return string;
        }
        return null;
    }

    public String getColumnName(int n) {
        return this._saHeaders[n];
    }

    public void run() {
        while (this._bActive) {
            try {
                Thread.sleep(this._iCheckInterval * 1000);
                this.getServerStatus();
                this.fireTableDataChanged();
            }
            catch (Exception exception) {}
        }
        ASelectSystemLogger.getHandle().log(Level.INFO, MODULE, "run()", "TGT Monitor model stopped");
    }

    private void getServerStatus() {
        try {
            this._htTGTContexts = this._oTGTManager.getAll();
            int n = 0;
            Enumeration enumeration = this._htTGTContexts.keys();
            while (enumeration.hasMoreElements()) {
                this._saTGTs[n++] = (String)enumeration.nextElement();
            }
        }
        catch (Exception exception) {
            ASelectSystemLogger.getHandle().log(Level.WARNING, MODULE, "getServerStatus()", "No session contexts available");
        }
    }
}

