/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.admin.AdminMonitor;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.attributes.AttributeGatherer;
import org.aselect.server.authspprotocol.handler.AuthSPHandlerManager;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.RequestHandlerFactory;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.servlet.ASelectHttpServlet;

public class ASelectServer
extends ASelectHttpServlet {
    public static final String MODULE = "ASelectServer";
    private ASelectConfigManager _configManager;
    private SessionManager _sessionManager;
    private ApplicationManager _applicationManager;
    private AuthSPHandlerManager _authspHandlerManager;
    private CrossASelectManager _crossASelectManager;
    private ASelectAuthenticationLogger _authenticationLogger;
    private ASelectSystemLogger _systemLogger;
    private AttributeGatherer _oAttributeGatherer;
    private TGTManager _tgtManager;
    private CryptoEngine _cryptoEngine;
    private AdminMonitor _adminMonitor = null;
    private RequestHandlerFactory _oRequestHandlerFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        Object object;
        Object object2;
        String string2 = "init()";
        try {
            super.init(servletConfig);
            if (this._systemLogger != null) {
                this._systemLogger.closeHandlers();
            } else {
                this._systemLogger = ASelectSystemLogger.getHandle();
            }
            if (this._authenticationLogger != null) {
                this._authenticationLogger.closeHandlers();
            } else {
                this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
            }
            object2 = servletConfig.getInitParameter("working_dir");
            if (object2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not retrieve 'working_dir' parameter from deployment descriptor.");
                throw new ASelectConfigException("4009");
            }
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            object2 = (String)object2 + "aselectserver";
            object = servletConfig.getInitParameter("sql_driver");
            string = servletConfig.getInitParameter("sql_url");
            String string3 = servletConfig.getInitParameter("sql_user");
            String string4 = servletConfig.getInitParameter("sql_password");
            String string5 = servletConfig.getInitParameter("sql_table");
            this._configManager = ASelectConfigManager.getHandle();
            this._configManager.init((String)object2, (String)object, string3, string4, string, string5, MODULE);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Initializing failed", aSelectException);
            this.closeLoggers();
            throw new ServletException("Initializing failed");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Initializing failed", exception);
            this.closeLoggers();
            throw new ServletException("Initializing failed");
        }
        object2 = null;
        try {
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not find aselect config section in config file", aSelectConfigException);
                throw aSelectConfigException;
            }
            object = null;
            try {
                object = this._configManager.getSection(null, "requests");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config section 'requests' found", aSelectConfigException);
            }
            try {
                this._oRequestHandlerFactory = RequestHandlerFactory.getHandle();
                this._oRequestHandlerFactory.init(servletConfig, object);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Can't initialize RequestHandlerFactory", aSelectException);
                throw aSelectException;
            }
            try {
                this._oAttributeGatherer = AttributeGatherer.getHandle();
                this._oAttributeGatherer.init();
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Can't initialize AttributeGatherer", aSelectException);
                throw aSelectException;
            }
            try {
                this._sessionManager = SessionManager.getHandle();
                this._sessionManager.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Can't initialize SessionManager", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._tgtManager = TGTManager.getHandle();
                this._tgtManager.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Can't initialize TicketManager", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._applicationManager = ApplicationManager.getHandle();
                this._applicationManager.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Can't initialize ApplicationManager", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._crossASelectManager = CrossASelectManager.getHandle();
                this._crossASelectManager.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Can't initialize CrossASelectManager", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._authspHandlerManager = AuthSPHandlerManager.getHandle();
                this._authspHandlerManager.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Can't initialize AuthSPHandlerManager", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                this._cryptoEngine = CryptoEngine.getHandle();
                this._cryptoEngine.init();
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Can't initialize CryptoEngine", aSelectConfigException);
                throw aSelectConfigException;
            }
            try {
                string = this._configManager.getParam(object2, "admin_gui");
                if (string.equalsIgnoreCase("true")) {
                    if (this._adminMonitor == null) {
                        this._adminMonitor = new AdminMonitor();
                        this._adminMonitor.start(5);
                    } else {
                        this._adminMonitor.stop();
                        this._adminMonitor.start(5);
                    }
                }
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "admin_gui option not found in config file", aSelectConfigException);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Can't start AdminMonitor", exception);
                throw exception;
            }
            this._systemLogger.log(Level.INFO, MODULE, string2, "Successfully started A-Select server.");
        }
        catch (ASelectException aSelectException) {
            string = this._configManager.getErrorMessage(aSelectException.getMessage());
            this._systemLogger.log(Level.SEVERE, MODULE, string2, string, aSelectException);
            this.closeResources();
            this.closeLoggers();
            throw new ServletException(string);
        }
        catch (Exception exception) {
            string = this._configManager.getErrorMessage("0001");
            this._systemLogger.log(Level.SEVERE, MODULE, string2, string, exception);
            this.closeResources();
            this.closeLoggers();
            throw new ServletException(string);
        }
    }

    public void destroy() {
        this.closeResources();
        this._systemLogger.log(Level.INFO, MODULE, "destroy()", "A-Select server stopped.");
        this.closeLoggers();
        super.destroy();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block7: {
            String string = "service()";
            try {
                this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
                if (this.isRestartInProgress()) {
                    httpServletResponse.sendError(503);
                    return;
                }
                this._oRequestHandlerFactory.process(httpServletRequest, httpServletResponse);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Error while processing request", aSelectException);
                if (!httpServletResponse.isCommitted()) {
                    if (aSelectException.getMessage().equals("0001")) {
                        httpServletResponse.sendError(500);
                    } else {
                        httpServletResponse.sendError(400);
                    }
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error", exception);
                if (httpServletResponse.isCommitted()) break block7;
                httpServletResponse.sendError(500);
            }
        }
    }

    protected boolean isRestartableServlet() {
        return true;
    }

    private void closeResources() {
        if (this._adminMonitor != null) {
            this._adminMonitor.stop();
            try {
                this._adminMonitor.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._oAttributeGatherer != null) {
            this._oAttributeGatherer.destroy();
        }
        if (this._oRequestHandlerFactory != null) {
            this._oRequestHandlerFactory.destroy();
        }
        ASelectSAMAgent.getHandle().destroy();
        this._tgtManager.destroy();
        this._sessionManager.destroy();
        this._cryptoEngine.stop();
    }

    private void closeLoggers() {
        if (this._authenticationLogger != null) {
            this._authenticationLogger.closeHandlers();
            this._authenticationLogger = null;
        }
        if (this._systemLogger != null) {
            this._systemLogger.closeHandlers();
            this._systemLogger = null;
        }
    }
}

