/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes.requestors.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.attributes.requestors.GenericAttributeRequestor;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.sam.agent.SAMResource;

public class JDBCAttributeRequestor
extends GenericAttributeRequestor {
    private static final String MODULE = "JDBCAttributeRequestor";
    private Connection oActiveConnection = null;
    private String _sResourceGroup = null;
    private String _sQuery;
    private Vector _vTGTParameters;
    private Hashtable _htConfigParameters;
    private Hashtable _htReMapAttributes;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        this._htReMapAttributes = new Hashtable();
        try {
            String string2;
            Object object2;
            Object object3;
            try {
                this._sResourceGroup = this._configManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'resourcegroup' config item found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            this._vTGTParameters = new Vector();
            this._htConfigParameters = new Hashtable();
            Object object4 = null;
            try {
                object4 = this._configManager.getSection(object, "parameters");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve 'parameters' configuration section; no parameters will be send", (Throwable)aSelectConfigException);
            }
            if (object4 != null) {
                object3 = null;
                try {
                    object3 = this._configManager.getSection(object4, "parameter");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve one 'parameter' in 'parameters' configuration section", (Throwable)aSelectConfigException);
                }
                while (object3 != null) {
                    try {
                        object2 = this._configManager.getParam(object3, "id");
                        boolean bl = false;
                        try {
                            string2 = this._configManager.getParam(object3, "session");
                            if (string2.equals("true")) {
                                bl = true;
                            }
                        }
                        catch (ASelectConfigException aSelectConfigException) {
                            // empty catch block
                        }
                        if (bl) {
                            this._vTGTParameters.add(object2);
                        } else {
                            string2 = this._configManager.getParam(object3, "value");
                            this._htConfigParameters.put(object2, string2);
                        }
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve mandatory parameter in attribute", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    object3 = this._configManager.getNextSection(object3);
                }
            }
            try {
                this._sQuery = this._configManager.getParam(object, "query");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'query' parameter found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            object3 = null;
            try {
                object3 = this._configManager.getSection(object, "attribute_mapping");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'attribute_mapping' config section found, no mapping used", (Throwable)aSelectConfigException);
            }
            if (object3 != null) {
                object2 = null;
                try {
                    object2 = this._configManager.getSection(object3, "attribute");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "Not one valid 'attribute' config section in 'attributes' section found, no mapping used", (Throwable)aSelectConfigException);
                }
                while (object2 != null) {
                    String string3 = null;
                    string2 = null;
                    try {
                        string3 = this._configManager.getParam(object2, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    try {
                        string2 = this._configManager.getParam(object2, "map");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'map' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    this._htReMapAttributes.put(string2, string3);
                    object2 = this._configManager.getNextSection(object2);
                }
            }
            this.getConnection();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to instantiate JDBCAttributeRequestor", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
    }

    public Hashtable getAttributes(Hashtable hashtable, Vector vector) throws ASelectAttributesException {
        Object object = new Hashtable();
        String string = "getAttributes()";
        try {
            String string2;
            Object object2;
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(this._sQuery);
            ResultSet resultSet = null;
            Enumeration<Object> enumeration = this._vTGTParameters.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(object2);
                if (string2 == null) {
                    StringBuffer stringBuffer = new StringBuffer("Error retrieving '");
                    stringBuffer.append((String)object2);
                    stringBuffer.append("' parameter from session context.");
                    this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                    throw new ASelectAttributesException("4011");
                }
                preparedStatement.setString(n, string2);
                ++n;
            }
            try {
                String string3;
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    object2 = null;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    if (((Hashtable)object).containsKey(string2)) {
                        Object v = ((Hashtable)object).get(string2);
                        if (v instanceof Vector) {
                            object2 = (Vector)v;
                        } else {
                            object2 = new Vector<String>();
                            ((Vector)object2).add(v.toString());
                        }
                        ((Vector)object2).add(string3);
                        ((Hashtable)object).put(string2, object2);
                        continue;
                    }
                    ((Hashtable)object).put(string2, string3);
                }
                object2 = new Hashtable();
                enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    string3 = ((Hashtable)object).get(string2);
                    if (this._htReMapAttributes.containsKey(string2)) {
                        string2 = (String)this._htReMapAttributes.get(string2);
                    }
                    ((Hashtable)object2).put(string2, string3);
                }
                object = object2;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not execute query: " + this._sQuery, (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to resolve attributes", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
        return object;
    }

    public void destroy() {
        String string = "destroy()";
        try {
            if (this.oActiveConnection != null) {
                this.oActiveConnection.close();
                this.oActiveConnection = null;
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "Connection close failed.", (Throwable)exception);
        }
    }

    private Connection getConnection() throws ASelectSAMException {
        String string = "getConnection()";
        SAMResource sAMResource = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object = null;
        if (this.oActiveConnection != null) {
            return this.oActiveConnection;
        }
        try {
            sAMResource = this._samAgent.getActiveResource(this._sResourceGroup);
        }
        catch (ASelectSAMException aSelectSAMException) {
            StringBuffer stringBuffer = new StringBuffer("No active resource found in JDBCAttributeRequestor resourcegroup: ");
            stringBuffer.append(this._sResourceGroup);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        object = sAMResource.getAttributes();
        try {
            string2 = this._configManager.getParam(object, "driver");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'driver' found", (Throwable)exception);
            throw new ASelectSAMException("4011", (Throwable)exception);
        }
        try {
            Class.forName(string2);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't initialize driver: ");
            stringBuffer.append(string2);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectSAMException("0001", (Throwable)exception);
        }
        try {
            string4 = this._configManager.getParam(object, "password");
        }
        catch (Exception exception) {
            string4 = "";
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No or empty config item 'security_principal_password' found, using empty password. Don't use this in a live production environment.", (Throwable)exception);
        }
        try {
            string5 = this._configManager.getParam(object, "url");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'url' found", (Throwable)exception);
            throw new ASelectSAMException("4011", (Throwable)exception);
        }
        try {
            string3 = this._configManager.getParam(object, "username");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'username' found", (Throwable)exception);
            throw new ASelectSAMException("4011", (Throwable)exception);
        }
        try {
            this.oActiveConnection = DriverManager.getConnection(string5, string3, string4);
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer("Could not open connection to: ");
            stringBuffer.append(string5);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)sQLException);
            throw new ASelectSAMException("4006", (Throwable)sQLException);
        }
        return this.oActiveConnection;
    }

    public static void main(String[] stringArray) {
        String string = "jdbc:mysql://localhost/aselect";
        String string2 = "SELECT name, value FROM TBL_ATTRIBUTES WHERE ( uid=? OR uid='*' ) AND( organization=? OR organization='*' ) AND( app_id=? OR app_id='*' ) AND( authsp=? OR authsp='*' )";
        try {
            Class.forName("com.mysql.jdbc.Driver");
            Connection connection = DriverManager.getConnection(string, "aselect_user", "changeit");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("uid", "zandbelt");
            hashtable.put("organization", "SURFnetSG");
            hashtable.put("app_id", "federatiedemo");
            hashtable.put("authsp", "radius");
            Vector<String> vector = new Vector<String>();
            vector.add("uid");
            vector.add("organization");
            vector.add("app_id");
            vector.add("authsp");
            Hashtable hashtable2 = new Hashtable();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Object v = hashtable2.get(string3);
                if (v instanceof String) {
                    System.out.println(" key: \"" + string3 + "\", value: \"" + v + "\"");
                    continue;
                }
                Vector vector2 = (Vector)v;
                Enumeration enumeration2 = vector2.elements();
                System.out.print(" key: \"" + string3 + "\", value: [");
                while (enumeration2.hasMoreElements()) {
                    System.out.print("\"" + enumeration2.nextElement() + "\" ");
                }
                System.out.println("]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

