/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.ip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.servlet.ASelectHttpServlet;
import org.aselect.system.utils.Utils;

public class IPAuthSP
extends ASelectHttpServlet {
    private static final String MODULE = "IPAuthSP";
    private static final String VERSION = "A-Select IP AuthSP 1.5";
    private static final String DEFAULT_FAILUREHANDLING = "aselect";
    private CryptoEngine _oCryptoEngine;
    private AuthSPAuthenticationLogger _oAuthSPAuthenticationLogger;
    private AuthSPSystemLogger _oAuthSPSystemLogger;
    private AuthSPConfigManager _oAuthSPConfigManager;
    private Properties _propErrorMessages;
    private Hashtable _htIPRanges;
    private String _sWorkingDir;
    private String _sErrorHTMLTemplate;
    private String _sFailureHandling;
    private String _sFriendlyName;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        Object object = null;
        try {
            CharSequence charSequence;
            Object object2;
            CharSequence charSequence2;
            super.init(servletConfig);
            this._oAuthSPSystemLogger = AuthSPSystemLogger.getHandle();
            this._oAuthSPAuthenticationLogger = AuthSPAuthenticationLogger.getHandle();
            this._oAuthSPConfigManager = AuthSPConfigManager.getHandle();
            StringBuffer stringBuffer = new StringBuffer("Starting : ");
            stringBuffer.append(MODULE);
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            ServletContext servletContext = servletConfig.getServletContext();
            this._oCryptoEngine = (CryptoEngine)servletContext.getAttribute("CryptoEngine");
            if (this._oCryptoEngine == null) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No CryptoEngine found in servlet context.");
                throw new ASelectException("100");
            }
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, "Successfully loaded CryptoEngine.");
            this._sFriendlyName = (String)servletContext.getAttribute("friendly_name");
            if (this._sFriendlyName == null) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No 'friendly_name' found in servlet context.");
                throw new ASelectException("100");
            }
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'friendly_name'.");
            this._sWorkingDir = (String)servletContext.getAttribute("working_dir");
            if (this._sWorkingDir == null) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No working_dir found in servlet context.");
                throw new ASelectException("100");
            }
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, "Successfully loaded working_dir");
            String string2 = servletConfig.getInitParameter("config_id");
            if (string2 == null) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No 'config_id' found as init-parameter in web.xml.");
                throw new ASelectException("100");
            }
            try {
                object = this._oAuthSPConfigManager.getSection(null, "authsp", "id=" + string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer2 = new StringBuffer("No valid 'authsp' config section found with id='");
                stringBuffer2.append(string2);
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            this._htIPRanges = new Hashtable();
            Object object3 = null;
            try {
                object3 = this._oAuthSPConfigManager.getSection(object, "ipranges");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'ipranges' config section found", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            Object object4 = null;
            try {
                object4 = this._oAuthSPConfigManager.getSection(object3, "iprange");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "Not even one valid 'iprange' config item found", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            while (object4 != null) {
                charSequence2 = null;
                try {
                    charSequence2 = this._oAuthSPConfigManager.getParam(object4, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item found", (Throwable)aSelectConfigException);
                    throw new ASelectException("100", (Throwable)aSelectConfigException);
                }
                object2 = null;
                try {
                    object2 = this._oAuthSPConfigManager.getParam(object4, "begin");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'begin' config item found", (Throwable)aSelectConfigException);
                    throw new ASelectException("100", (Throwable)aSelectConfigException);
                }
                charSequence = null;
                try {
                    charSequence = this._oAuthSPConfigManager.getParam(object4, "end");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'end' config item found", (Throwable)aSelectConfigException);
                    throw new ASelectException("100", (Throwable)aSelectConfigException);
                }
                this._htIPRanges.put((String)charSequence2 + ".begin", ((String)object2).trim());
                this._htIPRanges.put((String)charSequence2 + ".end", ((String)charSequence).trim());
                object4 = this._oAuthSPConfigManager.getNextSection(object4);
            }
            charSequence2 = new StringBuffer(this._sWorkingDir);
            ((StringBuffer)charSequence2).append(File.separator);
            ((StringBuffer)charSequence2).append("conf");
            ((StringBuffer)charSequence2).append(File.separator);
            ((StringBuffer)charSequence2).append(string2);
            ((StringBuffer)charSequence2).append(File.separator);
            ((StringBuffer)charSequence2).append("errors");
            ((StringBuffer)charSequence2).append(File.separator);
            ((StringBuffer)charSequence2).append("errors.conf");
            object2 = new File(((StringBuffer)charSequence2).toString());
            if (!((File)object2).exists()) {
                charSequence = new StringBuffer("The error configuration file does not exist: \"");
                ((StringBuffer)charSequence).append(((StringBuffer)charSequence2).toString()).append("\".");
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, ((StringBuffer)charSequence).toString());
                throw new ASelectException("100");
            }
            this._propErrorMessages = new Properties();
            this._propErrorMessages.load(new FileInputStream(((StringBuffer)charSequence2).toString()));
            stringBuffer = new StringBuffer("Successfully loaded ");
            stringBuffer.append(this._propErrorMessages.size());
            stringBuffer.append(" error messages from: \"");
            stringBuffer.append(((StringBuffer)charSequence2).toString()).append("\".");
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            this._sErrorHTMLTemplate = this._oAuthSPConfigManager.loadHTMLTemplate(this._sWorkingDir, "error.html", string2, this._sFriendlyName, VERSION);
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'error.html' template.");
            try {
                this._sFailureHandling = this._oAuthSPConfigManager.getParam(object, "failure_handling");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._oAuthSPSystemLogger.log(Level.CONFIG, MODULE, string, "No 'failure_handling' parameter found in configuration, using default: aselect", (Throwable)aSelectConfigException);
            }
            if (!this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) && !this._sFailureHandling.equalsIgnoreCase("local")) {
                charSequence = new StringBuffer("Invalid 'failure_handling' parameter found in configuration: '");
                ((StringBuffer)charSequence).append(this._sFailureHandling);
                ((StringBuffer)charSequence).append("', using default: aselect");
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._oAuthSPSystemLogger.log(Level.CONFIG, MODULE, string, ((StringBuffer)charSequence).toString());
            }
            stringBuffer = new StringBuffer("Successfully started ");
            stringBuffer.append(VERSION).append(".");
            this._oAuthSPSystemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
        }
        catch (Exception exception) {
            this._oAuthSPSystemLogger.log(Level.SEVERE, MODULE, string, "Initializing failed", (Throwable)exception);
            throw new ServletException("Initializing failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doGet()";
        PrintWriter printWriter = null;
        String string2 = "";
        try {
            String string3;
            httpServletResponse.setContentType("text/html");
            this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
            printWriter = httpServletResponse.getWriter();
            string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = Utils.convertCGIMessage((String)string2);
            String string4 = httpServletRequest.getRequestURL().toString();
            hashtable.put("my_url", string4);
            String string5 = (String)hashtable.get("rid");
            String string6 = (String)hashtable.get("uid");
            String string7 = (String)hashtable.get("as_url");
            String string8 = (String)hashtable.get("ip_range1");
            String string9 = (String)hashtable.get("a-select-server");
            String string10 = (String)hashtable.get("signature");
            if (string5 == null || string6 == null || string8 == null || string7 == null || string9 == null || string10 == null) {
                this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "Invalid request received: one or more mandatory parameters missing.");
                throw new ASelectException("200");
            }
            String string11 = (String)hashtable.get("country");
            if (string11 == null || string11.trim().length() < 1) {
                string11 = null;
            }
            if ((string3 = (String)hashtable.get("language")) == null || string3.trim().length() < 1) {
                string3 = null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            while (string8 != null) {
                stringBuffer.append(string8);
                string8 = (String)hashtable.get("ip_range" + ++n);
            }
            string7 = URLDecoder.decode(string7, "UTF-8");
            string6 = URLDecoder.decode(string6, "UTF-8");
            string10 = URLDecoder.decode(string10, "UTF-8");
            StringBuffer stringBuffer2 = new StringBuffer(string5);
            stringBuffer2.append(string6);
            stringBuffer2.append(string7);
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer2.append(string9);
            if (string11 != null) {
                stringBuffer2.append(string11);
            }
            if (string3 != null) {
                stringBuffer2.append(string3);
            }
            if (!this._oCryptoEngine.verifySignature(string9, stringBuffer2.toString(), string10)) {
                throw new ASelectException("200");
            }
            String string12 = this.checkIP(hashtable, httpServletRequest.getRemoteAddr());
            if (!string12.equals("000")) {
                this._oAuthSPAuthenticationLogger.log(new Object[]{MODULE, string6, httpServletRequest.getRemoteAddr(), string9, "denied"});
            } else {
                this._oAuthSPAuthenticationLogger.log(new Object[]{MODULE, string6, httpServletRequest.getRemoteAddr(), string9, "granted"});
            }
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, string12);
        }
        catch (ASelectException aSelectException) {
            this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string, "Sending error to client", (Throwable)aSelectException);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, aSelectException.getMessage());
        }
        catch (Exception exception) {
            this._oAuthSPSystemLogger.log(Level.SEVERE, MODULE, string, "Could not process request due to internal error", (Throwable)exception);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, "900");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    protected boolean isRestartableServlet() {
        return false;
    }

    private String checkIP(Hashtable hashtable, String string) {
        String string2 = "checkIP()";
        try {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            byte[] byArray;
            BigInteger bigInteger3;
            int n = 1;
            do {
                InetAddress inetAddress;
                InetAddress inetAddress2;
                String string3;
                if ((string3 = (String)hashtable.get("ip_range" + n++)) == null) {
                    return "800";
                }
                String string4 = (String)this._htIPRanges.get(string3 + ".begin");
                String string5 = (String)this._htIPRanges.get(string3 + ".end");
                if (string4 == null || string5 == null) {
                    StringBuffer stringBuffer = new StringBuffer("ip range not configured: ");
                    stringBuffer.append(string3);
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                    return "900";
                }
                try {
                    inetAddress2 = InetAddress.getByName(string4);
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("Configured 'begin' address isn't a valid ip address: ");
                    stringBuffer.append(string4);
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectException("100", (Throwable)exception);
                }
                try {
                    inetAddress = InetAddress.getByName(string5);
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("Configured 'end' address isn't a valid ip address: ");
                    stringBuffer.append(string5);
                    this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectException("100", (Throwable)exception);
                }
                InetAddress inetAddress3 = InetAddress.getByName(string);
                byte[] byArray2 = inetAddress2.getAddress();
                byte[] byArray3 = inetAddress.getAddress();
                byArray = inetAddress3.getAddress();
                bigInteger2 = new BigInteger(1, byArray2);
                bigInteger = new BigInteger(1, byArray3);
            } while ((bigInteger3 = new BigInteger(1, byArray)).compareTo(bigInteger2) < 0 || bigInteger3.compareTo(bigInteger) > 0);
            return "000";
        }
        catch (ASelectException aSelectException) {
            this._oAuthSPSystemLogger.log(Level.SEVERE, MODULE, string2, "could not perform ip check", (Throwable)aSelectException);
        }
        catch (Exception exception) {
            this._oAuthSPSystemLogger.log(Level.SEVERE, MODULE, string2, "internal error during ip check", (Throwable)exception);
        }
        return "800";
    }

    private void handleResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string) throws IOException {
        String string2 = "handleResult()";
        try {
            if (this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) || string.equals("000")) {
                String string3 = httpServletRequest.getParameter("rid");
                String string4 = httpServletRequest.getParameter("as_url");
                if (string3 == null || string4 == null) {
                    this.showErrorPage(printWriter, this._sErrorHTMLTemplate, string, this._oAuthSPConfigManager.getErrorMessage(string, this._propErrorMessages));
                } else {
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(string4);
                    stringBuffer.append(string);
                    String string5 = this._oCryptoEngine.generateSignature(stringBuffer.toString());
                    if (string5 != null) {
                        string5 = URLEncoder.encode(string5, "UTF-8");
                        StringBuffer stringBuffer2 = new StringBuffer(string4);
                        stringBuffer2.append("&rid=").append(string3);
                        stringBuffer2.append("&result_code=").append(string);
                        stringBuffer2.append("&signature=").append(string5);
                        httpServletResponse.sendRedirect(stringBuffer2.toString());
                    }
                }
            } else {
                this.showErrorPage(printWriter, this._sErrorHTMLTemplate, string, this._oAuthSPConfigManager.getErrorMessage(string, this._propErrorMessages));
            }
        }
        catch (ASelectException aSelectException) {
            this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string2, "Could not generate IP AuthSP signature", (Throwable)aSelectException);
            String string6 = this._oAuthSPConfigManager.getErrorMessage("900", this._propErrorMessages);
            this.showErrorPage(printWriter, this._sErrorHTMLTemplate, "900", string6);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._oAuthSPSystemLogger.log(Level.WARNING, MODULE, string2, "Could not encode IP AuthSP signature", (Throwable)unsupportedEncodingException);
            String string7 = this._oAuthSPConfigManager.getErrorMessage("900", this._propErrorMessages);
            this.showErrorPage(printWriter, this._sErrorHTMLTemplate, "900", string7);
        }
    }
}

