/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectAuthSPException;
import org.aselect.system.exception.ASelectConfigException;

public class Radius
implements IAuthSPProtocolHandler {
    private String _sAuthsp;
    private String _sAuthspUrl;
    private String _ASelectServerId;
    private ASelectConfigManager _oConfigManager;
    private SessionManager _oSessionManager;
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private static final String MODULE = "Radius";
    private static final String ERROR_RADIUS_NO_ERROR = "000";
    private static final String ERROR_RADIUS_ACCESS_DENIED = "800";

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        String string = "init()";
        Object object3 = null;
        try {
            this._oConfigManager = ASelectConfigManager.getHandle();
            this._oSessionManager = SessionManager.getHandle();
            this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
            this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
            try {
                this._sAuthsp = this._oConfigManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item found in authsp section");
                throw new ASelectAuthSPException("0001");
            }
            try {
                this._sAuthspUrl = this._oConfigManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid 'url' config item found in resource section of authsp with id='");
                stringBuffer.append(this._sAuthsp);
                stringBuffer.append("'");
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                throw new ASelectAuthSPException("0001");
            }
            try {
                object3 = this._oConfigManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No main 'aselect' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("0001");
            }
            try {
                this._ASelectServerId = this._oConfigManager.getParam(object3, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'server_id' config item found in main 'aselect' section");
                throw new ASelectAuthSPException("0001");
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)aSelectAuthSPException);
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize due to internal error", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0001");
        try {
            String string3;
            String string4;
            Hashtable hashtable2 = this._oSessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("could not fetch session context for rid=").append(string);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            if (hashtable3 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "allowed_user_authsps missing in session context");
                throw new ASelectAuthSPException("0003");
            }
            String string5 = (String)hashtable3.get(this._sAuthsp);
            if (string5 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "missing radius user attributes ");
                throw new ASelectAuthSPException("0003");
            }
            StringBuffer stringBuffer = new StringBuffer((String)hashtable2.get("my_url"));
            stringBuffer.append("?authsp=").append(this._sAuthsp);
            String string6 = stringBuffer.toString();
            String string7 = (String)hashtable2.get("country");
            if (string7 == null || string7.trim().length() < 1) {
                string7 = null;
            }
            if ((string4 = (String)hashtable2.get("language")) == null || string4.trim().length() < 1) {
                string4 = null;
            }
            StringBuffer stringBuffer2 = new StringBuffer(string);
            stringBuffer2.append(string6);
            stringBuffer2.append(string5);
            stringBuffer2.append(this._ASelectServerId);
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            if (string4 != null) {
                stringBuffer2.append(string4);
            }
            if ((string3 = CryptoEngine.getHandle().generateSignature(this._sAuthsp, stringBuffer2.toString())) == null) {
                stringBuffer = new StringBuffer("Could not generate signature for authsp: ").append(this._sAuthsp);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            string3 = URLEncoder.encode(string3, "UTF-8");
            string5 = URLEncoder.encode(string5, "UTF-8");
            string6 = URLEncoder.encode(string6, "UTF-8");
            StringBuffer stringBuffer3 = new StringBuffer(this._sAuthspUrl);
            stringBuffer3.append("?as_url=").append(string6);
            stringBuffer3.append("&rid=").append(string);
            stringBuffer3.append("&uid=").append(string5);
            stringBuffer3.append("&a-select-server=").append(this._ASelectServerId);
            stringBuffer3.append("&signature=").append(string3);
            if (string7 != null) {
                stringBuffer3.append("&country=").append(string7);
            }
            if (string4 != null) {
                stringBuffer3.append("&language=").append(string4);
            }
            hashtable.put("redirect_url", stringBuffer3.toString());
            hashtable.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Internal error", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationResponse()";
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0001");
        try {
            String string2 = (String)hashtable.get("rid");
            String string3 = (String)hashtable.get("my_url");
            String string4 = (String)hashtable.get("result_code");
            String string5 = (String)hashtable.get("signature");
            String string6 = (String)hashtable.get("a-select-server");
            if (string2 == null || string4 == null || string6 == null || string5 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "Incorrect AuthSP response: one or more parameters missing.");
                throw new ASelectAuthSPException("000a");
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            string3 = stringBuffer.toString();
            string5 = URLDecoder.decode(string5, "UTF-8");
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append(string6);
            boolean bl = false;
            bl = CryptoEngine.getHandle().verifySignature(this._sAuthsp, stringBuffer.toString(), string5);
            if (!bl) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "invalid signature in response from AuthSP");
                throw new ASelectAuthSPException("000a");
            }
            Hashtable hashtable3 = this._oSessionManager.getSessionContext(string2);
            if (hashtable3 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "Incorrect AuthSP response: invalid Session (could be expired)");
                throw new ASelectAuthSPException("0102");
            }
            String string7 = (String)hashtable3.get("user_id");
            String string8 = (String)hashtable3.get("organization");
            if (string4.equalsIgnoreCase(ERROR_RADIUS_ACCESS_DENIED)) {
                this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "denied"});
                throw new ASelectAuthSPException("000b");
            }
            if (!string4.equalsIgnoreCase(ERROR_RADIUS_NO_ERROR)) {
                stringBuffer = new StringBuffer("error from AuthSP: ");
                stringBuffer.append(string4);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "granted"});
            hashtable2.put("rid", string2);
            hashtable2.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable2.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Internal error", (Throwable)exception);
            hashtable2.put("result", "0003");
        }
        return hashtable2;
    }
}

