/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.domapi;

import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.domapi.XPathExpressionImpl;
import com.sun.org.apache.xpath.internal.domapi.XPathNSResolverImpl;
import com.sun.org.apache.xpath.internal.res.XPATHMessages;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

public class XPathEvaluatorImpl
implements XPathEvaluator {
    private Document m_doc = null;

    public XPathEvaluatorImpl() {
    }

    public XPathEvaluatorImpl(Document doc) {
        this.m_doc = doc;
    }

    public XPathExpression createExpression(String expression, XPathNSResolver resolver) throws XPathException, DOMException {
        try {
            XPath xpath = new XPath(expression, null, null == resolver ? new DummyPrefixResolver() : (PrefixResolver)((Object)resolver), 0);
            return new XPathExpressionImpl(xpath, this.m_doc);
        }
        catch (TransformerException e) {
            throw new DOMException(1, e.getMessageAndLocation());
        }
    }

    public XPathNSResolver createNSResolver(Node nodeResolver) {
        return new XPathNSResolverImpl(nodeResolver.getNodeType() == 9 ? ((Document)nodeResolver).getDocumentElement() : nodeResolver);
    }

    public Object evaluate(String expression, Node contextNode, XPathNSResolver resolver, short type, Object result) throws XPathException, DOMException {
        XPathExpression xpathExpression = this.createExpression(expression, resolver);
        return xpathExpression.evaluate(contextNode, type, result);
    }

    class DummyPrefixResolver
    implements PrefixResolver {
        public String getNamespaceForPrefix(String prefix, Node context) {
            String fmsg = XPATHMessages.createXPATHMessage("ER_NULL_RESOLVER", null);
            throw new DOMException(14, fmsg);
        }

        public String getNamespaceForPrefix(String prefix) {
            return this.getNamespaceForPrefix(prefix, null);
        }

        public boolean handlesNullPrefixes() {
            return false;
        }

        public String getBaseIdentifier() {
            return null;
        }
    }
}

