/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.nullauthsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.servlet.ASelectHttpServlet;
import org.aselect.system.utils.Utils;

public class NullAuthSP
extends ASelectHttpServlet {
    private static String MODULE = "NullAuthSP";
    private static String VERSION = "A-Select Null AuthSP 1.5";
    private AuthSPAuthenticationLogger _authenticationLogger;
    private AuthSPSystemLogger _systemLogger;
    private AuthSPConfigManager _configManager;
    private CryptoEngine _cryptoEngine;
    private String _sWorkingDir;
    private String _sErrorHtmlTemplate;
    private Properties _propErrorMessages;
    private String _sFriendlyName;
    private String _sAuthMode;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        Object object = null;
        try {
            super.init(servletConfig);
            this._authenticationLogger = AuthSPAuthenticationLogger.getHandle();
            this._systemLogger = AuthSPSystemLogger.getHandle();
            this._configManager = AuthSPConfigManager.getHandle();
            StringBuffer stringBuffer = new StringBuffer("Starting : ");
            stringBuffer.append(MODULE);
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            String string2 = servletConfig.getInitParameter("config_id");
            if (string2 == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "No 'config_id' found as init-parameter in web.xml.");
                throw new ASelectException("100");
            }
            ServletContext servletContext = servletConfig.getServletContext();
            this._cryptoEngine = (CryptoEngine)servletContext.getAttribute("CryptoEngine");
            if (this._cryptoEngine == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "No CryptoEngine found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded CryptoEngine");
            this._sFriendlyName = (String)servletContext.getAttribute("friendly_name");
            if (this._sFriendlyName == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "No friendly_name found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded friendly_name");
            this._sWorkingDir = (String)servletContext.getAttribute("working_dir");
            if (this._sWorkingDir == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "No working_dir found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded working_dir");
            StringBuffer stringBuffer2 = new StringBuffer(this._sWorkingDir);
            stringBuffer2.append(File.separator);
            stringBuffer2.append("conf");
            stringBuffer2.append(File.separator);
            stringBuffer2.append(MODULE.toLowerCase());
            stringBuffer2.append(File.separator);
            stringBuffer2.append("errors");
            stringBuffer2.append(File.separator);
            stringBuffer2.append("errors.conf");
            File file = new File(stringBuffer2.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer3 = new StringBuffer("The errors.conf doesn't exist: ");
                stringBuffer3.append(stringBuffer2.toString());
                this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer3.toString());
                throw new ASelectException("100");
            }
            this._propErrorMessages = new Properties();
            this._propErrorMessages.load(new FileInputStream(stringBuffer2.toString()));
            stringBuffer = new StringBuffer("Successfully loaded ");
            stringBuffer.append(this._propErrorMessages.size());
            stringBuffer.append(" error messages from: ");
            stringBuffer.append(stringBuffer2.toString());
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            this._sErrorHtmlTemplate = this._configManager.loadHTMLTemplate(this._sWorkingDir, "error.html", string2, this._sFriendlyName, VERSION);
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'error.html' template.");
            try {
                object = this._configManager.getSection(null, "authsp", "id=" + string2);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.INFO, MODULE, string, "No valid 'authsp' config section found with id='" + string2 + "', using default setting: authenitcation mode = granted.");
            }
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object, "authentication_mode");
            }
            catch (Exception exception) {
                string3 = null;
                this._systemLogger.log(Level.INFO, MODULE, string, "No valid 'authentication_mode' config item found, using default: authenitcation mode = granted.");
            }
            if (string3 == null) {
                string3 = "";
            }
            this._sAuthMode = string3.equalsIgnoreCase("denied") ? "800" : "000";
            stringBuffer = new StringBuffer("Successfully started: ");
            stringBuffer.append(MODULE);
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
        }
        catch (ASelectException aSelectException) {
            throw new ServletException((Throwable)aSelectException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "INTERNAL ERROR", (Throwable)exception);
            StringBuffer stringBuffer = new StringBuffer("Could not initialize ");
            stringBuffer.append(MODULE);
            stringBuffer.append(" : ");
            stringBuffer.append(exception.getMessage());
            throw new ServletException(stringBuffer.toString(), (Throwable)exception);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doGet()";
        httpServletResponse.setContentType("text/html");
        this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
        String string2 = "";
        try {
            String string3;
            string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = Utils.convertCGIMessage((String)string2);
            String string4 = httpServletRequest.getRequestURL().toString();
            hashtable.put("my_url", string4);
            String string5 = (String)hashtable.get("rid");
            String string6 = (String)hashtable.get("as_url");
            String string7 = (String)hashtable.get("uid");
            String string8 = (String)hashtable.get("a-select-server");
            String string9 = (String)hashtable.get("signature");
            if (string5 == null || string6 == null || string7 == null || string8 == null || string9 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Invalid request, at least one mandatory parameter is missing.");
                throw new ASelectException("200");
            }
            String string10 = (String)hashtable.get("country");
            if (string10 == null || string10.trim().length() < 1) {
                string10 = null;
            }
            if ((string3 = (String)hashtable.get("language")) == null || string3.trim().length() < 1) {
                string3 = null;
            }
            string6 = URLDecoder.decode(string6, "UTF-8");
            string7 = URLDecoder.decode(string7, "UTF-8");
            string9 = URLDecoder.decode(string9, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer(string5);
            stringBuffer.append(string6);
            stringBuffer.append(string7);
            stringBuffer.append(string8);
            if (string10 != null) {
                stringBuffer.append(string10);
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            if (!this._cryptoEngine.verifySignature(string8, stringBuffer.toString(), string9)) {
                throw new ASelectException("200");
            }
            if (this._sAuthMode.equals("000")) {
                this._authenticationLogger.log(new Object[]{MODULE, string7, httpServletRequest.getRemoteAddr(), string8, "granted"});
            } else {
                this._authenticationLogger.log(new Object[]{MODULE, string7, httpServletRequest.getRemoteAddr(), string8, "denied"});
            }
            this.handleResult(httpServletRequest, httpServletResponse, this._sAuthMode);
        }
        catch (ASelectException aSelectException) {
            this.handleResult(httpServletRequest, httpServletResponse, aSelectException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error", (Throwable)exception);
            this.handleResult(httpServletRequest, httpServletResponse, "900");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doPost";
        httpServletResponse.setContentType("text/html");
        this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
        try {
            this.handleResult(httpServletRequest, httpServletResponse, "200");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error", (Throwable)exception);
            throw new ServletException("100");
        }
    }

    protected boolean isRestartableServlet() {
        return false;
    }

    private void handleResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = "handleResult()";
        PrintWriter printWriter = null;
        try {
            printWriter = httpServletResponse.getWriter();
            if (string.equals("000")) {
                String string3 = httpServletRequest.getParameter("rid");
                String string4 = httpServletRequest.getParameter("as_url");
                String string5 = httpServletRequest.getParameter("a-select-server");
                if (string3 == null || string4 == null || string5 == null) {
                    this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._propErrorMessages));
                } else {
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(string4);
                    stringBuffer.append(string);
                    stringBuffer.append(string5);
                    String string6 = this._cryptoEngine.generateSignature(stringBuffer.toString());
                    string6 = URLEncoder.encode(string6, "UTF-8");
                    StringBuffer stringBuffer2 = new StringBuffer(string4);
                    stringBuffer2.append("&rid=").append(string3);
                    stringBuffer2.append("&result_code=").append(string);
                    stringBuffer2.append("&a-select-server=").append(string5);
                    stringBuffer2.append("&signature=").append(string6);
                    httpServletResponse.sendRedirect(stringBuffer2.toString());
                }
            } else {
                this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._propErrorMessages));
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not generate NULL AuthSP signature", (Throwable)aSelectException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage("900", this._propErrorMessages));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not encode NULL AuthSP signature", (Throwable)unsupportedEncodingException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage("900", this._propErrorMessages));
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "IO error while handling authentication result", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

